/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.breaker;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.opensearch.ml.breaker.ThresholdCircuitBreaker;
import org.opensearch.ml.common.exception.MLException;

public class DiskCircuitBreaker
extends ThresholdCircuitBreaker<Long> {
    private static final String ML_DISK_CB = "Disk Circuit Breaker";
    public static final long DEFAULT_DISK_SHORTAGE_THRESHOLD = 5L;
    private static final long GB = 0x40000000L;
    private String diskDir;

    public DiskCircuitBreaker(String diskDir) {
        super(5L);
        this.diskDir = diskDir;
    }

    public DiskCircuitBreaker(long threshold, String diskDir) {
        super(threshold);
        this.diskDir = diskDir;
    }

    @Override
    public String getName() {
        return ML_DISK_CB;
    }

    @Override
    public boolean isOpen() {
        try {
            return AccessController.doPrivileged(() -> new File(this.diskDir).getFreeSpace() / 0x40000000L < (Long)this.getThreshold());
        }
        catch (PrivilegedActionException e) {
            throw new MLException("Failed to run disk circuit breaker");
        }
    }
}

