/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.AggregatorFactory;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.bucket.range.BinaryRangeAggregator;
import org.opensearch.search.aggregations.bucket.range.IpRangeAggregationBuilder;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.aggregations.support.ValuesSourceRegistry;
import org.opensearch.search.internal.SearchContext;

public class BinaryRangeAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final List<BinaryRangeAggregator.Range> ranges;
    private final boolean keyed;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(IpRangeAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.IP, BinaryRangeAggregator::new, true);
    }

    public BinaryRangeAggregatorFactory(String name, ValuesSourceConfig config, List<BinaryRangeAggregator.Range> ranges, boolean keyed, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.ranges = ranges;
        this.keyed = keyed;
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        return new BinaryRangeAggregator(this.name, this.factories, null, this.config.format(), this.ranges, this.keyed, searchContext, parent, CardinalityUpperBound.NONE, metadata);
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(IpRangeAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.factories, this.config.getValuesSource(), this.config.format(), this.ranges, this.keyed, searchContext, parent, cardinality, metadata);
    }
}

