/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.ValidationException;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.index.Index;
import org.opensearch.indices.SystemIndices;

public class ShardLimitValidator {
    public static final String SETTING_MAX_SHARDS_PER_CLUSTER_KEY = "cluster.routing.allocation.total_shards_limit";
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_NODE = Setting.intSetting("cluster.max_shards_per_node", 1000, 1, (Setting.Validator<Integer>)new MaxShardPerNodeLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER = Setting.intSetting("cluster.routing.allocation.total_shards_limit", -1, -1, (Setting.Validator<Integer>)new MaxShardPerClusterLimitValidator(), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SETTING_CLUSTER_IGNORE_DOT_INDEXES = Setting.boolSetting("cluster.ignore_dot_indexes", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    protected final AtomicInteger shardLimitPerNode = new AtomicInteger();
    protected final AtomicInteger shardLimitPerCluster = new AtomicInteger();
    private final SystemIndices systemIndices;
    private volatile boolean ignoreDotIndexes;

    public ShardLimitValidator(Settings settings, ClusterService clusterService, SystemIndices systemIndices) {
        this.shardLimitPerNode.set(SETTING_CLUSTER_MAX_SHARDS_PER_NODE.get(settings));
        this.shardLimitPerCluster.set(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER.get(settings));
        this.ignoreDotIndexes = SETTING_CLUSTER_IGNORE_DOT_INDEXES.get(settings);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_NODE, this::setShardLimitPerNode);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER, this::setShardLimitPerCluster);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(SETTING_CLUSTER_IGNORE_DOT_INDEXES, this::setIgnoreDotIndexes);
        this.systemIndices = systemIndices;
    }

    private void setShardLimitPerNode(int newValue) {
        this.shardLimitPerNode.set(newValue);
    }

    private void setShardLimitPerCluster(int newValue) {
        this.shardLimitPerCluster.set(newValue);
    }

    public int getShardLimitPerNode() {
        return this.shardLimitPerNode.get();
    }

    public int getShardLimitPerCluster() {
        return this.shardLimitPerCluster.get();
    }

    private void setIgnoreDotIndexes(boolean newValue) {
        this.ignoreDotIndexes = newValue;
    }

    public void validateShardLimit(String indexName, Settings settings, ClusterState state) {
        int numberOfReplicas;
        if (this.shouldIndexBeIgnored(indexName)) {
            return;
        }
        int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings);
        int shardsToCreate = numberOfShards * (1 + (numberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(settings).intValue()));
        Optional<String> shardLimit = this.checkShardLimit(shardsToCreate, state);
        if (shardLimit.isPresent()) {
            ValidationException e = new ValidationException();
            e.addValidationError(shardLimit.get());
            throw e;
        }
    }

    public void validateShardLimit(ClusterState currentState, Index[] indicesToOpen) {
        int shardsToOpen = Arrays.stream(indicesToOpen).filter(index -> !this.shouldIndexBeIgnored(index.getName())).filter(index -> currentState.metadata().index((Index)index).getState().equals((Object)IndexMetadata.State.CLOSE)).mapToInt(index -> ShardLimitValidator.getTotalShardCount(currentState, index)).sum();
        Optional<String> error = this.checkShardLimit(shardsToOpen, currentState);
        if (error.isPresent()) {
            ValidationException ex = new ValidationException();
            ex.addValidationError(error.get());
            throw ex;
        }
    }

    private static int getTotalShardCount(ClusterState state, Index index) {
        IndexMetadata indexMetadata = state.metadata().index(index);
        return indexMetadata.getNumberOfShards() * (1 + indexMetadata.getNumberOfReplicas());
    }

    private boolean shouldIndexBeIgnored(String indexName) {
        if (this.ignoreDotIndexes) {
            return this.validateDotIndex(indexName) && !this.isDataStreamIndex(indexName);
        }
        return this.systemIndices.validateSystemIndex(indexName);
    }

    private boolean validateDotIndex(String indexName) {
        return indexName.charAt(0) == '.';
    }

    private boolean isDataStreamIndex(String indexName) {
        return indexName.startsWith(".ds-");
    }

    public Optional<String> checkShardLimit(int newShards, ClusterState state) {
        return ShardLimitValidator.checkShardLimit(newShards, state, this.getShardLimitPerNode(), this.getShardLimitPerCluster());
    }

    static Optional<String> checkShardLimit(int newShards, ClusterState state, int maxShardsPerNodeSetting, int maxShardsPerClusterSetting) {
        int nodeCount = state.getNodes().getDataNodes().size();
        if (nodeCount == 0 || newShards < 0) {
            return Optional.empty();
        }
        int maxShardsInCluster = maxShardsPerClusterSetting;
        maxShardsInCluster = maxShardsInCluster == -1 ? maxShardsPerNodeSetting * nodeCount : Math.min(maxShardsInCluster, maxShardsPerNodeSetting * nodeCount);
        int currentOpenShards = state.getMetadata().getTotalOpenIndexShards();
        if (currentOpenShards + newShards > maxShardsInCluster) {
            String errorMessage = "this action would add [" + newShards + "] total shards, but this cluster currently has [" + currentOpenShards + "]/[" + maxShardsInCluster + "] maximum shards open";
            return Optional.of(errorMessage);
        }
        return Optional.empty();
    }

    private static void doValidate(int maxShardPerCluster, int maxShardPerNode) {
        if (maxShardPerCluster != -1 && maxShardPerCluster < maxShardPerNode) {
            throw new IllegalArgumentException("MaxShardPerCluster " + maxShardPerCluster + " should be greater than or equal to MaxShardPerNode " + maxShardPerNode);
        }
    }

    static final class MaxShardPerNodeLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerNodeLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerNode, Map<Setting<?>, Object> settings) {
            int maxShardPerCluster = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_CLUSTER);
            return settings.iterator();
        }
    }

    static final class MaxShardPerClusterLimitValidator
    implements Setting.Validator<Integer> {
        MaxShardPerClusterLimitValidator() {
        }

        @Override
        public void validate(Integer value) {
        }

        @Override
        public void validate(Integer maxShardPerCluster, Map<Setting<?>, Object> settings) {
            int maxShardPerNode = (Integer)settings.get(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            ShardLimitValidator.doValidate(maxShardPerCluster, maxShardPerNode);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Integer>> settings = Collections.singletonList(SETTING_CLUSTER_MAX_SHARDS_PER_NODE);
            return settings.iterator();
        }
    }
}

