/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.lucene.util.BytesRef;

public final class Numbers {
    private static final BigInteger MAX_LONG_VALUE = BigInteger.valueOf(Long.MAX_VALUE);
    private static final BigInteger MIN_LONG_VALUE = BigInteger.valueOf(Long.MIN_VALUE);
    private static BigDecimal BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE = BigDecimal.valueOf(Long.MAX_VALUE).add(BigDecimal.ONE);
    private static BigDecimal BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE = BigDecimal.valueOf(Long.MIN_VALUE).subtract(BigDecimal.ONE);

    private Numbers() {
    }

    public static long bytesToLong(BytesRef bytes) {
        int high = bytes.bytes[bytes.offset + 0] << 24 | (bytes.bytes[bytes.offset + 1] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 2] & 0xFF) << 8 | bytes.bytes[bytes.offset + 3] & 0xFF;
        int low = bytes.bytes[bytes.offset + 4] << 24 | (bytes.bytes[bytes.offset + 5] & 0xFF) << 16 | (bytes.bytes[bytes.offset + 6] & 0xFF) << 8 | bytes.bytes[bytes.offset + 7] & 0xFF;
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static byte[] intToBytes(int val) {
        byte[] arr = new byte[]{(byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] shortToBytes(int val) {
        byte[] arr = new byte[]{(byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] longToBytes(long val) {
        byte[] arr = new byte[]{(byte)(val >>> 56), (byte)(val >>> 48), (byte)(val >>> 40), (byte)(val >>> 32), (byte)(val >>> 24), (byte)(val >>> 16), (byte)(val >>> 8), (byte)val};
        return arr;
    }

    public static byte[] doubleToBytes(double val) {
        return Numbers.longToBytes(Double.doubleToRawLongBits(val));
    }

    public static boolean isValidDouble(double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    public static long toLongExact(Number n) {
        if (n instanceof Byte || n instanceof Short || n instanceof Integer || n instanceof Long) {
            return n.longValue();
        }
        if (n instanceof Float || n instanceof Double) {
            double d = n.doubleValue();
            if (d != (double)Math.round(d)) {
                throw new IllegalArgumentException(n + " is not an integer value");
            }
            return n.longValue();
        }
        if (n instanceof BigDecimal) {
            return ((BigDecimal)n).toBigIntegerExact().longValueExact();
        }
        if (n instanceof BigInteger) {
            return ((BigInteger)n).longValueExact();
        }
        throw new IllegalArgumentException("Cannot check whether [" + n + "] of class [" + n.getClass().getName() + "] is actually a long");
    }

    public static long toLong(String stringValue, boolean coerce) {
        try {
            return Long.parseLong(stringValue);
        }
        catch (NumberFormatException numberFormatException) {
            BigInteger bigIntegerValue;
            try {
                BigDecimal bigDecimalValue = new BigDecimal(stringValue);
                if (bigDecimalValue.compareTo(BIGDECIMAL_GREATER_THAN_LONG_MAX_VALUE) >= 0 || bigDecimalValue.compareTo(BIGDECIMAL_LESS_THAN_LONG_MIN_VALUE) <= 0) {
                    throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
                }
                bigIntegerValue = coerce ? bigDecimalValue.toBigInteger() : bigDecimalValue.toBigIntegerExact();
            }
            catch (ArithmeticException e) {
                throw new IllegalArgumentException("Value [" + stringValue + "] has a decimal part");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("For input string: \"" + stringValue + "\"");
            }
            if (bigIntegerValue.compareTo(MAX_LONG_VALUE) > 0 || bigIntegerValue.compareTo(MIN_LONG_VALUE) < 0) {
                throw new IllegalArgumentException("Value [" + stringValue + "] is out of range for a long");
            }
            return bigIntegerValue.longValue();
        }
    }

    public static int toIntExact(Number n) {
        return Math.toIntExact(Numbers.toLongExact(n));
    }

    public static short toShortExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((short)l)) {
            throw new ArithmeticException("short overflow: " + l);
        }
        return (short)l;
    }

    public static byte toByteExact(Number n) {
        long l = Numbers.toLongExact(n);
        if (l != (long)((byte)l)) {
            throw new ArithmeticException("byte overflow: " + l);
        }
        return (byte)l;
    }
}

