/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentFragment;
import org.opensearch.common.xcontent.XContentBuilder;

public class WeightedRoutingStats
implements ToXContentFragment,
Writeable {
    private AtomicInteger failOpenCount;
    private static final WeightedRoutingStats INSTANCE = new WeightedRoutingStats();

    public static WeightedRoutingStats getInstance() {
        return INSTANCE;
    }

    private WeightedRoutingStats() {
        this.failOpenCount = new AtomicInteger(0);
    }

    public WeightedRoutingStats(StreamInput in) throws IOException {
        this.failOpenCount = new AtomicInteger(in.readInt());
    }

    public void updateFailOpenCount() {
        this.failOpenCount.getAndIncrement();
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("weighted_routing");
        builder.startObject("stats");
        builder.field("fail_open_count", this.getFailOpenCount());
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public int getFailOpenCount() {
        return this.failOpenCount.get();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeInt(this.failOpenCount.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedRoutingStats that = (WeightedRoutingStats)o;
        return this.failOpenCount.equals(that.failOpenCount);
    }

    public int hashCode() {
        return Objects.hash(this.failOpenCount);
    }

    public void resetFailOpenCount() {
        this.failOpenCount.set(0);
    }
}

