/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.reportsscheduler.index;

import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.action.ActionFuture;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.admin.indices.create.CreateIndexRequest;
import org.opensearch.action.admin.indices.create.CreateIndexResponse;
import org.opensearch.action.delete.DeleteRequest;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.get.GetResponse;
import org.opensearch.action.index.IndexRequest;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.update.UpdateRequest;
import org.opensearch.action.update.UpdateResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.reportsscheduler.metrics.Metrics;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetails;
import org.opensearch.reportsscheduler.model.ReportDefinitionDetailsSearchResults;
import org.opensearch.reportsscheduler.settings.PluginSettings;
import org.opensearch.reportsscheduler.util.HelpersKt;
import org.opensearch.reportsscheduler.util.SecureIndexClient;
import org.opensearch.search.builder.SearchSourceBuilder;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004J,\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00040\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u0004J\u0016\u0010\"\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\b\u0010#\u001a\u00020\u0017H\u0002J\u0016\u0010$\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lorg/opensearch/reportsscheduler/index/ReportDefinitionsIndex;", "", "()V", "REPORT_DEFINITIONS_INDEX_NAME", "", "REPORT_DEFINITIONS_MAPPING_FILE_NAME", "REPORT_DEFINITIONS_SETTINGS_FILE_NAME", "client", "Lorg/opensearch/client/Client;", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "createIndex", "", "createReportDefinition", "reportDefinitionDetails", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetails;", "deleteReportDefinition", "", "id", "getAllReportDefinitions", "Lorg/opensearch/reportsscheduler/model/ReportDefinitionDetailsSearchResults;", "tenant", "access", "", "from", "", "maxItems", "getReportDefinition", "initialize", "isIndexExists", "updateReportDefinition", "opensearch-reports-scheduler"})
public final class ReportDefinitionsIndex {
    @NotNull
    public static final ReportDefinitionsIndex INSTANCE = new ReportDefinitionsIndex();
    @NotNull
    private static final Lazy log$delegate = HelpersKt.logger(ReportDefinitionsIndex.class);
    @NotNull
    public static final String REPORT_DEFINITIONS_INDEX_NAME = ".opendistro-reports-definitions";
    @NotNull
    private static final String REPORT_DEFINITIONS_MAPPING_FILE_NAME = "report-definitions-mapping.yml";
    @NotNull
    private static final String REPORT_DEFINITIONS_SETTINGS_FILE_NAME = "report-definitions-settings.yml";
    private static Client client;
    private static ClusterService clusterService;

    private ReportDefinitionsIndex() {
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    public final void initialize(@NotNull Client client, @NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        ReportDefinitionsIndex.client = new SecureIndexClient(client);
        ReportDefinitionsIndex.clusterService = clusterService;
    }

    private final void createIndex() {
        block10: {
            if (!this.isIndexExists()) {
                String string;
                Object object;
                Object object2;
                String string2;
                ClassLoader classLoader = ReportDefinitionsIndex.class.getClassLoader();
                URL uRL = classLoader.getResource(REPORT_DEFINITIONS_MAPPING_FILE_NAME);
                if (uRL == null) {
                    string2 = null;
                } else {
                    URL uRL2 = uRL;
                    object2 = Charsets.UTF_8;
                    object = TextStreamsKt.readBytes((URL)uRL2);
                    string2 = new String((byte[])object, (Charset)object2);
                }
                Intrinsics.checkNotNull(string2);
                String indexMappingSource = string2;
                URL uRL3 = classLoader.getResource(REPORT_DEFINITIONS_SETTINGS_FILE_NAME);
                if (uRL3 == null) {
                    string = null;
                } else {
                    object2 = uRL3;
                    object = Charsets.UTF_8;
                    byte[] byArray = TextStreamsKt.readBytes((URL)object2);
                    string = new String(byArray, (Charset)object);
                }
                Intrinsics.checkNotNull(string);
                String indexSettingsSource = string;
                CreateIndexRequest request = new CreateIndexRequest(REPORT_DEFINITIONS_INDEX_NAME).mapping(indexMappingSource, XContentType.YAML).settings(indexSettingsSource, XContentType.YAML);
                try {
                    ActionFuture actionFuture;
                    CreateIndexResponse response;
                    Client client = ReportDefinitionsIndex.client;
                    if (client == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                        client = null;
                    }
                    if (!(response = (CreateIndexResponse)(actionFuture = client.admin().indices().create(request)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).isAcknowledged()) {
                        Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                        throw new IllegalStateException("reports:Index .opendistro-reports-definitions creation not Acknowledged".toString());
                    }
                    this.getLog().info("reports:Index .opendistro-reports-definitions creation Acknowledged");
                }
                catch (ResourceAlreadyExistsException exception) {
                    this.getLog().warn("message: " + exception.getMessage());
                }
                catch (Exception exception) {
                    if (exception.getCause() instanceof ResourceAlreadyExistsException) break block10;
                    Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
                    throw exception;
                }
            }
        }
    }

    private final boolean isIndexExists() {
        ClusterService clusterService = ReportDefinitionsIndex.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        ClusterState clusterState = clusterService.state();
        return clusterState.getRoutingTable().hasIndex(REPORT_DEFINITIONS_INDEX_NAME);
    }

    @Nullable
    public final String createReportDefinition(@NotNull ReportDefinitionDetails reportDefinitionDetails) {
        String string;
        ActionFuture actionFuture;
        IndexResponse response;
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        IndexRequest indexRequest = new IndexRequest(REPORT_DEFINITIONS_INDEX_NAME).source(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).create(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (IndexResponse)(actionFuture = client.index(indexRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.CREATED) {
            Metrics.REPORT_DEFINITION_CREATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:createReportDefinition - response:" + response);
            string = null;
        } else {
            string = response.getId();
        }
        return string;
    }

    @Nullable
    public final ReportDefinitionDetails getReportDefinition(@NotNull String id) {
        ReportDefinitionDetails reportDefinitionDetails;
        ActionFuture actionFuture;
        GetResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        GetRequest getRequest = new GetRequest(REPORT_DEFINITIONS_INDEX_NAME).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (GetResponse)(actionFuture = client.get(getRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getSourceAsString() == null) {
            this.getLog().warn("reports:getReportDefinition - " + id + " not found; response:" + response);
            reportDefinitionDetails = null;
        } else {
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, response.getSourceAsString());
            parser.nextToken();
            Intrinsics.checkNotNullExpressionValue((Object)parser, (String)"parser");
            reportDefinitionDetails = ReportDefinitionDetails.Companion.parse(parser, id);
        }
        return reportDefinitionDetails;
    }

    @NotNull
    public final ReportDefinitionDetailsSearchResults getAllReportDefinitions(@NotNull String tenant, @NotNull List<String> access, int from, int maxItems) {
        String[] query;
        Intrinsics.checkNotNullParameter((Object)tenant, (String)"tenant");
        Intrinsics.checkNotNullParameter(access, (String)"access");
        this.createIndex();
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().timeout(new TimeValue(PluginSettings.INSTANCE.getOperationTimeoutMs(), TimeUnit.MILLISECONDS)).sort("lastUpdatedTimeMs").size(maxItems).from(from);
        String[] stringArray = new String[]{tenant};
        TermsQueryBuilder tenantQuery = QueryBuilders.termsQuery((String)"tenant", (String[])stringArray);
        if (!((Collection)access).isEmpty()) {
            TermsQueryBuilder accessQuery = QueryBuilders.termsQuery((String)"access", (Collection)access);
            query = QueryBuilders.boolQuery();
            query.filter((QueryBuilder)tenantQuery);
            query.filter((QueryBuilder)accessQuery);
            sourceBuilder.query((QueryBuilder)query);
        } else {
            sourceBuilder.query((QueryBuilder)tenantQuery);
        }
        query = new String[]{REPORT_DEFINITIONS_INDEX_NAME};
        SearchRequest searchRequest = new SearchRequest().indices(query).source(sourceBuilder);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        ActionFuture actionFuture = client.search(searchRequest);
        SearchResponse response = (SearchResponse)actionFuture.actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs());
        long l = from;
        Intrinsics.checkNotNullExpressionValue((Object)response, (String)"response");
        ReportDefinitionDetailsSearchResults result = new ReportDefinitionDetailsSearchResults(l, response);
        this.getLog().info("reports:getAllReportDefinitions from:" + from + ", maxItems:" + maxItems + ", retCount:" + result.getObjectList().size() + ", totalCount:" + result.getTotalHits());
        return result;
    }

    public final boolean updateReportDefinition(@NotNull String id, @NotNull ReportDefinitionDetails reportDefinitionDetails) {
        ActionFuture actionFuture;
        UpdateResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)reportDefinitionDetails, (String)"reportDefinitionDetails");
        this.createIndex();
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id).doc(ReportDefinitionDetails.toXContent$default(reportDefinitionDetails, null, 1, null)).fetchSource(true);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (UpdateResponse)(actionFuture = client.update(updateRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.UPDATED) {
            Metrics.REPORT_DEFINITION_UPDATE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:updateReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.UPDATED;
    }

    public final boolean deleteReportDefinition(@NotNull String id) {
        ActionFuture actionFuture;
        DeleteResponse response;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.createIndex();
        DeleteRequest deleteRequest = ((DeleteRequest)new DeleteRequest().index(REPORT_DEFINITIONS_INDEX_NAME)).id(id);
        Client client = ReportDefinitionsIndex.client;
        if (client == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            client = null;
        }
        if ((response = (DeleteResponse)(actionFuture = client.delete(deleteRequest)).actionGet(PluginSettings.INSTANCE.getOperationTimeoutMs())).getResult() != DocWriteResponse.Result.DELETED) {
            Metrics.REPORT_DEFINITION_DELETE_SYSTEM_ERROR.getCounter().increment();
            this.getLog().warn("reports:deleteReportDefinition failed for " + id + "; response:" + response);
        }
        return response.getResult() == DocWriteResponse.Result.DELETED;
    }
}

