/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.notifications.settings;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.opensearch.bootstrap.BootstrapInfo;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.commons.utils.OpenForTesting;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00103\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 J\u0010\u00105\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000406J\u0006\u00107\u001a\u00020\u0005J\b\u00108\u001a\u000204H\u0007J\u0010\u00109\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010:\u001a\u0002042\u0006\u0010\u001f\u001a\u00020 H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0007R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0007R\u000e\u0010\u0019\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0011X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0007R\u000e\u0010\u001e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010-\u001a\u0004\b*\u0010+R\u001a\u0010.\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102\u00a8\u0006;"}, d2={"Lorg/opensearch/notifications/settings/PluginSettings;", "", "()V", "ALERTING_FILTER_BY_BACKEND_ROLES", "Lorg/opensearch/common/settings/Setting;", "", "getALERTING_FILTER_BY_BACKEND_ROLES", "()Lorg/opensearch/common/settings/Setting;", "ALERTING_FILTER_BY_BACKEND_ROLES_KEY", "", "DECIMAL_RADIX", "", "DEFAULT_ITEMS_QUERY_COUNT", "getDEFAULT_ITEMS_QUERY_COUNT", "DEFAULT_ITEMS_QUERY_COUNT_KEY", "DEFAULT_ITEMS_QUERY_COUNT_VALUE", "DEFAULT_OPERATION_TIMEOUT_MS", "", "FILTER_BY_BACKEND_ROLES", "getFILTER_BY_BACKEND_ROLES", "FILTER_BY_BACKEND_ROLES_KEY", "GENERAL_KEY_PREFIX", "KEY_PREFIX", "LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES", "getLEGACY_ALERTING_FILTER_BY_BACKEND_ROLES", "LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES_KEY", "MINIMUM_ITEMS_QUERY_COUNT", "MINIMUM_OPERATION_TIMEOUT_MS", "OPERATION_TIMEOUT_MS", "getOPERATION_TIMEOUT_MS", "OPERATION_TIMEOUT_MS_KEY", "clusterService", "Lorg/opensearch/cluster/service/ClusterService;", "defaultItemsQueryCount", "getDefaultItemsQueryCount", "()I", "setDefaultItemsQueryCount", "(I)V", "defaultSettings", "", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "operationTimeoutMs", "getOperationTimeoutMs", "()J", "setOperationTimeoutMs", "(J)V", "addSettingsUpdateConsumer", "", "getAllSettings", "", "isRbacEnabled", "reset", "updateSettingValuesFromCluster", "updateSettingValuesFromLocal", "opensearch-notifications"})
public final class PluginSettings {
    @NotNull
    public static final PluginSettings INSTANCE;
    private static ClusterService clusterService;
    @NotNull
    private static final String KEY_PREFIX = "opensearch.notifications";
    @NotNull
    private static final String GENERAL_KEY_PREFIX = "opensearch.notifications.general";
    @NotNull
    private static final String OPERATION_TIMEOUT_MS_KEY = "opensearch.notifications.general.operation_timeout_ms";
    @NotNull
    private static final String DEFAULT_ITEMS_QUERY_COUNT_KEY = "opensearch.notifications.general.default_items_query_count";
    @NotNull
    private static final String LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES_KEY = "opendistro.alerting.filter_by_backend_roles";
    @NotNull
    private static final String ALERTING_FILTER_BY_BACKEND_ROLES_KEY = "plugins.alerting.filter_by_backend_roles";
    @NotNull
    private static final String FILTER_BY_BACKEND_ROLES_KEY = "opensearch.notifications.general.filter_by_backend_roles";
    private static final long DEFAULT_OPERATION_TIMEOUT_MS = 60000L;
    private static final long MINIMUM_OPERATION_TIMEOUT_MS = 100L;
    private static final int DEFAULT_ITEMS_QUERY_COUNT_VALUE = 100;
    private static final int MINIMUM_ITEMS_QUERY_COUNT = 10;
    private static volatile long operationTimeoutMs;
    private static volatile int defaultItemsQueryCount;
    private static final int DECIMAL_RADIX = 10;
    @NotNull
    private static final Lazy log$delegate;
    @NotNull
    private static final Map<String, String> defaultSettings;
    @NotNull
    private static final Setting<Long> OPERATION_TIMEOUT_MS;
    @NotNull
    private static final Setting<Integer> DEFAULT_ITEMS_QUERY_COUNT;
    @NotNull
    private static final Setting<Boolean> LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES;
    @NotNull
    private static final Setting<Boolean> ALERTING_FILTER_BY_BACKEND_ROLES;
    @NotNull
    private static final Setting<Boolean> FILTER_BY_BACKEND_ROLES;

    private PluginSettings() {
    }

    public final long getOperationTimeoutMs() {
        return operationTimeoutMs;
    }

    public final void setOperationTimeoutMs(long l) {
        operationTimeoutMs = l;
    }

    public final int getDefaultItemsQueryCount() {
        return defaultItemsQueryCount;
    }

    public final void setDefaultItemsQueryCount(int n) {
        defaultItemsQueryCount = n;
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final Setting<Long> getOPERATION_TIMEOUT_MS() {
        return OPERATION_TIMEOUT_MS;
    }

    @NotNull
    public final Setting<Integer> getDEFAULT_ITEMS_QUERY_COUNT() {
        return DEFAULT_ITEMS_QUERY_COUNT;
    }

    @NotNull
    public final Setting<Boolean> getLEGACY_ALERTING_FILTER_BY_BACKEND_ROLES() {
        return LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES;
    }

    @NotNull
    public final Setting<Boolean> getALERTING_FILTER_BY_BACKEND_ROLES() {
        return ALERTING_FILTER_BY_BACKEND_ROLES;
    }

    @NotNull
    public final Setting<Boolean> getFILTER_BY_BACKEND_ROLES() {
        return FILTER_BY_BACKEND_ROLES;
    }

    public final boolean isRbacEnabled() {
        ClusterService clusterService = PluginSettings.clusterService;
        if (clusterService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
            clusterService = null;
        }
        if (clusterService.getClusterSettings().get(FILTER_BY_BACKEND_ROLES_KEY) != null) {
            ClusterService clusterService2 = PluginSettings.clusterService;
            if (clusterService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"clusterService");
                clusterService2 = null;
            }
            Boolean bl = (Boolean)clusterService2.getClusterSettings().get(FILTER_BY_BACKEND_ROLES);
            return bl == null ? false : bl;
        }
        return false;
    }

    @NotNull
    public final List<Setting<?>> getAllSettings() {
        Object[] objectArray = new Setting[]{OPERATION_TIMEOUT_MS, DEFAULT_ITEMS_QUERY_COUNT, FILTER_BY_BACKEND_ROLES};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final void updateSettingValuesFromLocal(ClusterService clusterService) {
        Object object = OPERATION_TIMEOUT_MS.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPERATION_TIMEOUT_MS.get(clusterService.settings)");
        operationTimeoutMs = ((Number)object).longValue();
        object = DEFAULT_ITEMS_QUERY_COUNT.get(clusterService.getSettings());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DEFAULT_ITEMS_QUERY_COUN\u2026(clusterService.settings)");
        defaultItemsQueryCount = ((Number)object).intValue();
    }

    private final void updateSettingValuesFromCluster(ClusterService clusterService) {
        Integer clusterDefaultItemsQueryCount;
        Long clusterOperationTimeoutMs = (Long)clusterService.getClusterSettings().get(OPERATION_TIMEOUT_MS);
        if (clusterOperationTimeoutMs != null) {
            this.getLog().debug("notifications:opensearch.notifications.general.operation_timeout_ms -autoUpdatedTo-> " + clusterOperationTimeoutMs);
            operationTimeoutMs = clusterOperationTimeoutMs;
        }
        if ((clusterDefaultItemsQueryCount = (Integer)clusterService.getClusterSettings().get(DEFAULT_ITEMS_QUERY_COUNT)) != null) {
            this.getLog().debug("notifications:opensearch.notifications.general.default_items_query_count -autoUpdatedTo-> " + clusterDefaultItemsQueryCount);
            defaultItemsQueryCount = clusterDefaultItemsQueryCount;
        }
    }

    public final void addSettingsUpdateConsumer(@NotNull ClusterService clusterService) {
        Intrinsics.checkNotNullParameter((Object)clusterService, (String)"clusterService");
        PluginSettings.clusterService = clusterService;
        this.updateSettingValuesFromLocal(clusterService);
        this.updateSettingValuesFromCluster(clusterService);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(OPERATION_TIMEOUT_MS, PluginSettings::addSettingsUpdateConsumer$lambda-0);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(DEFAULT_ITEMS_QUERY_COUNT, PluginSettings::addSettingsUpdateConsumer$lambda-1);
    }

    @OpenForTesting
    public final void reset() {
        operationTimeoutMs = 60000L;
        defaultItemsQueryCount = 100;
    }

    private static final void addSettingsUpdateConsumer$lambda-0(Long it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        operationTimeoutMs = it;
        INSTANCE.getLog().info("notifications:opensearch.notifications.general.operation_timeout_ms -updatedTo-> " + it);
    }

    private static final void addSettingsUpdateConsumer$lambda-1(Integer it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        defaultItemsQueryCount = it;
        INSTANCE.getLog().info("notifications:opensearch.notifications.general.default_items_query_count -updatedTo-> " + it);
    }

    static {
        int n;
        long l;
        Object object;
        String configDirName;
        String string;
        INSTANCE = new PluginSettings();
        log$delegate = HelpersKt.logger(INSTANCE.getClass());
        Settings settings = null;
        Dictionary dictionary = BootstrapInfo.getSystemProperties();
        if (dictionary == null) {
            string = null;
        } else {
            Object v = dictionary.get("opensearch.path.conf");
            string = configDirName = v == null ? null : v.toString();
        }
        if (configDirName != null) {
            object = new String[]{"opensearch-notifications", "notifications.yml"};
            Path defaultSettingYmlFile = Path.of(configDirName, object);
            try {
                settings = Settings.builder().loadFromPath(defaultSettingYmlFile).build();
            }
            catch (IOException e) {
                INSTANCE.getLog().warn("notifications:Failed to load " + defaultSettingYmlFile.toAbsolutePath() + ":" + e.getMessage());
            }
        }
        Settings settings2 = settings;
        operationTimeoutMs = settings2 == null ? 60000L : ((object = settings2.get(OPERATION_TIMEOUT_MS_KEY)) == null ? 60000L : (l = Long.parseLong((String)object)));
        Settings settings3 = settings;
        defaultItemsQueryCount = settings3 == null ? 100 : ((object = settings3.get(DEFAULT_ITEMS_QUERY_COUNT_KEY)) == null ? 100 : (n = Integer.parseInt((String)object)));
        settings3 = new Pair[2];
        String string2 = Long.toString(operationTimeoutMs, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(this, checkRadix(radix))");
        settings3[0] = TuplesKt.to((Object)OPERATION_TIMEOUT_MS_KEY, (Object)string2);
        String string3 = Integer.toString(defaultItemsQueryCount, CharsKt.checkRadix((int)10));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(this, checkRadix(radix))");
        settings3[1] = TuplesKt.to((Object)DEFAULT_ITEMS_QUERY_COUNT_KEY, (Object)string3);
        defaultSettings = MapsKt.mapOf((Pair[])settings3);
        String string4 = defaultSettings.get(OPERATION_TIMEOUT_MS_KEY);
        Intrinsics.checkNotNull((Object)string4);
        Setting.Property[] propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        Setting setting = Setting.longSetting((String)OPERATION_TIMEOUT_MS_KEY, (long)Long.parseLong(string4), (long)100L, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"longSetting(\n        OPE\u2026 NodeScope, Dynamic\n    )");
        OPERATION_TIMEOUT_MS = setting;
        String string5 = defaultSettings.get(DEFAULT_ITEMS_QUERY_COUNT_KEY);
        Intrinsics.checkNotNull((Object)string5);
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.intSetting((String)DEFAULT_ITEMS_QUERY_COUNT_KEY, (int)Integer.parseInt(string5), (int)10, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"intSetting(\n        DEFA\u2026 NodeScope, Dynamic\n    )");
        DEFAULT_ITEMS_QUERY_COUNT = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic, Setting.Property.Deprecated};
        setting = Setting.boolSetting((String)LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES_KEY, (boolean)false, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        LEG\u2026ynamic, Deprecated,\n    )");
        LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.boolSetting((String)ALERTING_FILTER_BY_BACKEND_ROLES_KEY, LEGACY_ALERTING_FILTER_BY_BACKEND_ROLES, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        ALE\u2026 NodeScope, Dynamic\n    )");
        ALERTING_FILTER_BY_BACKEND_ROLES = setting;
        propertyArray = new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic};
        setting = Setting.boolSetting((String)FILTER_BY_BACKEND_ROLES_KEY, ALERTING_FILTER_BY_BACKEND_ROLES, (Setting.Property[])propertyArray);
        Intrinsics.checkNotNullExpressionValue((Object)setting, (String)"boolSetting(\n        FIL\u2026 NodeScope, Dynamic\n    )");
        FILTER_BY_BACKEND_ROLES = setting;
    }
}

