/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.action.ActionListener;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.StepListener;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.xcontent.DeprecationHandler;
import org.opensearch.common.xcontent.LoggingDeprecationHandler;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.TermsQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.search.fetch.subphase.FetchSourceContext;
import org.opensearch.securityanalytics.action.GetMappingsViewAction;
import org.opensearch.securityanalytics.action.GetMappingsViewRequest;
import org.opensearch.securityanalytics.action.SearchRuleAction;
import org.opensearch.securityanalytics.action.SearchRuleRequest;
import org.opensearch.securityanalytics.mapper.MapperUtils;
import org.opensearch.securityanalytics.model.Rule;

public class RuleValidator {
    private static final int MAX_RULES_TO_VALIDATE = 1000;
    private static final String RULE_ID = "_id";
    private final Client client;
    private final NamedXContentRegistry namedXContentRegistry;

    public RuleValidator(Client client, NamedXContentRegistry namedXContentRegistry) {
        this.client = client;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public void validateCustomRules(List<String> ruleIds, String indexName, ActionListener<List<String>> listener) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.fetchSource(FetchSourceContext.FETCH_SOURCE);
        TermsQueryBuilder queryBuilder = QueryBuilders.termsQuery((String)RULE_ID, (String[])ruleIds.toArray(new String[0]));
        SearchRequest searchRequest = new SearchRequest(new String[]{".opensearch-sap-custom-rules-config"}).source(new SearchSourceBuilder().seqNoAndPrimaryTerm(Boolean.valueOf(false)).version(Boolean.valueOf(false)).query((QueryBuilder)queryBuilder).fetchSource(FetchSourceContext.FETCH_SOURCE).size(1000)).indices(new String[]{".opensearch-sap-custom-rules-config"});
        StepListener searchRuleResponseListener = new StepListener();
        searchRuleResponseListener.whenComplete(searchRuleResponse -> {
            List<Rule> rules = RuleValidator.getRules(searchRuleResponse, this.namedXContentRegistry);
            this.validateRules(rules, indexName, listener);
        }, arg_0 -> listener.onFailure(arg_0));
        this.client.execute((ActionType)SearchRuleAction.INSTANCE, (ActionRequest)new SearchRuleRequest(false, searchRequest), (ActionListener)searchRuleResponseListener);
    }

    private void validateRules(List<Rule> rules, String indexName, ActionListener<List<String>> listener) {
        String ruleTopic = rules.get(0).getCategory();
        StepListener getMappingsViewResponseListener = new StepListener();
        getMappingsViewResponseListener.whenComplete(getMappingsViewResponse -> {
            ArrayList<String> nonapplicableRuleIds = new ArrayList<String>();
            for (Rule r : rules) {
                List<String> allIndexFields = MapperUtils.extractAllFieldsFlat(getMappingsViewResponse.getAliasMappings());
                allIndexFields.addAll(getMappingsViewResponse.getUnmappedIndexFields());
                List missingRuleFields = r.getQueryFieldNames().stream().map(e -> e.getValue()).filter(e -> !allIndexFields.contains(e)).collect(Collectors.toList());
                if (missingRuleFields.size() <= 0) continue;
                nonapplicableRuleIds.add(r.getId());
            }
            listener.onResponse(nonapplicableRuleIds);
        }, arg_0 -> listener.onFailure(arg_0));
        this.client.execute((ActionType)GetMappingsViewAction.INSTANCE, (ActionRequest)new GetMappingsViewRequest(indexName, ruleTopic), (ActionListener)getMappingsViewResponseListener);
    }

    public static List<Rule> getRules(SearchResponse response, NamedXContentRegistry xContentRegistry) throws IOException {
        ArrayList<Rule> rules = new ArrayList<Rule>((int)response.getHits().getTotalHits().value);
        for (SearchHit hit : response.getHits()) {
            XContentParser xcp = XContentType.JSON.xContent().createParser(xContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, hit.getSourceAsString());
            Rule rule = Rule.docParse(xcp, hit.getId(), hit.getVersion());
            rules.add(rule);
        }
        return rules;
    }
}

