/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.model;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.ParseField;
import org.opensearch.common.UUIDs;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.NamedXContentRegistry;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;
import org.opensearch.commons.alerting.model.action.Action;
import org.opensearch.script.Script;
import org.opensearch.script.ScriptType;

public class DetectorTrigger
implements Writeable,
ToXContentObject {
    private static final Logger log = LogManager.getLogger(DetectorTrigger.class);
    private String id;
    private String name;
    private String severity;
    private List<String> ruleTypes;
    private List<String> ruleIds;
    private List<String> ruleSeverityLevels;
    private List<String> tags;
    private List<Action> actions;
    private static final String ID_FIELD = "id";
    private static final String SEVERITY_FIELD = "severity";
    private static final String RULE_TYPES_FIELD = "types";
    private static final String RULE_IDS_FIELD = "ids";
    private static final String RULE_SEV_LEVELS_FIELD = "sev_levels";
    private static final String RULE_TAGS_FIELD = "tags";
    private static final String ACTIONS_FIELD = "actions";
    public static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(DetectorTrigger.class, new ParseField("id", new String[0]), DetectorTrigger::parse);

    public DetectorTrigger(String id, String name, String severity, List<String> ruleTypes, List<String> ruleIds, List<String> ruleSeverityLevels, List<String> tags, List<Action> actions) {
        this.id = id == null ? UUIDs.base64UUID() : id;
        this.name = name;
        this.severity = severity;
        this.ruleTypes = ruleTypes.stream().map(e -> e.toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        this.ruleIds = ruleIds;
        this.ruleSeverityLevels = ruleSeverityLevels;
        this.tags = tags;
        this.actions = actions;
    }

    public DetectorTrigger(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readString(), sin.readStringList(), sin.readStringList(), sin.readStringList(), sin.readStringList(), sin.readList(Action::readFrom));
    }

    public Map<String, Object> asTemplateArg() {
        return Map.of(RULE_TYPES_FIELD, this.ruleTypes, RULE_IDS_FIELD, this.ruleIds, RULE_SEV_LEVELS_FIELD, this.ruleSeverityLevels, RULE_TAGS_FIELD, this.tags, ACTIONS_FIELD, this.actions.stream().map(Action::asTemplateArg));
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeString(this.name);
        out.writeString(this.severity);
        out.writeStringCollection(this.ruleTypes);
        out.writeStringCollection(this.ruleIds);
        out.writeStringCollection(this.ruleSeverityLevels);
        out.writeStringCollection(this.tags);
        out.writeCollection(this.actions);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        String[] ruleTypeArray = new String[]{};
        ruleTypeArray = this.ruleTypes.toArray(ruleTypeArray);
        String[] ruleNameArray = new String[]{};
        ruleNameArray = this.ruleIds.toArray(ruleNameArray);
        String[] ruleSevLevelArray = new String[]{};
        ruleSevLevelArray = this.ruleSeverityLevels.toArray(ruleSevLevelArray);
        String[] tagArray = new String[]{};
        tagArray = this.tags.toArray(tagArray);
        Action[] actionArray = new Action[]{};
        actionArray = this.actions.toArray(actionArray);
        return builder.startObject().field(ID_FIELD, this.id).field("name", this.name).field(SEVERITY_FIELD, this.severity).field(RULE_TYPES_FIELD, (Object)ruleTypeArray).field(RULE_IDS_FIELD, (Object)ruleNameArray).field(RULE_SEV_LEVELS_FIELD, (Object)ruleSevLevelArray).field(RULE_TAGS_FIELD, (Object)tagArray).field(ACTIONS_FIELD, (Object)actionArray).endObject();
    }

    public static DetectorTrigger parse(XContentParser xcp) throws IOException {
        String id = null;
        String name = null;
        String severity = null;
        ArrayList<String> ruleTypes = new ArrayList<String>();
        ArrayList<String> ruleNames = new ArrayList<String>();
        ArrayList<String> ruleSeverityLevels = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList<Action> actions = new ArrayList<Action>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block20: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "id": {
                    id = xcp.text();
                    continue block20;
                }
                case "name": {
                    name = xcp.text();
                    continue block20;
                }
                case "severity": {
                    severity = xcp.text();
                    continue block20;
                }
                case "types": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String ruleType = xcp.text();
                        ruleTypes.add(ruleType);
                    }
                    continue block20;
                }
                case "ids": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String ruleName = xcp.text();
                        ruleNames.add(ruleName);
                    }
                    continue block20;
                }
                case "sev_levels": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String ruleSeverityLevel = xcp.text();
                        ruleSeverityLevels.add(ruleSeverityLevel);
                    }
                    continue block20;
                }
                case "tags": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        String tag = xcp.text();
                        tags.add(tag);
                    }
                    continue block20;
                }
                case "actions": {
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        Action action = Action.parse((XContentParser)xcp);
                        actions.add(action);
                    }
                    continue block20;
                }
            }
            xcp.skipChildren();
        }
        return new DetectorTrigger(id, name, severity, ruleTypes, ruleNames, ruleSeverityLevels, tags, actions);
    }

    public static DetectorTrigger readFrom(StreamInput sin) throws IOException {
        return new DetectorTrigger(sin);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectorTrigger that = (DetectorTrigger)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.severity, that.severity) && Objects.equals(this.ruleTypes, that.ruleTypes) && Objects.equals(this.ruleIds, that.ruleIds) && Objects.equals(this.ruleSeverityLevels, that.ruleSeverityLevels) && Objects.equals(this.tags, that.tags) && Objects.equals(this.actions, that.actions);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.severity, this.ruleTypes, this.ruleIds, this.ruleSeverityLevels, this.tags, this.actions);
    }

    public Script convertToCondition() {
        StringBuilder condition = new StringBuilder();
        boolean triggerFlag = false;
        StringBuilder ruleTypeBuilder = new StringBuilder();
        int size = this.ruleTypes.size();
        for (int idx = 0; idx < size; ++idx) {
            ruleTypeBuilder.append(String.format(Locale.getDefault(), "query[tag=%s]", this.ruleTypes.get(idx)));
            if (idx >= size - 1) continue;
            ruleTypeBuilder.append(" || ");
        }
        if (size > 0) {
            condition.append("(").append((CharSequence)ruleTypeBuilder).append(")");
            triggerFlag = true;
        }
        StringBuilder ruleNameBuilder = new StringBuilder();
        size = this.ruleIds.size();
        for (int idx = 0; idx < size; ++idx) {
            ruleNameBuilder.append(String.format(Locale.getDefault(), "query[name=%s]", this.ruleIds.get(idx)));
            if (idx >= size - 1) continue;
            ruleNameBuilder.append(" || ");
        }
        if (size > 0) {
            if (triggerFlag) {
                condition.append(" && ").append("(").append((CharSequence)ruleNameBuilder).append(")");
            } else {
                condition.append("(").append((CharSequence)ruleNameBuilder).append(")");
                triggerFlag = true;
            }
        }
        StringBuilder ruleSevLevelBuilder = new StringBuilder();
        size = this.ruleSeverityLevels.size();
        for (int idx = 0; idx < size; ++idx) {
            ruleSevLevelBuilder.append(String.format(Locale.getDefault(), "query[tag=%s]", this.ruleSeverityLevels.get(idx)));
            if (idx >= size - 1) continue;
            ruleSevLevelBuilder.append(" || ");
        }
        if (size > 0) {
            if (triggerFlag) {
                condition.append(" && ").append("(").append((CharSequence)ruleSevLevelBuilder).append(")");
            } else {
                condition.append("(").append((CharSequence)ruleSevLevelBuilder).append(")");
                triggerFlag = true;
            }
        }
        StringBuilder tagBuilder = new StringBuilder();
        size = this.tags.size();
        for (int idx = 0; idx < size; ++idx) {
            tagBuilder.append(String.format(Locale.getDefault(), "query[tag=%s]", this.tags.get(idx)));
            if (idx >= size - 1) continue;
            ruleSevLevelBuilder.append(" || ");
        }
        if (size > 0) {
            if (triggerFlag) {
                condition.append(" && ").append("(").append((CharSequence)tagBuilder).append(")");
            } else {
                condition.append("(").append((CharSequence)tagBuilder).append(")");
            }
        }
        return new Script(condition.toString());
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<Action> getActions() {
        ArrayList<Action> transformedActions = new ArrayList<Action>();
        if (this.actions != null) {
            for (Action action : this.actions) {
                String subjectTemplate = action.getSubjectTemplate() != null ? action.getSubjectTemplate().getIdOrCode() : "";
                subjectTemplate = subjectTemplate.replace("{{ctx.detector", "{{ctx.monitor");
                action.getMessageTemplate();
                String messageTemplate = action.getMessageTemplate().getIdOrCode();
                messageTemplate = messageTemplate.replace("{{ctx.detector", "{{ctx.monitor");
                Action transformedAction = new Action(action.getName(), action.getDestinationId(), new Script(ScriptType.INLINE, "mustache", subjectTemplate, Collections.emptyMap()), new Script(ScriptType.INLINE, "mustache", messageTemplate, Collections.emptyMap()), action.getThrottleEnabled(), action.getThrottle(), action.getId(), action.getActionExecutionPolicy());
                transformedActions.add(transformedAction);
            }
        }
        return transformedActions;
    }
}

