/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.settings.SettingsException;
import org.opensearch.common.xcontent.XContent;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.common.xcontent.json.JsonXContent;

public class MapperTopicStore {
    private static final String MAPPER_CONFIG_FILE = "OSMapping/mapper_topics.json";
    private static final Logger log = LogManager.getLogger(MapperTopicStore.class);
    private Map<String, String> mapperMap;
    private static MapperTopicStore INSTANCE = new MapperTopicStore();

    private MapperTopicStore() {
        try (InputStream is = MapperTopicStore.class.getClassLoader().getResourceAsStream(MAPPER_CONFIG_FILE);){
            this.mapperMap = new HashMap<String, String>();
            String mapperTopicsJson = new String(Objects.requireNonNull(is).readAllBytes(), StandardCharsets.UTF_8);
            if (mapperTopicsJson != null) {
                Map configMap = XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, (String)mapperTopicsJson, (boolean)false);
                this.mapperMap = configMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
                log.info("Loaded {} mapper topics", (Object)this.mapperMap.size());
            }
        }
        catch (OpenSearchParseException e2) {
            throw e2;
        }
        catch (Exception e3) {
            throw new SettingsException("Failed to load settings from [OSMapping/mapper_topics.json]", (Throwable)e3);
        }
    }

    public static String aliasMappings(String mapperTopic) throws IOException {
        if (MapperTopicStore.INSTANCE.mapperMap.containsKey(mapperTopic.toLowerCase(Locale.ROOT))) {
            return new String(Objects.requireNonNull(INSTANCE.getClass().getClassLoader().getResourceAsStream(MapperTopicStore.INSTANCE.mapperMap.get(mapperTopic.toLowerCase(Locale.ROOT)))).readAllBytes(), StandardCharsets.UTF_8);
        }
        throw new IllegalArgumentException("Mapper not found: [" + mapperTopic + "]");
    }

    public static void putAliasMappings(String mapperTopic, String mappingFilePath) {
        MapperTopicStore.INSTANCE.mapperMap.put(mapperTopic, mappingFilePath);
    }

    public static Map<String, String> getAliasMappingsMap() {
        return MapperTopicStore.INSTANCE.mapperMap;
    }
}

