/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.mapper;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionListener;
import org.opensearch.action.admin.indices.get.GetIndexRequest;
import org.opensearch.action.admin.indices.get.GetIndexResponse;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.opensearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.action.support.master.AcknowledgedResponse;
import org.opensearch.client.Client;
import org.opensearch.client.IndicesAdminClient;
import org.opensearch.cluster.metadata.IndexNameExpressionResolver;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.collect.ImmutableOpenMap;
import org.opensearch.rest.RestStatus;
import org.opensearch.securityanalytics.action.GetIndexMappingsResponse;
import org.opensearch.securityanalytics.action.GetMappingsViewResponse;
import org.opensearch.securityanalytics.mapper.IndexTemplateManager;
import org.opensearch.securityanalytics.mapper.MapperTopicStore;
import org.opensearch.securityanalytics.mapper.MapperUtils;
import org.opensearch.securityanalytics.mapper.MappingsTraverser;
import org.opensearch.securityanalytics.model.CreateMappingResult;
import org.opensearch.securityanalytics.util.IndexUtils;
import org.opensearch.securityanalytics.util.SecurityAnalyticsException;

public class MapperService {
    private static final Logger log = LogManager.getLogger(MapperService.class);
    private ClusterService clusterService;
    private IndicesAdminClient indicesClient;
    private IndexNameExpressionResolver indexNameExpressionResolver;
    private IndexTemplateManager indexTemplateManager;

    public MapperService() {
    }

    public MapperService(Client client, ClusterService clusterService, IndexNameExpressionResolver indexNameExpressionResolver, IndexTemplateManager indexTemplateManager) {
        this.indicesClient = client.admin().indices();
        this.clusterService = clusterService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        this.indexTemplateManager = indexTemplateManager;
    }

    public void createMappingAction(String indexName, String ruleTopic, boolean partial, ActionListener<AcknowledgedResponse> actionListener) {
        this.createMappingAction(indexName, ruleTopic, null, partial, actionListener);
    }

    public void createMappingAction(final String indexName, final String ruleTopic, final String aliasMappings, final boolean partial, final ActionListener<AcknowledgedResponse> actionListener) {
        String writeIndex;
        boolean shouldUpsertIndexTemplate;
        String index = indexName;
        boolean bl = shouldUpsertIndexTemplate = !IndexUtils.isConcreteIndex(indexName, this.clusterService.state());
        if (IndexUtils.isDataStream(indexName, this.clusterService.state()) && (writeIndex = IndexUtils.getWriteIndex(indexName, this.clusterService.state())) != null) {
            index = writeIndex;
        }
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{index});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                MapperService.this.applyAliasMappings((ImmutableOpenMap<String, MappingMetadata>)getMappingsResponse.getMappings(), ruleTopic, aliasMappings, partial, new ActionListener<Collection<CreateMappingResult>>(){

                    public void onResponse(Collection<CreateMappingResult> createMappingResponse) {
                        Optional<AcknowledgedResponse> notAckd = createMappingResponse.stream().map(e -> e.getAcknowledgedResponse()).filter(e -> !e.isAcknowledged()).findFirst();
                        AcknowledgedResponse ack = new AcknowledgedResponse(!notAckd.isPresent());
                        if (shouldUpsertIndexTemplate) {
                            MapperService.this.indexTemplateManager.upsertIndexTemplateWithAliasMappings(indexName, createMappingResponse, (ActionListener<AcknowledgedResponse>)actionListener);
                        } else {
                            actionListener.onResponse((Object)ack);
                        }
                    }

                    public void onFailure(Exception e) {
                        actionListener.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void applyAliasMappings(ImmutableOpenMap<String, MappingMetadata> indexMappings, String ruleTopic, String aliasMappings, boolean partial, final ActionListener<Collection<CreateMappingResult>> actionListener) {
        int numOfIndices = indexMappings.size();
        GroupedActionListener doCreateMappingActionsListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<CreateMappingResult>>(){

            public void onResponse(Collection<CreateMappingResult> response) {
                actionListener.onResponse(response);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure((Exception)((Object)new SecurityAnalyticsException("Failed applying mappings to index", RestStatus.INTERNAL_SERVER_ERROR, e)));
            }
        }, numOfIndices);
        indexMappings.forEach(iter -> {
            String indexName = (String)iter.key;
            MappingMetadata mappingMetadata = (MappingMetadata)iter.value;
            this.doCreateMapping(indexName, mappingMetadata, ruleTopic, aliasMappings, partial, (ActionListener<CreateMappingResult>)doCreateMappingActionsListener);
        });
    }

    private void doCreateMapping(final String indexName, MappingMetadata mappingMetadata, String ruleTopic, String aliasMappings, boolean partial, final ActionListener<CreateMappingResult> actionListener) {
        try {
            String aliasMappingsJSON = aliasMappings != null ? aliasMappings : MapperTopicStore.aliasMappings(ruleTopic);
            Pair<List<String>, List<String>> validationResult = MapperUtils.validateIndexMappings(indexName, mappingMetadata, aliasMappingsJSON);
            List missingPathsInIndex = (List)validationResult.getLeft();
            List presentPathsInIndex = (List)validationResult.getRight();
            if (missingPathsInIndex.size() > 0 && !partial) {
                actionListener.onFailure((Exception)new IllegalArgumentException("Not all paths were found in index mappings: " + missingPathsInIndex.stream().collect(Collectors.joining(", ", "[", "]"))));
            }
            Map<String, Object> presentPathsMappings = MapperUtils.getFieldMappingsFlat(mappingMetadata, presentPathsInIndex);
            Map<String, Object> filteredAliasMappings = this.filterNonApplicableAliases(mappingMetadata, missingPathsInIndex, aliasMappingsJSON);
            HashMap<String, Object> allMappings = new HashMap<String, Object>(presentPathsMappings);
            allMappings.putAll((Map)filteredAliasMappings.get("properties"));
            final HashMap<String, HashMap<String, Object>> mappingsRoot = new HashMap<String, HashMap<String, Object>>();
            mappingsRoot.put("properties", allMappings);
            PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(filteredAliasMappings);
            this.indicesClient.putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

                public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                    CreateMappingResult result = new CreateMappingResult(acknowledgedResponse, indexName, mappingsRoot);
                    actionListener.onResponse((Object)result);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException | IllegalArgumentException e) {
            actionListener.onFailure(e);
        }
    }

    private Map<String, Object> filterNonApplicableAliases(MappingMetadata indexMappingMetadata, List<String> missingPathsInIndex, String aliasMappingsJSON) throws IOException {
        boolean excludeSomeAliases;
        MappingsTraverser mappingsTraverser = new MappingsTraverser(aliasMappingsJSON, Set.of());
        Map<String, Object> filteredAliasMappings = mappingsTraverser.traverseAndCopyAsFlat();
        ArrayList<Pair<String, String>> propertiesToSkip = new ArrayList<Pair<String, String>>();
        if (missingPathsInIndex.size() > 0) {
            propertiesToSkip.addAll(missingPathsInIndex.stream().map(e -> Pair.of((Object)"path", (Object)e)).collect(Collectors.toList()));
        }
        List<String> nonAliasIndexFields = MapperUtils.getAllNonAliasFieldsFromIndex(indexMappingMetadata);
        List<String> aliasFields = MapperUtils.getAllAliases(aliasMappingsJSON);
        Set<String> aliasesToInclude = aliasFields.stream().filter(e -> !nonAliasIndexFields.contains(e)).collect(Collectors.toSet());
        boolean bl = excludeSomeAliases = aliasesToInclude.size() < aliasFields.size();
        if (propertiesToSkip.size() > 0 || excludeSomeAliases) {
            mappingsTraverser = new MappingsTraverser(aliasMappingsJSON, propertiesToSkip);
            filteredAliasMappings = aliasesToInclude.size() > 0 ? mappingsTraverser.traverseAndCopyWithFilter(aliasesToInclude) : mappingsTraverser.traverseAndCopyAsFlat();
        }
        return filteredAliasMappings;
    }

    public void updateMappingAction(String indexName, String field, String alias, final ActionListener<AcknowledgedResponse> actionListener) {
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(new String[]{field, alias});
        this.indicesClient.putMapping(request, (ActionListener)new ActionListener<AcknowledgedResponse>(){

            public void onResponse(AcknowledgedResponse acknowledgedResponse) {
                actionListener.onResponse((Object)acknowledgedResponse);
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public void getMappingAction(final String indexName, final ActionListener<GetIndexMappingsResponse> actionListener) {
        try {
            this.resolveConcreteIndex(indexName, new ActionListener<String>(){

                public void onResponse(String concreteIndex) {
                    MapperService.this.doGetMappingAction(indexName, concreteIndex, (ActionListener<GetIndexMappingsResponse>)actionListener);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw SecurityAnalyticsException.wrap(e);
        }
    }

    public void doGetMappingAction(final String indexName, String concreteIndexName, final ActionListener<GetIndexMappingsResponse> actionListener) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{concreteIndexName});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                try {
                    MappingMetadata mappingMetadata = (MappingMetadata)((ObjectObjectCursor)getMappingsResponse.mappings().iterator().next()).value;
                    HashSet<String> appliedAliases = new HashSet<String>();
                    List<Pair<String, String>> indexAliasPathPairs = MapperUtils.getAllAliasPathPairs(mappingMetadata);
                    Map<String, String> aliasMappingsMap = MapperTopicStore.getAliasMappingsMap();
                    for (String mapperTopic : aliasMappingsMap.keySet()) {
                        String aliasMappingsJson = MapperTopicStore.aliasMappings(mapperTopic);
                        List<Pair<String, String>> aliasPathPairs = MapperUtils.getAllAliasPathPairs(aliasMappingsJson);
                        for (Pair<String, String> p1 : indexAliasPathPairs) {
                            for (Pair<String, String> p2 : aliasPathPairs) {
                                if (!((String)p1.getKey()).equals(p2.getKey())) continue;
                                appliedAliases.add((String)p1.getKey());
                            }
                        }
                    }
                    if (appliedAliases.size() == 0) {
                        actionListener.onFailure((Exception)SecurityAnalyticsException.wrap((OpenSearchException)new OpenSearchStatusException("No applied aliases found", RestStatus.NOT_FOUND, new Object[0])));
                        return;
                    }
                    MappingsTraverser mappingsTraverser = new MappingsTraverser(mappingMetadata);
                    Map<String, Object> filteredMapping = mappingsTraverser.traverseAndCopyWithFilter(appliedAliases);
                    ImmutableOpenMap.Builder outIndexMappings = ImmutableOpenMap.builder();
                    Map<String, Map<String, Object>> root = Map.of("_doc", filteredMapping);
                    MappingMetadata outMappingMetadata = new MappingMetadata("_doc", root);
                    outIndexMappings.put((Object)indexName, (Object)outMappingMetadata);
                    actionListener.onResponse((Object)new GetIndexMappingsResponse((ImmutableOpenMap<String, MappingMetadata>)outIndexMappings.build()));
                }
                catch (IOException e) {
                    actionListener.onFailure((Exception)e);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    public void getMappingsViewAction(String indexName, final String mapperTopic, final ActionListener<GetMappingsViewResponse> actionListener) {
        try {
            this.resolveConcreteIndex(indexName, new ActionListener<String>(){

                public void onResponse(String concreteIndex) {
                    MapperService.this.doGetMappingsView(mapperTopic, (ActionListener<GetMappingsViewResponse>)actionListener, concreteIndex);
                }

                public void onFailure(Exception e) {
                    actionListener.onFailure(e);
                }
            });
        }
        catch (IOException e) {
            throw SecurityAnalyticsException.wrap(e);
        }
    }

    private void doGetMappingsView(final String mapperTopic, final ActionListener<GetMappingsViewResponse> actionListener, String concreteIndex) {
        GetMappingsRequest getMappingsRequest = (GetMappingsRequest)new GetMappingsRequest().indices(new String[]{concreteIndex});
        this.indicesClient.getMappings(getMappingsRequest, (ActionListener)new ActionListener<GetMappingsResponse>(){

            public void onResponse(GetMappingsResponse getMappingsResponse) {
                try {
                    MappingMetadata mappingMetadata = (MappingMetadata)((ObjectObjectCursor)getMappingsResponse.mappings().iterator().next()).value;
                    List<String> allFieldsFromIndex = MapperUtils.getAllNonAliasFieldsFromIndex(mappingMetadata);
                    String aliasMappingsJson = MapperTopicStore.aliasMappings(mapperTopic);
                    List<Pair<String, String>> aliasPathPairs = MapperUtils.getAllAliasPathPairs(aliasMappingsJson);
                    ArrayList<String> applyableAliases = new ArrayList<String>();
                    ArrayList<String> pathsOfApplyableAliases = new ArrayList<String>();
                    ArrayList<String> unmappedFieldAliases = new ArrayList<String>();
                    for (Pair<String, String> p : aliasPathPairs) {
                        String alias = (String)p.getKey();
                        String path = (String)p.getValue();
                        if (allFieldsFromIndex.contains(path)) {
                            applyableAliases.add(alias);
                            pathsOfApplyableAliases.add(path);
                            continue;
                        }
                        if (allFieldsFromIndex.contains(alias)) continue;
                        unmappedFieldAliases.add(alias);
                    }
                    Map<String, Object> aliasMappings = MapperUtils.getAliasMappingsWithFilter(aliasMappingsJson, applyableAliases);
                    List<String> unmappedIndexFields = allFieldsFromIndex.stream().filter(e -> !pathsOfApplyableAliases.contains(e)).collect(Collectors.toList());
                    actionListener.onResponse((Object)new GetMappingsViewResponse(aliasMappings, unmappedIndexFields, unmappedFieldAliases));
                }
                catch (Exception e2) {
                    actionListener.onFailure(e2);
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    private void resolveConcreteIndex(final String indexName, final ActionListener<String> actionListener) throws IOException {
        this.indicesClient.getIndex((GetIndexRequest)new GetIndexRequest().indices(new String[]{indexName}), (ActionListener)new ActionListener<GetIndexResponse>(){

            public void onResponse(GetIndexResponse getIndexResponse) {
                String[] indices = getIndexResponse.indices();
                if (indices.length == 0) {
                    actionListener.onFailure((Exception)SecurityAnalyticsException.wrap(new IllegalArgumentException("Invalid index name: [" + indexName + "]")));
                } else if (indices.length == 1) {
                    actionListener.onResponse((Object)indices[0]);
                } else if (indices.length > 1) {
                    String writeIndex = IndexUtils.getWriteIndex(indexName, MapperService.this.clusterService.state());
                    if (writeIndex != null) {
                        actionListener.onResponse((Object)writeIndex);
                    } else {
                        actionListener.onResponse((Object)IndexUtils.getNewestIndexByCreationDate(indices, MapperService.this.clusterService.state()));
                    }
                }
            }

            public void onFailure(Exception e) {
                actionListener.onFailure(e);
            }
        });
    }

    void setIndicesAdminClient(IndicesAdminClient client) {
        this.indicesClient = client;
    }

    void setClusterService(ClusterService clusterService) {
        this.clusterService = clusterService;
    }

    public void setIndexNameExpressionResolver(IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indexNameExpressionResolver = indexNameExpressionResolver;
    }

    public void setIndexTemplateManager(IndexTemplateManager indexTemplateManager) {
        this.indexTemplateManager = indexTemplateManager;
    }
}

