/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class ValidateRulesRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(ValidateRulesRequest.class);
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String RULES_FIELD = "rules";
    String indexName;
    List<String> rules;

    public ValidateRulesRequest(String indexName, List<String> rules) {
        this.indexName = indexName;
        this.rules = rules;
    }

    public ValidateRulesRequest(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readStringList());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexName == null || this.indexName.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", INDEX_NAME_FIELD), validationException);
        }
        if (this.rules == null || this.rules.size() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s are missing", RULES_FIELD), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeStringCollection(this.rules);
    }

    public static ValidateRulesRequest parse(XContentParser xcp) throws IOException {
        String indexName = null;
        ArrayList<String> ruleIds = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block8: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = xcp.text();
                    continue block8;
                }
                case "rules": {
                    ruleIds = new ArrayList<String>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                        ruleIds.add(xcp.text());
                    }
                    continue block8;
                }
            }
            xcp.skipChildren();
        }
        return new ValidateRulesRequest(indexName, ruleIds);
    }

    public ValidateRulesRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public ValidateRulesRequest rules(List<String> rules) {
        this.rules = rules;
        return this;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public List<String> getRules() {
        return this.rules;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public List<String> setRules(List<String> rules) {
        this.rules = rules;
        return this.rules;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(INDEX_NAME_FIELD, this.indexName).field(RULES_FIELD, this.rules).endObject();
    }
}

