/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;

public class GetDetectorRequest
extends ActionRequest {
    private String detectorId;
    private Long version;
    public static final String DETECTOR_ID = "detector_id";

    public GetDetectorRequest(String detectorId, Long version) {
        this.detectorId = detectorId;
        this.version = version;
    }

    public GetDetectorRequest(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.detectorId == null || this.detectorId.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", DETECTOR_ID), validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        out.writeLong(this.version.longValue());
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public Long getVersion() {
        return this.version;
    }
}

