/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.common.Strings;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.common.xcontent.XContentParser;
import org.opensearch.common.xcontent.XContentParserUtils;

public class CreateIndexMappingsRequest
extends ActionRequest
implements ToXContentObject {
    private static final Logger log = LogManager.getLogger(CreateIndexMappingsRequest.class);
    public static final String INDEX_NAME_FIELD = "index_name";
    public static final String RULE_TOPIC_FIELD = "rule_topic";
    public static final String ALIAS_MAPPINGS_FIELD = "alias_mappings";
    public static final String PARTIAL_FIELD = "partial";
    public static final Boolean PARTIAL_FIELD_DEFAULT_VALUE = true;
    String indexName;
    String ruleTopic;
    String aliasMappings;
    Boolean partial;

    public CreateIndexMappingsRequest(String indexName, String ruleTopic, Boolean partial) {
        this.indexName = indexName;
        this.ruleTopic = ruleTopic;
        this.aliasMappings = this.aliasMappings;
        this.partial = partial == null ? PARTIAL_FIELD_DEFAULT_VALUE : partial;
    }

    public CreateIndexMappingsRequest(String indexName, String ruleTopic, String aliasMappings, Boolean partial) {
        this(indexName, ruleTopic, partial);
        this.aliasMappings = aliasMappings;
    }

    public CreateIndexMappingsRequest(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readOptionalString(), sin.readOptionalBoolean());
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.indexName == null || this.indexName.length() == 0) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s is missing", INDEX_NAME_FIELD), validationException);
        }
        if (!(this.ruleTopic != null && this.ruleTopic.length() != 0 || this.aliasMappings != null && this.aliasMappings.length() != 0)) {
            validationException = ValidateActions.addValidationError((String)String.format(Locale.getDefault(), "%s and %s are missing", RULE_TOPIC_FIELD, ALIAS_MAPPINGS_FIELD), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.indexName);
        out.writeString(this.ruleTopic);
        out.writeOptionalString(this.aliasMappings);
        out.writeOptionalBoolean(this.partial);
    }

    public static CreateIndexMappingsRequest parse(XContentParser xcp) throws IOException {
        String indexName = null;
        String ruleTopic = null;
        String aliasMappings = null;
        Boolean partial = null;
        if (xcp.currentToken() == null) {
            xcp.nextToken();
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            switch (fieldName) {
                case "index_name": {
                    indexName = xcp.text();
                    continue block18;
                }
                case "rule_topic": {
                    ruleTopic = xcp.text();
                    continue block18;
                }
                case "alias_mappings": {
                    HashMap<String, Map<String, String>> aliasMap = new HashMap<String, Map<String, String>>();
                    XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                    while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                        xcp.nextToken();
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                            xcp.nextToken();
                            String alias = xcp.currentName();
                            String path = "";
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            block21: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                                String field = xcp.currentName();
                                xcp.nextToken();
                                switch (field) {
                                    case "path": {
                                        path = xcp.text();
                                        continue block21;
                                    }
                                }
                                xcp.skipChildren();
                            }
                            aliasMap.put(alias, Map.of("type", "alias", "path", path));
                        }
                    }
                    aliasMappings = Strings.toString((XContentBuilder)XContentFactory.jsonBuilder().map(Map.of("properties", aliasMap)));
                    continue block18;
                }
                case "partial": {
                    partial = xcp.booleanValue();
                    continue block18;
                }
            }
            xcp.skipChildren();
        }
        return new CreateIndexMappingsRequest(indexName, ruleTopic, aliasMappings, partial);
    }

    public CreateIndexMappingsRequest indexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public CreateIndexMappingsRequest ruleTopic(String ruleTopic) {
        this.ruleTopic = ruleTopic;
        return this;
    }

    public CreateIndexMappingsRequest aliasMappings(String aliasMappings) {
        this.aliasMappings = aliasMappings;
        return this;
    }

    public CreateIndexMappingsRequest partial(Boolean partial) {
        this.partial = partial;
        return this;
    }

    public String getRuleTopic() {
        return this.ruleTopic;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String getAliasMappings() {
        return this.aliasMappings;
    }

    public Boolean getPartial() {
        return this.partial;
    }

    public void setRuleTopic(String ruleTopic) {
        this.ruleTopic = ruleTopic;
    }

    public void setAliasMappings(String aliasMappings) {
        this.aliasMappings = aliasMappings;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setPartial(Boolean partial) {
        this.partial = partial;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(INDEX_NAME_FIELD, this.indexName).field(RULE_TOPIC_FIELD, this.ruleTopic).field(ALIAS_MAPPINGS_FIELD, this.aliasMappings).field(PARTIAL_FIELD, this.partial).endObject();
    }
}

