/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.action;

import java.io.IOException;
import java.time.Instant;
import java.util.List;
import org.opensearch.common.io.stream.StreamInput;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.io.stream.Writeable;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.ToXContentObject;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.commons.alerting.alerts.AlertError;
import org.opensearch.commons.alerting.model.ActionExecutionResult;
import org.opensearch.commons.alerting.model.AggregationResultBucket;
import org.opensearch.commons.alerting.model.Alert;

public class AlertDto
implements ToXContentObject,
Writeable {
    private static final int NO_SCHEMA_VERSION = 0;
    private static final String DETECTOR_ID_FIELD = "detector_id";
    private static final String ALERT_ID_FIELD = "id";
    private static final String SCHEMA_VERSION_FIELD = "schema_version";
    private static final String ALERT_VERSION_FIELD = "version";
    private static final String TRIGGER_ID_FIELD = "trigger_id";
    private static final String TRIGGER_NAME_FIELD = "trigger_name";
    private static final String FINDING_IDS = "finding_ids";
    private static final String RELATED_DOC_IDS = "related_doc_ids";
    private static final String STATE_FIELD = "state";
    private static final String START_TIME_FIELD = "start_time";
    private static final String LAST_NOTIFICATION_TIME_FIELD = "last_notification_time";
    private static final String END_TIME_FIELD = "end_time";
    private static final String ACKNOWLEDGED_TIME_FIELD = "acknowledged_time";
    private static final String ERROR_MESSAGE_FIELD = "error_message";
    private static final String ALERT_HISTORY_FIELD = "alert_history";
    private static final String SEVERITY_FIELD = "severity";
    private static final String ACTION_EXECUTION_RESULTS_FIELD = "action_execution_results";
    private static final String NO_ID = "";
    private String id;
    private Long version;
    private Integer schemaVersion;
    private String triggerId;
    private String triggerName;
    private List<String> findingIds;
    private List<String> relatedDocIds;
    private Alert.State state;
    private Instant startTime;
    private Instant endTime;
    private Instant lastNotificationTime;
    private Instant acknowledgedTime;
    private String errorMessage;
    private List<AlertError> errorHistory;
    private String severity;
    private List<ActionExecutionResult> actionExecutionResults;
    private String detectorId;
    AggregationResultBucket aggregationResultBucket;

    public AlertDto(String detectorId, String id, Long version, Integer schemaVersion, String triggerId, String triggerName, List<String> findingIds, List<String> relatedDocIds, Alert.State state, Instant startTime, Instant endTime, Instant lastNotificationTime, Instant acknowledgedTime, String errorMessage, List<AlertError> errorHistory, String severity, List<ActionExecutionResult> actionExecutionResults, AggregationResultBucket aggregationResultBucket) {
        this.detectorId = detectorId;
        this.id = id != null ? id : NO_ID;
        this.version = version != null ? version : -1L;
        this.schemaVersion = schemaVersion != null ? schemaVersion : 0;
        this.triggerId = triggerId;
        this.triggerName = triggerName;
        this.findingIds = findingIds;
        this.relatedDocIds = relatedDocIds;
        this.state = state;
        this.startTime = startTime;
        this.endTime = endTime;
        this.lastNotificationTime = lastNotificationTime;
        this.acknowledgedTime = acknowledgedTime;
        this.errorMessage = errorMessage;
        this.errorHistory = errorHistory;
        this.severity = severity;
        this.actionExecutionResults = actionExecutionResults;
        this.aggregationResultBucket = aggregationResultBucket;
    }

    public AlertDto(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readString(), sin.readLong(), sin.readInt(), sin.readString(), sin.readString(), sin.readStringList(), sin.readStringList(), (Alert.State)sin.readEnum(Alert.State.class), sin.readInstant(), sin.readOptionalInstant(), sin.readOptionalInstant(), sin.readOptionalInstant(), sin.readOptionalString(), sin.readList(AlertError::new), sin.readString(), sin.readList(ActionExecutionResult::new), sin.readBoolean() ? new AggregationResultBucket(sin) : null);
    }

    public static AlertDto readFrom(StreamInput sin) throws IOException {
        return new AlertDto(sin);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field(DETECTOR_ID_FIELD, this.detectorId).field(ALERT_ID_FIELD, this.id).field(ALERT_VERSION_FIELD, this.version).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(TRIGGER_ID_FIELD, this.triggerId).field(TRIGGER_NAME_FIELD, this.triggerName).field(FINDING_IDS, this.findingIds).field(RELATED_DOC_IDS, this.relatedDocIds).field(STATE_FIELD, (Object)this.state).field(ERROR_MESSAGE_FIELD, this.errorMessage).field(ALERT_HISTORY_FIELD, this.errorHistory).field(SEVERITY_FIELD, this.severity).field(ACTION_EXECUTION_RESULTS_FIELD, this.actionExecutionResults);
        if (this.startTime != null) {
            builder.field(START_TIME_FIELD, (Object)this.startTime);
        } else {
            builder.nullField(START_TIME_FIELD);
        }
        if (this.lastNotificationTime != null) {
            builder.field(LAST_NOTIFICATION_TIME_FIELD, (Object)this.lastNotificationTime);
        } else {
            builder.nullField(LAST_NOTIFICATION_TIME_FIELD);
        }
        if (this.endTime != null) {
            builder.field(END_TIME_FIELD, (Object)this.endTime);
        } else {
            builder.nullField(END_TIME_FIELD);
        }
        if (this.acknowledgedTime != null) {
            builder.field(ACKNOWLEDGED_TIME_FIELD, (Object)this.acknowledgedTime);
        } else {
            builder.nullField(ACKNOWLEDGED_TIME_FIELD);
        }
        if (this.aggregationResultBucket != null) {
            this.aggregationResultBucket.innerXContent(builder);
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.detectorId);
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeInt(this.schemaVersion.intValue());
        out.writeString(this.triggerId);
        out.writeString(this.triggerName);
        out.writeStringCollection(this.findingIds);
        out.writeStringCollection(this.relatedDocIds);
        out.writeEnum((Enum)this.state);
        out.writeInstant(this.startTime);
        out.writeOptionalInstant(this.endTime);
        out.writeOptionalInstant(this.lastNotificationTime);
        out.writeOptionalInstant(this.acknowledgedTime);
        out.writeOptionalString(this.errorMessage);
        out.writeCollection(this.errorHistory);
        out.writeString(this.severity);
        out.writeCollection(this.actionExecutionResults);
        if (this.aggregationResultBucket != null) {
            out.writeBoolean(true);
            this.aggregationResultBucket.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public Integer getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public List<String> getFindingIds() {
        return this.findingIds;
    }

    public List<String> getRelatedDocIds() {
        return this.relatedDocIds;
    }

    public Alert.State getState() {
        return this.state;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Instant getLastNotificationTime() {
        return this.lastNotificationTime;
    }

    public Instant getAcknowledgedTime() {
        return this.acknowledgedTime;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public List<AlertError> getErrorHistory() {
        return this.errorHistory;
    }

    public String getSeverity() {
        return this.severity;
    }

    public List<ActionExecutionResult> getActionExecutionResults() {
        return this.actionExecutionResults;
    }

    public String getDetectorId() {
        return this.detectorId;
    }

    public AggregationResultBucket getAggregationResultBucket() {
        return this.aggregationResultBucket;
    }
}

