/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.map.storage.jpa.role;

import java.util.Arrays;
import java.util.Set;
import java.util.UUID;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Subquery;
import org.keycloak.models.RoleModel;
import org.keycloak.models.map.storage.CriterionNotSupportedException;
import org.keycloak.models.map.storage.ModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaModelCriteriaBuilder;
import org.keycloak.models.map.storage.jpa.JpaPredicateFunction;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleCompositeEntity;
import org.keycloak.models.map.storage.jpa.role.entity.JpaRoleEntity;
import org.keycloak.storage.SearchableModelField;

public class JpaRoleModelCriteriaBuilder
extends JpaModelCriteriaBuilder<JpaRoleEntity, RoleModel, JpaRoleModelCriteriaBuilder> {
    public JpaRoleModelCriteriaBuilder() {
        super(JpaRoleModelCriteriaBuilder::new);
    }

    private JpaRoleModelCriteriaBuilder(JpaPredicateFunction<JpaRoleEntity> predicateFunc) {
        super(JpaRoleModelCriteriaBuilder::new, predicateFunc);
    }

    public JpaRoleModelCriteriaBuilder compare(SearchableModelField<? super RoleModel> modelField, ModelCriteriaBuilder.Operator op, Object ... value) {
        switch (op) {
            case EQ: {
                if (modelField == RoleModel.SearchableFields.REALM_ID || modelField == RoleModel.SearchableFields.CLIENT_ID || modelField == RoleModel.SearchableFields.NAME) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaRoleModelCriteriaBuilder((cb, query, root) -> cb.equal((Expression)root.get(modelField.getName()), value[0]));
                }
                if (modelField == RoleModel.SearchableFields.COMPOSITE_ROLE) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaRoleModelCriteriaBuilder((cb, query, root) -> {
                        Subquery<UUID> subquery = query.subquery(UUID.class);
                        Root subRoot = subquery.from(JpaRoleCompositeEntity.class);
                        subquery.select((Expression)subRoot.get("key").get("roleId"));
                        CriteriaBuilder.In roleChildId = cb.in((Expression)subRoot.get("key").get("childRoleId"));
                        Arrays.stream(value).forEach(arg_0 -> ((CriteriaBuilder.In)roleChildId).value(arg_0));
                        subquery.where((Expression)roleChildId);
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        in.value(subquery);
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case IN: {
                if (modelField == RoleModel.SearchableFields.ID) {
                    Set<UUID> uuids = this.getUuidsForInOperator(value, modelField);
                    if (uuids.isEmpty()) {
                        return new JpaRoleModelCriteriaBuilder((cb, query, root) -> cb.or(new Predicate[0]));
                    }
                    return new JpaRoleModelCriteriaBuilder((cb, query, root) -> {
                        CriteriaBuilder.In in = cb.in((Expression)root.get("id"));
                        uuids.forEach(arg_0 -> ((CriteriaBuilder.In)in).value(arg_0));
                        return in;
                    });
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case ILIKE: {
                if (modelField == RoleModel.SearchableFields.NAME || modelField == RoleModel.SearchableFields.DESCRIPTION) {
                    this.validateValue(value, modelField, op, String.class);
                    return new JpaRoleModelCriteriaBuilder((cb, query, root) -> cb.like(cb.lower((Expression)root.get(modelField.getName())), value[0].toString().toLowerCase()));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
            case NOT_EXISTS: {
                if (modelField == RoleModel.SearchableFields.CLIENT_ID) {
                    return new JpaRoleModelCriteriaBuilder((cb, query, root) -> cb.isNull((Expression)root.get("clientId")));
                }
                throw new CriterionNotSupportedException(modelField, op);
            }
        }
        throw new CriterionNotSupportedException(modelField, op);
    }
}

