/*
 * Decompiled with CFR 0.152.
 */
package liquibase.parser.core.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.logging.Logger;
import liquibase.parser.core.xml.XSDLookUpException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;
import liquibase.util.LiquibaseUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;

public class LiquibaseEntityResolver
implements EntityResolver2 {
    private static ClassLoaderResourceAccessor fallbackResourceAccessor;
    private boolean shouldWarnOnMismatchedXsdVersion = false;
    private static boolean hasWarnedAboutMismatchedXsdVersion;

    @Override
    public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
        ResourceAccessor resourceAccessor;
        InputStreamList streams;
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        log.fine("Resolving XML entity name='" + name + "', publicId='" + publicId + "', baseURI='" + baseURI + "', systemId='" + systemId + "'");
        if (systemId == null) {
            log.fine("Cannot determine systemId for name=" + name + ", publicId=" + publicId + ". Will load from network.");
            return null;
        }
        String path = systemId.toLowerCase().replace("http://www.liquibase.org/xml/ns/migrator/", "http://www.liquibase.org/xml/ns/dbchangelog/").replaceFirst("https?://", "");
        if (this.shouldWarnOnMismatchedXsdVersion && !hasWarnedAboutMismatchedXsdVersion) {
            this.warnForMismatchedXsdVersion(systemId);
        }
        if ((streams = (resourceAccessor = Scope.getCurrentScope().getResourceAccessor()).openStreams(null, path)).isEmpty() && (streams = this.getFallbackResourceAccessor().openStreams(null, path)).isEmpty()) {
            if (GlobalConfiguration.SECURE_PARSING.getCurrentValue().booleanValue()) {
                String errorMessage = "Unable to resolve xml entity " + systemId + ". " + GlobalConfiguration.SECURE_PARSING.getKey() + " is set to 'true' which does not allow remote lookups. Check for spelling or capitalization errors and missing extensions such as liquibase-commercial in your XSD definition. Or, set it to 'false' to allow remote lookups of xsd files.";
                throw new XSDLookUpException(errorMessage);
            }
            log.fine("Unable to resolve XML entity locally. Will load from network.");
            return null;
        }
        if (streams.size() == 1) {
            log.fine("Found XML entity at " + streams.getURIs().get(0));
        } else if (streams.size() > 1) {
            log.warning("Found " + streams.size() + " copies of " + systemId + ". Using " + streams.getURIs().get(0));
        }
        InputStream stream = streams.iterator().next();
        InputSource source = new InputSource(stream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    private void warnForMismatchedXsdVersion(String systemId) {
        try {
            String xsdVersion;
            String buildVersion;
            Pattern versionPattern = Pattern.compile("(?:-pro-|-)(?<version>[\\d.]*)\\.xsd");
            Matcher versionMatcher = versionPattern.matcher(systemId);
            boolean found = versionMatcher.find();
            if (found && !(buildVersion = LiquibaseUtil.getBuildVersion()).equals("DEV") && !buildVersion.startsWith(xsdVersion = versionMatcher.group("version"))) {
                hasWarnedAboutMismatchedXsdVersion = true;
                String msg = "INFO: An older version of the XSD is specified in one or more changelog's <databaseChangeLog> header. This can lead to unexpected outcomes. If a specific XSD is not required, please replace all XSD version references with \"-latest\". Learn more at https://docs.liquibase.com";
                Scope.getCurrentScope().getLog(this.getClass()).info(msg);
                Scope.getCurrentScope().getUI().sendMessage(msg);
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(this.getClass()).fine("Failed to compare XSD version with build version.", e);
        }
    }

    protected ResourceAccessor getFallbackResourceAccessor() {
        if (fallbackResourceAccessor == null) {
            fallbackResourceAccessor = new ClassLoaderResourceAccessor();
        }
        return fallbackResourceAccessor;
    }

    @Override
    public InputSource getExternalSubset(String name, String baseURI) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Scope.getCurrentScope().getLog(this.getClass()).warning("The current XML parser does not seems to not support EntityResolver2. External entities may not be correctly loaded");
        return this.resolveEntity(null, publicId, null, systemId);
    }

    public void setShouldWarnOnMismatchedXsdVersion(boolean shouldWarnOnMismatchedXsdVersion) {
        this.shouldWarnOnMismatchedXsdVersion = shouldWarnOnMismatchedXsdVersion;
    }

    static {
        hasWarnedAboutMismatchedXsdVersion = false;
    }
}

