/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.status;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.TakeOfflineConfiguration;
import org.infinispan.container.impl.InternalDataContainer;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.metrics.impl.MetricUtils;
import org.infinispan.remoting.CacheUnreachableException;
import org.infinispan.remoting.RemoteException;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.notification.SiteStatusListener;
import org.infinispan.xsite.status.BringSiteOnlineResponse;
import org.infinispan.xsite.status.SiteState;
import org.infinispan.xsite.status.TakeOfflineManager;
import org.infinispan.xsite.status.TakeSiteOfflineResponse;
import org.jgroups.UnreachableException;

@Scope(value=Scopes.NAMED_CACHE)
public class DefaultTakeOfflineManager
implements TakeOfflineManager,
XSiteResponse.XSiteResponseCompleted {
    private static final Log log = LogFactory.getLog(DefaultTakeOfflineManager.class);
    private final String cacheName;
    private final Map<String, OfflineStatus> offlineStatus;
    @Inject
    TimeService timeService;
    @Inject
    Configuration config;
    @Inject
    EventLogManager eventLogManager;
    @Inject
    RpcManager rpcManager;
    @Inject
    InternalDataContainer<Object, Object> dataContainer;

    public DefaultTakeOfflineManager(String cacheName) {
        this.cacheName = cacheName;
        this.offlineStatus = new ConcurrentHashMap<String, OfflineStatus>(8);
    }

    public static boolean isCommunicationError(Throwable throwable) {
        Throwable error = throwable;
        if (throwable instanceof ExecutionException) {
            error = throwable.getCause();
        }
        return error instanceof TimeoutException || error instanceof org.infinispan.util.concurrent.TimeoutException || error instanceof UnreachableException || error instanceof CacheUnreachableException || error instanceof SuspectException;
    }

    private static Optional<CacheConfigurationException> findConfigurationError(Throwable throwable) {
        Throwable error = throwable;
        if (throwable instanceof ExecutionException || throwable instanceof RemoteException) {
            error = throwable.getCause();
        }
        return error instanceof CacheConfigurationException ? Optional.of((CacheConfigurationException)error) : Optional.empty();
    }

    @Start
    public void start() {
        String localSiteName = this.rpcManager.getTransport().localSiteName();
        this.config.sites().allBackupsStream().filter(bc -> !localSiteName.equals(bc.site())).forEach(bc -> {
            String siteName = bc.site();
            OfflineStatus offline = new OfflineStatus(bc.takeOffline(), this.timeService, new Listener(siteName));
            this.offlineStatus.put(siteName, offline);
        });
    }

    @Override
    public void registerRequest(XSiteResponse<?> response) {
        response.whenCompleted(this);
    }

    @Override
    public SiteState getSiteState(String siteName) {
        OfflineStatus offline = this.offlineStatus.get(siteName);
        if (offline == null) {
            return SiteState.NOT_FOUND;
        }
        return offline.isOffline() ? SiteState.OFFLINE : SiteState.ONLINE;
    }

    @Override
    public void amendConfiguration(String siteName, Integer afterFailures, Long minTimeToWait) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            return;
        }
        status.amend(afterFailures, minTimeToWait);
    }

    @Override
    public TakeOfflineConfiguration getConfiguration(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        return status == null ? null : status.getTakeOffline();
    }

    @Override
    public Map<String, Boolean> status() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(this.offlineStatus.size());
        for (Map.Entry<String, OfflineStatus> os : this.offlineStatus.entrySet()) {
            result.put(os.getKey(), !os.getValue().isOffline());
        }
        return result;
    }

    @Override
    public BringSiteOnlineResponse bringSiteOnline(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            log.tryingToBringOnlineNonexistentSite(siteName);
            return BringSiteOnlineResponse.NO_SUCH_SITE;
        }
        return status.bringOnline() ? BringSiteOnlineResponse.BROUGHT_ONLINE : BringSiteOnlineResponse.ALREADY_ONLINE;
    }

    @Override
    public TakeSiteOfflineResponse takeSiteOffline(String siteName) {
        OfflineStatus status = this.offlineStatus.get(siteName);
        if (status == null) {
            return TakeSiteOfflineResponse.NO_SUCH_SITE;
        }
        return status.forceOffline() ? TakeSiteOfflineResponse.TAKEN_OFFLINE : TakeSiteOfflineResponse.ALREADY_OFFLINE;
    }

    @Override
    public Collection<MBeanMetadata.AttributeMetadata> getCustomMetrics() {
        ArrayList<MBeanMetadata.AttributeMetadata> attributes = new ArrayList<MBeanMetadata.AttributeMetadata>(this.offlineStatus.size() * 3);
        for (Map.Entry<String, OfflineStatus> entry : this.offlineStatus.entrySet()) {
            String lowerCaseSite = entry.getKey().toLowerCase();
            OfflineStatus status = entry.getValue();
            attributes.add(MetricUtils.createGauge(lowerCaseSite + "_status", entry.getKey() + " status. 1=online, 0=offline", o -> status.isOffline() ? 0 : 1));
            attributes.add(MetricUtils.createGauge(lowerCaseSite + "_failures_count", "Number of consecutive failures to " + entry.getKey(), o -> status.getFailureCount()));
            attributes.add(MetricUtils.createGauge(lowerCaseSite + "_millis_since_first_failure", "Milliseconds from first consecutive failure to " + entry.getKey(), o -> status.millisSinceFirstFailure()));
        }
        return attributes;
    }

    @Override
    public void onCompleted(XSiteBackup backup, long sendTimeNanos, long durationNanos, Throwable throwable) {
        OfflineStatus status = this.offlineStatus.get(backup.getSiteName());
        assert (status != null);
        Optional<CacheConfigurationException> e = DefaultTakeOfflineManager.findConfigurationError(throwable);
        if (e.isPresent()) {
            log.xsiteInvalidConfigurationRemoteSite(backup.getSiteName(), e.get());
            status.forceOffline();
            return;
        }
        if (status.isEnabled()) {
            if (DefaultTakeOfflineManager.isCommunicationError(throwable)) {
                status.updateOnCommunicationFailure(TimeUnit.NANOSECONDS.toMillis(sendTimeNanos));
            } else if (!status.isOffline()) {
                status.reset();
            }
        }
    }

    public OfflineStatus getOfflineStatus(String siteName) {
        return this.offlineStatus.get(siteName);
    }

    public String toString() {
        return "DefaultTakeOfflineManager{cacheName='" + this.cacheName + "'}";
    }

    private EventLogger getEventLogger() {
        return this.eventLogManager.getEventLogger().context(this.cacheName).scope(this.rpcManager.getAddress());
    }

    private final class Listener
    implements SiteStatusListener {
        private final String siteName;

        Listener(String siteName) {
            this.siteName = siteName;
        }

        @Override
        public void siteOnline() {
            DefaultTakeOfflineManager.this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOnline(this.siteName));
        }

        @Override
        public void siteOffline() {
            DefaultTakeOfflineManager.this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOffline(this.siteName));
            log.debug("Touching all in memory entries as a site has gone offline");
            long currentTimeMillis = DefaultTakeOfflineManager.this.timeService.wallClockTime();
            DefaultTakeOfflineManager.this.dataContainer.forEachSegment((map, segment) -> map.touchAll(currentTimeMillis));
        }

        public String toString() {
            return "Listener{siteName='" + this.siteName + "'}";
        }
    }
}

