/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services;

import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.keycloak.common.Version;
import org.keycloak.protocol.oidc.OIDCLoginProtocolService;
import org.keycloak.protocol.oidc.endpoints.LogoutEndpoint;
import org.keycloak.services.resources.IdentityBrokerService;
import org.keycloak.services.resources.LoginActionsService;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.services.resources.ThemeResource;
import org.keycloak.services.resources.account.AccountFormService;
import org.keycloak.services.resources.admin.AdminRoot;

public class Urls {
    public static URI adminConsoleRoot(URI baseUri, String realmName) {
        return UriBuilder.fromUri((URI)baseUri).path(AdminRoot.class).path("{realm}/console/").build(new Object[]{realmName});
    }

    public static URI accountApplicationsPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "applicationsPage").build(new Object[]{realmName});
    }

    public static UriBuilder accountBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getAccountService");
    }

    public static URI accountPage(URI baseUri, String realmName) {
        return Urls.accountPageBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder accountPageBuilder(URI baseUri) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "accountPage");
    }

    public static URI accountPasswordPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "passwordPage").build(new Object[]{realmName});
    }

    public static URI accountFederatedIdentityPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "federatedIdentityPage").build(new Object[]{realmName});
    }

    public static URI accountFederatedIdentityUpdate(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "processFederatedIdentityUpdate").build(new Object[]{realmName});
    }

    public static URI identityProviderAuthnResponse(URI baseUri, String providerId, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "getEndpoint").build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderAuthnRequest(URI baseUri, String providerId, String realmName, String accessCode, String clientId, String tabId) {
        UriBuilder uriBuilder = Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "performLogin");
        if (accessCode != null) {
            uriBuilder.replaceQueryParam("session_code", new Object[]{accessCode});
        }
        if (clientId != null) {
            uriBuilder.replaceQueryParam("client_id", new Object[]{clientId});
        }
        if (tabId != null) {
            uriBuilder.replaceQueryParam("tab_id", new Object[]{tabId});
        }
        return uriBuilder.build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderLinkRequest(URI baseUri, String providerId, String realmName) {
        UriBuilder uriBuilder = Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").replaceQuery(null).path(IdentityBrokerService.class, "clientInitiatedAccountLinking");
        return uriBuilder.build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderRetrieveToken(URI baseUri, String providerId, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "retrieveToken").build(new Object[]{realmName, providerId});
    }

    public static URI identityProviderAuthnRequest(URI baseURI, String providerId, String realmName) {
        return Urls.identityProviderAuthnRequest(baseURI, providerId, realmName, null, null, null);
    }

    public static URI identityProviderAfterFirstBrokerLogin(URI baseUri, String realmName, String accessCode, String clientId, String tabId) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterFirstBrokerLogin").replaceQueryParam("session_code", new Object[]{accessCode}).replaceQueryParam("client_id", new Object[]{clientId}).replaceQueryParam("tab_id", new Object[]{tabId}).build(new Object[]{realmName});
    }

    public static URI identityProviderAfterPostBrokerLogin(URI baseUri, String realmName, String accessCode, String clientId, String tabId) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getBrokerService").path(IdentityBrokerService.class, "afterPostBrokerLoginFlow").replaceQueryParam("session_code", new Object[]{accessCode}).replaceQueryParam("client_id", new Object[]{clientId}).replaceQueryParam("tab_id", new Object[]{tabId}).build(new Object[]{realmName});
    }

    public static URI accountTotpPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "totpPage").build(new Object[]{realmName});
    }

    public static URI accountLogPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "logPage").build(new Object[]{realmName});
    }

    public static URI accountSessionsPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "sessionsPage").build(new Object[]{realmName});
    }

    public static URI accountLogout(URI baseUri, URI redirectUri, String realmName, String idTokenHint) {
        return Urls.realmLogout(baseUri).queryParam("post_logout_redirect_uri", new Object[]{redirectUri}).queryParam("id_token_hint", new Object[]{idTokenHint}).build(new Object[]{realmName});
    }

    public static URI logoutConfirm(URI baseUri, String realmName) {
        return Urls.realmLogout(baseUri).path(LogoutEndpoint.class, "logoutConfirmAction").build(new Object[]{realmName});
    }

    public static URI accountResourcesPage(URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "resourcesPage").build(new Object[]{realmName});
    }

    public static URI accountResourceDetailPage(String resourceId, URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "resourceDetailPage").build(new Object[]{realmName, resourceId});
    }

    public static URI accountResourceGrant(String resourceId, URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "grantPermission").build(new Object[]{realmName, resourceId});
    }

    public static URI accountResourceShare(String resourceId, URI baseUri, String realmName) {
        return Urls.accountBase(baseUri).path(AccountFormService.class, "shareResource").build(new Object[]{realmName, resourceId});
    }

    public static URI loginActionUpdatePassword(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updatePassword").build(new Object[]{realmName});
    }

    public static URI loginActionUpdateTotp(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updateTotp").build(new Object[]{realmName});
    }

    public static UriBuilder requiredActionBase(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "requiredAction");
    }

    public static URI loginActionUpdateProfile(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "updateProfile").build(new Object[]{realmName});
    }

    public static URI loginActionEmailVerification(URI baseUri, String realmName) {
        return Urls.loginActionEmailVerificationBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder loginActionEmailVerificationBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "emailVerification");
    }

    public static URI loginResetCredentials(URI baseUri, String realmName) {
        return Urls.loginResetCredentialsBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder actionTokenBuilder(URI baseUri, String tokenString, String clientId, String tabId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "executeActionToken").queryParam("key", new Object[]{tokenString}).queryParam("client_id", new Object[]{clientId}).queryParam("tab_id", new Object[]{tabId});
    }

    public static UriBuilder loginResetCredentialsBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path("reset-credentials");
    }

    public static URI loginUsernameReminder(URI baseUri, String realmName) {
        return Urls.loginUsernameReminderBuilder(baseUri).build(new Object[]{realmName});
    }

    public static UriBuilder loginUsernameReminderBuilder(URI baseUri) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "usernameReminder");
    }

    public static String realmIssuer(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path("{realm}").build(new Object[]{realmName}).toString();
    }

    public static UriBuilder realmBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(RealmsResource.class);
    }

    public static URI realmLoginPage(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "authenticate").build(new Object[]{realmName});
    }

    public static URI realmLoginRestartPage(URI baseUri, String realmId) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "restartSession").build(new Object[]{realmId});
    }

    private static UriBuilder realmLogout(URI baseUri) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "logout");
    }

    public static URI realmRegisterAction(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processRegister").build(new Object[]{realmName});
    }

    public static URI realmRegisterPage(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "registerPage").build(new Object[]{realmName});
    }

    public static URI realmInstalledAppUrnCallback(URI baseUri, String realmName) {
        return Urls.tokenBase(baseUri).path(OIDCLoginProtocolService.class, "installedAppUrnCallback").build(new Object[]{realmName});
    }

    public static URI realmOauthAction(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "processConsent").build(new Object[]{realmName});
    }

    public static URI firstBrokerLoginProcessor(URI baseUri, String realmName) {
        return Urls.loginActionsBase(baseUri).path(LoginActionsService.class, "firstBrokerLoginGet").build(new Object[]{realmName});
    }

    public static String localeCookiePath(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path(realmName).build(new Object[0]).getRawPath();
    }

    public static URI themeRoot(URI baseUri) {
        return Urls.themeBase(baseUri).path(Version.RESOURCES_VERSION).build(new Object[0]);
    }

    public static UriBuilder loginActionsBase(URI baseUri) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getLoginActionsService");
    }

    private static UriBuilder tokenBase(URI baseUri) {
        return Urls.realmBase(baseUri).path("{realm}/protocol/openid-connect");
    }

    private static UriBuilder themeBase(URI baseUri) {
        return UriBuilder.fromUri((URI)baseUri).path(ThemeResource.class);
    }

    public static URI samlRequestEndpoint(URI baseUri, String realmName) {
        return Urls.realmBase(baseUri).path(RealmsResource.class, "getProtocol").build(new Object[]{realmName, "saml"});
    }
}

