/*
 * Decompiled with CFR 0.152.
 */
package com.github.junrar.rarfile;

import com.github.junrar.io.Raw;
import com.github.junrar.rarfile.BaseBlock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainHeader
extends BaseBlock {
    private static final Logger logger = LoggerFactory.getLogger(MainHeader.class);
    public static final short mainHeaderSizeWithEnc = 7;
    public static final short mainHeaderSize = 6;
    private final short highPosAv;
    private final int posAv;
    private byte encryptVersion;

    public MainHeader(BaseBlock bb, byte[] mainHeader) {
        super(bb);
        int pos = 0;
        this.highPosAv = Raw.readShortLittleEndian(mainHeader, pos);
        this.posAv = Raw.readIntLittleEndian(mainHeader, pos += 2);
        pos += 4;
        if (this.hasEncryptVersion()) {
            this.encryptVersion = (byte)(this.encryptVersion | mainHeader[pos] & 0xFF);
        }
    }

    public boolean hasArchCmt() {
        return (this.flags & 2) != 0;
    }

    public byte getEncryptVersion() {
        return this.encryptVersion;
    }

    public short getHighPosAv() {
        return this.highPosAv;
    }

    public int getPosAv() {
        return this.posAv;
    }

    public boolean isEncrypted() {
        return (this.flags & 0x80) != 0;
    }

    public boolean isMultiVolume() {
        return (this.flags & 1) != 0;
    }

    public boolean isFirstVolume() {
        return (this.flags & 0x100) != 0;
    }

    @Override
    public void print() {
        super.print();
        if (logger.isInfoEnabled()) {
            StringBuilder str = new StringBuilder();
            str.append("posav: ").append(this.getPosAv());
            str.append("\nhighposav: ").append(this.getHighPosAv());
            str.append("\nhasencversion: ").append(this.hasEncryptVersion()).append(this.hasEncryptVersion() ? Byte.valueOf(this.getEncryptVersion()) : "");
            str.append("\nhasarchcmt: ").append(this.hasArchCmt());
            str.append("\nisEncrypted: ").append(this.isEncrypted());
            str.append("\nisMultivolume: ").append(this.isMultiVolume());
            str.append("\nisFirstvolume: ").append(this.isFirstVolume());
            str.append("\nisSolid: ").append(this.isSolid());
            str.append("\nisLocked: ").append(this.isLocked());
            str.append("\nisProtected: ").append(this.isProtected());
            str.append("\nisAV: ").append(this.isAV());
            logger.info(str.toString());
        }
    }

    public boolean isSolid() {
        return (this.flags & 8) != 0;
    }

    public boolean isLocked() {
        return (this.flags & 4) != 0;
    }

    public boolean isProtected() {
        return (this.flags & 0x40) != 0;
    }

    public boolean isAV() {
        return (this.flags & 0x20) != 0;
    }

    public boolean isNewNumbering() {
        return (this.flags & 0x10) != 0;
    }
}

