/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import com.codahale.metrics.MetricSet;
import com.codahale.metrics.jvm.CachedThreadStatesGaugeSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.google.common.annotations.VisibleForTesting;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.UnavailableException;
import org.apache.http.client.HttpClient;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.MetricsConfig;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoBean;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.metrics.AltBufferPoolMetricSet;
import org.apache.solr.metrics.MetricsMap;
import org.apache.solr.metrics.OperatingSystemMetricSet;
import org.apache.solr.metrics.SolrMetricManager;
import org.apache.solr.metrics.SolrMetricProducer;
import org.apache.solr.servlet.RateLimitManager;
import org.apache.solr.util.SolrVersion;
import org.apache.solr.util.StartupLoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreContainerProvider
implements ServletContextListener {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String metricTag = SolrMetricProducer.getUniqueMetricTag(this, null);
    private CoreContainer cores;
    private Properties extraProperties;
    private HttpClient httpClient;
    private SolrMetricManager metricManager;
    private RateLimitManager rateLimitManager;
    private final CountDownLatch init = new CountDownLatch(1);
    private String registryName;
    private static final Map<ContextInitializationKey, ServiceHolder> services = Collections.synchronizedMap(new WeakHashMap());

    public static ServiceHolder serviceForContext(ServletContext ctx) throws InterruptedException {
        ContextInitializationKey key = new ContextInitializationKey(ctx);
        return services.computeIfAbsent(key, x$0 -> new ServiceHolder((ContextInitializationKey)x$0));
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.init(sce.getServletContext());
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.close();
    }

    CoreContainer getCoreContainer() throws UnavailableException {
        CoreContainerProvider.waitForCoreContainer(() -> this.cores, this.init);
        return this.cores;
    }

    HttpClient getHttpClient() throws UnavailableException {
        CoreContainerProvider.waitForCoreContainer(() -> this.cores, this.init);
        return this.httpClient;
    }

    private static void waitForCoreContainer(Supplier<CoreContainer> provider, CountDownLatch latch) throws UnavailableException {
        CoreContainer cores = provider.get();
        if (cores == null || cores.isShutDown()) {
            long startWait = System.nanoTime();
            try {
                while (!latch.await(10L, TimeUnit.SECONDS)) {
                    long now = System.nanoTime();
                    if (!log.isInfoEnabled()) continue;
                    log.info("Still waiting for CoreContainerStartup ({} seconds elapsed)", (Object)((now - startWait) / 1000000000L));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            cores = provider.get();
            if (cores == null || cores.isShutDown()) {
                String msg = "Error processing the request. CoreContainer is either not initialized or shutting down.";
                log.error("Error processing the request. CoreContainer is either not initialized or shutting down.");
                throw new UnavailableException("Error processing the request. CoreContainer is either not initialized or shutting down.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        block10: {
            CoreContainer cc = this.cores;
            this.cores = null;
            try {
                if (this.metricManager == null) break block10;
                try {
                    this.metricManager.unregisterGauges(this.registryName, this.metricTag);
                }
                catch (NullPointerException nullPointerException) {
                    this.metricManager = null;
                }
                catch (Exception e) {
                    log.warn("Exception closing FileCleaningTracker", (Throwable)e);
                }
                finally {
                    this.metricManager = null;
                }
            }
            finally {
                if (cc != null) {
                    this.httpClient = null;
                    cc.shutdown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext servletContext) {
        if (log.isTraceEnabled()) {
            log.trace("CoreService.init(): {}", (Object)this.getClass().getClassLoader());
        }
        CoreContainer coresInit = null;
        try {
            String logLevel;
            this.extraProperties = SolrXmlConfig.wrapAndSetZkHostFromSysPropIfNeeded((Properties)servletContext.getAttribute("solr.properties"));
            StartupLoggingUtils.checkLogDir();
            if (log.isInfoEnabled()) {
                log.info("Using logger factory {}", (Object)StartupLoggingUtils.getLoggerImplStr());
            }
            this.logWelcomeBanner();
            String muteConsole = System.getProperty("solr.log.muteconsole");
            if (muteConsole != null && !Arrays.asList("false", "0", "off", "no").contains(muteConsole.toLowerCase(Locale.ROOT))) {
                StartupLoggingUtils.muteConsole();
            }
            if ((logLevel = System.getProperty("solr.log.level")) != null) {
                log.info("Log level override, property solr.log.level={}", (Object)logLevel);
                StartupLoggingUtils.changeLogLevel(logLevel);
            }
            coresInit = this.createCoreContainer(CoreContainerProvider.computeSolrHome(servletContext), this.extraProperties);
            this.httpClient = coresInit.getUpdateShardHandler().getDefaultHttpClient();
            this.setupJvmMetrics(coresInit, coresInit.getNodeConfig().getMetricsConfig());
            SolrZkClient zkClient = null;
            ZkController zkController = coresInit.getZkController();
            if (zkController != null) {
                zkClient = zkController.getZkClient();
            }
            RateLimitManager.Builder builder = new RateLimitManager.Builder(zkClient);
            this.rateLimitManager = builder.build();
            if (zkController != null) {
                zkController.zkStateReader.registerClusterPropertiesListener((ClusterPropertiesListener)this.rateLimitManager);
            }
            if (log.isDebugEnabled()) {
                log.debug("user.dir={}", (Object)System.getProperty("user.dir"));
            }
        }
        catch (Throwable t) {
            log.error("Could not start Solr. Check solr/home property and the logs");
            SolrCore.log(t);
            if (t instanceof Error) {
                throw (Error)t;
            }
        }
        finally {
            log.trace("SolrDispatchFilter.init() done");
            this.cores = coresInit;
            services.computeIfAbsent(new ContextInitializationKey(servletContext), x$0 -> new ServiceHolder((ContextInitializationKey)x$0)).setService(this);
            this.init.countDown();
        }
    }

    private void logWelcomeBanner() {
        if (log.isInfoEnabled()) {
            log.info(" ___      _       Welcome to Apache Solr\u2122 version {}", (Object)this.solrVersion());
        }
        if (log.isInfoEnabled()) {
            log.info("/ __| ___| |_ _   Starting in {} mode on port {}", (Object)(this.isCloudMode() ? "cloud" : "standalone"), (Object)this.getSolrPort());
        }
        if (log.isInfoEnabled()) {
            log.info("\\__ \\/ _ \\ | '_|  Install dir: {}", (Object)System.getProperty("solr.install.dir"));
        }
        if (log.isInfoEnabled()) {
            log.info("|___/\\___/_|_|    Start time: {}", (Object)Instant.now());
        }
        try {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            Optional<String> crashOnOutOfMemoryErrorArg = mx.getInputArguments().stream().filter(x -> x.startsWith("-XX:+CrashOnOutOfMemoryError")).findFirst();
            if (crashOnOutOfMemoryErrorArg.isPresent()) {
                String errorFileArg = mx.getInputArguments().stream().filter(x -> x.startsWith("-XX:ErrorFile")).findFirst().orElse("-XX:ErrorFile=hs_err_%p.log");
                String errorFilePath = errorFileArg.substring(errorFileArg.indexOf(61) + 1).replace("%p", String.valueOf(mx.getPid()));
                String logMessage = "Solr started with \"-XX:+CrashOnOutOfMemoryError\" that will crash on any OutOfMemoryError exception. The cause of the OOME will be logged in the crash file at the following path: {}";
                log.info(logMessage, (Object)errorFilePath);
            }
        }
        catch (Exception e) {
            String logMessage = String.format(Locale.ROOT, "Solr typically starts with \"-XX:+CrashOnOutOfMemoryError\" that will crash on any OutOfMemoryError exception. Unable to get the specific file due to an exception.The cause of the OOME will be logged in a crash file in the logs directory: %s", System.getProperty("solr.log.dir"));
            log.info(logMessage, (Throwable)e);
        }
    }

    private String solrVersion() {
        String specVer = SolrVersion.LATEST.toString();
        try {
            String implVer = SolrCore.class.getPackage().getImplementationVersion();
            return specVer.equals(implVer.split(" ")[0]) ? specVer : implVer;
        }
        catch (Exception e) {
            return specVer;
        }
    }

    private String getSolrPort() {
        return System.getProperty("jetty.port");
    }

    private boolean isCloudMode() {
        assert (null != this.extraProperties);
        return null != this.extraProperties.getProperty("zkHost") || null != System.getProperty("zkRun");
    }

    private static Path computeSolrHome(ServletContext servletContext) {
        Object source = "servlet config: solr.solr.home";
        String home = (String)servletContext.getAttribute("solr.solr.home");
        if (null == home) {
            String lookup = "java:comp/env/solr/home";
            source = "JNDI: java:comp/env/solr/home";
            try {
                InitialContext c = new InitialContext();
                home = (String)c.lookup("java:comp/env/solr/home");
            }
            catch (NoInitialContextException e) {
                log.debug("JNDI not configured for solr (NoInitialContextEx)");
            }
            catch (NamingException e) {
                log.debug("No /solr/home in JNDI");
            }
            catch (RuntimeException ex) {
                log.warn("Odd RuntimeException while testing for JNDI: ", (Throwable)ex);
            }
        }
        if (null == home) {
            String prop = "solr.solr.home";
            source = "system property: solr.solr.home";
            home = System.getProperty("solr.solr.home");
        }
        if (null == home) {
            home = "solr/";
            source = "defaulted to '" + home + "' ... could not find system property or JNDI";
        }
        Path solrHome = Paths.get(home, new String[0]).toAbsolutePath().normalize();
        log.info("Solr Home: {} (source: {})", (Object)solrHome, source);
        return solrHome;
    }

    protected CoreContainer createCoreContainer(Path solrHome, Properties nodeProps) {
        NodeConfig nodeConfig = NodeConfig.loadNodeConfig(solrHome, nodeProps);
        CoreContainer coreContainer = new CoreContainer(nodeConfig, true);
        coreContainer.load();
        return coreContainer;
    }

    private void setupJvmMetrics(CoreContainer coresInit, MetricsConfig config) {
        this.metricManager = coresInit.getMetricManager();
        this.registryName = SolrMetricManager.getRegistryName(SolrInfoBean.Group.jvm, new String[0]);
        Set<String> hiddenSysProps = coresInit.getConfig().getMetricsConfig().getHiddenSysProps();
        try {
            this.metricManager.registerAll(this.registryName, new AltBufferPoolMetricSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "buffers");
            this.metricManager.registerAll(this.registryName, (MetricSet)new ClassLoadingGaugeSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "classes");
            this.metricManager.registerAll(this.registryName, new OperatingSystemMetricSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "os");
            this.metricManager.registerAll(this.registryName, (MetricSet)new GarbageCollectorMetricSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "gc");
            this.metricManager.registerAll(this.registryName, (MetricSet)new MemoryUsageGaugeSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "memory");
            if (config.getCacheConfig() != null && config.getCacheConfig().threadsIntervalSeconds != null) {
                if (log.isInfoEnabled()) {
                    log.info("Threads metrics will be cached for {} seconds", (Object)config.getCacheConfig().threadsIntervalSeconds);
                }
                this.metricManager.registerAll(this.registryName, (MetricSet)new CachedThreadStatesGaugeSet((long)config.getCacheConfig().threadsIntervalSeconds.intValue(), TimeUnit.SECONDS), SolrMetricManager.ResolutionStrategy.IGNORE, "threads");
            } else {
                this.metricManager.registerAll(this.registryName, (MetricSet)new ThreadStatesGaugeSet(), SolrMetricManager.ResolutionStrategy.IGNORE, "threads");
            }
            MetricsMap sysprops = new MetricsMap(map -> System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                if (!hiddenSysProps.contains(k)) {
                    map.putNoEx((CharSequence)String.valueOf(k), v);
                }
            })));
            this.metricManager.registerGauge(null, this.registryName, sysprops, this.metricTag, SolrMetricManager.ResolutionStrategy.IGNORE, "properties", "system");
            MetricsMap sysenv = new MetricsMap(map -> System.getenv().forEach((k, v) -> {
                if (!hiddenSysProps.contains(k)) {
                    map.putNoEx((CharSequence)String.valueOf(k), v);
                }
            }));
            this.metricManager.registerGauge(null, this.registryName, sysenv, this.metricTag, SolrMetricManager.ResolutionStrategy.IGNORE, "env", "system");
        }
        catch (Exception e) {
            log.warn("Error registering JVM metrics", (Throwable)e);
        }
    }

    public RateLimitManager getRateLimitManager() {
        return this.rateLimitManager;
    }

    @VisibleForTesting
    void setRateLimitManager(RateLimitManager rateLimitManager) {
        this.rateLimitManager = rateLimitManager;
    }

    static class ServiceHolder {
        private volatile CoreContainerProvider service;
        private volatile ContextInitializationKey key;

        private ServiceHolder(ContextInitializationKey key) {
            if (key == null) {
                throw new IllegalArgumentException("Key for accessing this service holder must be supplied");
            }
            this.key = key;
        }

        public void setService(CoreContainerProvider service) {
            this.service = service;
            this.key.makeReady();
            this.key = null;
        }

        public CoreContainerProvider getService() {
            try {
                if (this.key != null) {
                    try {
                        this.key.waitForReadyService();
                    }
                    catch (NullPointerException nullPointerException) {}
                }
            }
            catch (InterruptedException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted while obtaining reference to CoreService");
            }
            return this.service;
        }
    }

    private static class ContextInitializationKey {
        private final ServletContext ctx;
        private final CountDownLatch initializing = new CountDownLatch(1);

        private ContextInitializationKey(ServletContext ctx) {
            if (ctx == null) {
                throw new IllegalArgumentException("Context must not be null");
            }
            ctx.setAttribute(this.getClass().getName(), (Object)this);
            this.ctx = ctx;
        }

        public synchronized ServletContext getCtx() {
            return this.ctx;
        }

        synchronized void makeReady() {
            this.initializing.countDown();
        }

        public void waitForReadyService() throws InterruptedException {
            this.initializing.await();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ContextInitializationKey)) {
                return false;
            }
            ContextInitializationKey that = (ContextInitializationKey)o;
            return this.ctx.equals(that.ctx);
        }

        public int hashCode() {
            return Objects.hash(this.ctx);
        }
    }
}

