/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.designer;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.designer.SampleDocuments;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.StrField;
import org.apache.solr.util.plugin.NamedListInitializedPlugin;

public interface SampleDocumentsLoader
extends NamedListInitializedPlugin {
    public SampleDocuments parseDocsFromStream(SolrParams var1, ContentStream var2, int var3) throws IOException;

    default public boolean ensureUniqueKey(SchemaField idField, List<SolrInputDocument> docs) {
        boolean updatedDocs = false;
        if (StrField.class.equals(idField.getType().getClass())) {
            String idFieldName = idField.getName();
            for (SolrInputDocument d : docs) {
                if (d.getFieldValue(idFieldName) != null) continue;
                d.setField(idFieldName, (Object)UUID.randomUUID().toString().toLowerCase(Locale.ROOT));
                updatedDocs = true;
            }
        }
        return updatedDocs;
    }
}

