/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.events.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.solr.cloud.ClusterSingleton;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cluster.events.ClusterEvent;
import org.apache.solr.cluster.events.ClusterEventProducerBase;
import org.apache.solr.cluster.events.ClusterPropertiesChangedEvent;
import org.apache.solr.cluster.events.CollectionsAddedEvent;
import org.apache.solr.cluster.events.CollectionsRemovedEvent;
import org.apache.solr.cluster.events.NodesDownEvent;
import org.apache.solr.cluster.events.NodesUpEvent;
import org.apache.solr.common.cloud.CloudCollectionsListener;
import org.apache.solr.common.cloud.ClusterPropertiesListener;
import org.apache.solr.common.cloud.LiveNodesListener;
import org.apache.solr.core.CoreContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClusterEventProducer
extends ClusterEventProducerBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private LiveNodesListener liveNodesListener;
    private CloudCollectionsListener cloudCollectionsListener;
    private ClusterPropertiesListener clusterPropertiesListener;
    private ZkController zkController;
    private final Set<ClusterEvent.EventType> supportedEvents = new HashSet<ClusterEvent.EventType>(Arrays.asList(ClusterEvent.EventType.NODES_DOWN, ClusterEvent.EventType.NODES_UP, ClusterEvent.EventType.COLLECTIONS_ADDED, ClusterEvent.EventType.COLLECTIONS_REMOVED, ClusterEvent.EventType.CLUSTER_PROPERTIES_CHANGED));

    public DefaultClusterEventProducer(CoreContainer cc) {
        super(cc);
    }

    @Override
    public synchronized void start() {
        if (this.cc == null) {
            this.liveNodesListener = null;
            this.cloudCollectionsListener = null;
            this.clusterPropertiesListener = null;
            this.state = ClusterSingleton.State.STOPPED;
            return;
        }
        if (this.state == ClusterSingleton.State.RUNNING) {
            log.warn("Double start() invoked on {}, ignoring", (Object)this);
            return;
        }
        this.state = ClusterSingleton.State.STARTING;
        this.zkController = this.cc.getZkController();
        this.doStop();
        this.liveNodesListener = (oldNodes, newNodes) -> {
            if (this.state == ClusterSingleton.State.STOPPING || this.state == ClusterSingleton.State.STOPPED) {
                return true;
            }
            if (oldNodes.equals(newNodes)) {
                return false;
            }
            final Instant now = Instant.now();
            final HashSet downNodes = new HashSet(oldNodes);
            downNodes.removeAll(newNodes);
            if (!downNodes.isEmpty()) {
                log.debug("creating nodes down event for nodes: {}", downNodes);
                this.fireEvent(new NodesDownEvent(){

                    @Override
                    public Iterator<String> getNodeNames() {
                        return downNodes.iterator();
                    }

                    @Override
                    public Instant getTimestamp() {
                        return now;
                    }
                });
            }
            final HashSet upNodes = new HashSet(newNodes);
            upNodes.removeAll(oldNodes);
            if (!upNodes.isEmpty()) {
                log.debug("creating nodes up event for nodes: {}", upNodes);
                this.fireEvent(new NodesUpEvent(){

                    @Override
                    public Iterator<String> getNodeNames() {
                        return upNodes.iterator();
                    }

                    @Override
                    public Instant getTimestamp() {
                        return now;
                    }
                });
            }
            return false;
        };
        this.zkController.zkStateReader.registerLiveNodesListener(this.liveNodesListener);
        this.cloudCollectionsListener = (oldCollections, newCollections) -> {
            if (oldCollections.equals(newCollections)) {
                return;
            }
            final Instant now = Instant.now();
            final HashSet removed = new HashSet(oldCollections);
            removed.removeAll(newCollections);
            if (!removed.isEmpty()) {
                log.debug("creating collections removed event for collections: {}", removed);
                this.fireEvent(new CollectionsRemovedEvent(){

                    @Override
                    public Iterator<String> getCollectionNames() {
                        return removed.iterator();
                    }

                    @Override
                    public Instant getTimestamp() {
                        return now;
                    }
                });
            }
            final HashSet added = new HashSet(newCollections);
            added.removeAll(oldCollections);
            if (!added.isEmpty()) {
                log.debug("creating collections added event for collections: {}", added);
                this.fireEvent(new CollectionsAddedEvent(){

                    @Override
                    public Iterator<String> getCollectionNames() {
                        return added.iterator();
                    }

                    @Override
                    public Instant getTimestamp() {
                        return now;
                    }
                });
            }
        };
        this.zkController.zkStateReader.registerCloudCollectionsListener(this.cloudCollectionsListener);
        this.clusterPropertiesListener = newProperties -> {
            this.fireEvent(new ClusterPropertiesChangedEvent(){
                final Instant now = Instant.now();

                @Override
                public Map<String, Object> getNewClusterProperties() {
                    return newProperties;
                }

                @Override
                public Instant getTimestamp() {
                    return this.now;
                }
            });
            return false;
        };
        this.zkController.zkStateReader.registerClusterPropertiesListener(this.clusterPropertiesListener);
        this.state = ClusterSingleton.State.RUNNING;
    }

    @Override
    public Set<ClusterEvent.EventType> getSupportedEventTypes() {
        return this.supportedEvents;
    }

    @Override
    public synchronized void stop() {
        this.state = ClusterSingleton.State.STOPPING;
        this.doStop();
        this.state = ClusterSingleton.State.STOPPED;
    }

    private void doStop() {
        if (this.liveNodesListener != null) {
            this.zkController.zkStateReader.removeLiveNodesListener(this.liveNodesListener);
        }
        if (this.cloudCollectionsListener != null) {
            this.zkController.zkStateReader.removeCloudCollectionsListener(this.cloudCollectionsListener);
        }
        if (this.clusterPropertiesListener != null) {
            this.zkController.zkStateReader.removeClusterPropertiesListener(this.clusterPropertiesListener);
        }
        this.liveNodesListener = null;
        this.cloudCollectionsListener = null;
        this.clusterPropertiesListener = null;
    }

    @Override
    public void close() throws IOException {
        this.stop();
        super.close();
    }
}

