/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.api.collections;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.solr.cloud.ActiveReplicaWatcher;
import org.apache.solr.cloud.api.collections.AddReplicaCmd;
import org.apache.solr.cloud.api.collections.Assign;
import org.apache.solr.cloud.api.collections.CollApiCmds;
import org.apache.solr.cloud.api.collections.CollectionCommandContext;
import org.apache.solr.cloud.api.collections.DeleteNodeCmd;
import org.apache.solr.cloud.api.collections.DeleteReplicaCmd;
import org.apache.solr.cloud.api.collections.LeaderRecoveryWatcher;
import org.apache.solr.common.SolrCloseableLatch;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.ReplicaPosition;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplaceNodeCmd
implements CollApiCmds.CollectionApiCommand {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final CollectionCommandContext ccc;

    public ReplaceNodeCmd(CollectionCommandContext ccc) {
        this.ccc = ccc;
    }

    @Override
    public void call(ClusterState state, ZkNodeProps message, NamedList<Object> results) throws Exception {
        ZkStateReader zkStateReader = this.ccc.getZkStateReader();
        String source = message.getStr("sourceNode");
        String target = message.getStr("targetNode");
        boolean waitForFinalState = message.getBool("waitForFinalState", false);
        if (source == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "sourceNode is a required param");
        }
        String async = message.getStr("async");
        int timeout = message.getInt("timeout", Integer.valueOf(600));
        boolean parallel = message.getBool("parallel", false);
        ClusterState clusterState = zkStateReader.getClusterState();
        if (!clusterState.liveNodesContain(source)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Source Node: " + source + " is not live");
        }
        if (target != null && !clusterState.liveNodesContain(target)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Target Node: " + target + " is not live");
        }
        if (clusterState.getLiveNodes().size() <= 1) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No nodes other than the source node: " + source + " are live, therefore replicas cannot be moved");
        }
        List<ZkNodeProps> sourceReplicas = ReplaceNodeCmd.getReplicasOfNode(source, clusterState);
        int numLeaders = 0;
        for (ZkNodeProps props : sourceReplicas) {
            if (!props.getBool("leader", false) && !waitForFinalState) continue;
            ++numLeaders;
        }
        HashMap<CallSite, ActiveReplicaWatcher> watchers = new HashMap<CallSite, ActiveReplicaWatcher>();
        ArrayList<ZkNodeProps> createdReplicas = new ArrayList<ZkNodeProps>();
        AtomicBoolean anyOneFailed = new AtomicBoolean(false);
        SolrCloseableLatch countDownLatch = new SolrCloseableLatch(sourceReplicas.size(), this.ccc.getCloseableToLatchOn());
        SolrCloseableLatch replicasToRecover = new SolrCloseableLatch(numLeaders, this.ccc.getCloseableToLatchOn());
        List<ReplicaPosition> replicaPositions = null;
        if (target == null || target.isEmpty()) {
            ArrayList<Assign.AssignRequest> assignRequests = new ArrayList<Assign.AssignRequest>(sourceReplicas.size());
            for (ZkNodeProps sourceReplica : sourceReplicas) {
                Replica.Type replicaType = Replica.Type.get((String)sourceReplica.getStr("type"));
                int numNrtReplicas = replicaType == Replica.Type.NRT ? 1 : 0;
                int numTlogReplicas = replicaType == Replica.Type.TLOG ? 1 : 0;
                int numPullReplicas = replicaType == Replica.Type.PULL ? 1 : 0;
                Assign.AssignRequest assignRequest = new Assign.AssignRequestBuilder().forCollection(sourceReplica.getStr("collection")).forShard(Collections.singletonList(sourceReplica.getStr("shard"))).assignNrtReplicas(numNrtReplicas).assignTlogReplicas(numTlogReplicas).assignPullReplicas(numPullReplicas).onNodes(this.ccc.getSolrCloudManager().getClusterStateProvider().getLiveNodes().stream().filter(node -> !node.equals(source)).collect(Collectors.toList())).build();
                assignRequests.add(assignRequest);
            }
            Iterator assignStrategy = Assign.createAssignStrategy(this.ccc.getCoreContainer());
            replicaPositions = assignStrategy.assign(this.ccc.getSolrCloudManager(), assignRequests);
        }
        int replicaPositionIdx = 0;
        for (ZkNodeProps sourceReplica : sourceReplicas) {
            NamedList nl;
            ZkNodeProps addedReplica;
            String targetNode;
            String sourceCollection = sourceReplica.getStr("collection");
            if (log.isInfoEnabled()) {
                log.info("Going to create replica for collection={} shard={} on node={}", new Object[]{sourceCollection, sourceReplica.getStr("shard"), target});
            }
            if (replicaPositions != null) {
                targetNode = replicaPositions.get((int)replicaPositionIdx).node;
                ++replicaPositionIdx;
            } else {
                targetNode = target;
            }
            ZkNodeProps msg = sourceReplica.plus("parallel", (Object)String.valueOf(parallel)).plus("node", (Object)targetNode);
            if (async != null) {
                msg.getProperties().put("async", async);
            }
            if ((addedReplica = new AddReplicaCmd(this.ccc).addReplica(clusterState, msg, (NamedList<Object>)(nl = new NamedList()), () -> {
                countDownLatch.countDown();
                if (nl.get("failure") != null) {
                    String errorString = String.format(Locale.ROOT, "Failed to create replica for collection=%s shard=%s on node=%s", sourceCollection, sourceReplica.getStr("shard"), target);
                    log.warn(errorString);
                    NamedList namedList = results;
                    synchronized (namedList) {
                        results.add("failure", (Object)errorString);
                        anyOneFailed.set(true);
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug("Successfully created replica for collection={} shard={} on node={}", new Object[]{sourceCollection, sourceReplica.getStr("shard"), target});
                }
            }).get(0)) == null) continue;
            createdReplicas.add(addedReplica);
            if (sourceReplica.getBool("leader", false) || waitForFinalState) {
                String shardName = sourceReplica.getStr("shard");
                String replicaName = sourceReplica.getStr("replica");
                String collectionName = sourceCollection;
                String key = collectionName + "_" + replicaName;
                Object watcher = waitForFinalState ? new ActiveReplicaWatcher(collectionName, null, Collections.singletonList(addedReplica.getStr("core")), replicasToRecover) : new LeaderRecoveryWatcher(collectionName, shardName, replicaName, addedReplica.getStr("core"), replicasToRecover);
                watchers.put((CallSite)((Object)key), (ActiveReplicaWatcher)watcher);
                log.debug("--- adding {}, {}", (Object)key, watcher);
                zkStateReader.registerCollectionStateWatcher(collectionName, (CollectionStateWatcher)watcher);
                continue;
            }
            log.debug("--- not waiting for {}", (Object)addedReplica);
        }
        log.debug("Waiting for replicas to be added");
        if (!countDownLatch.await((long)timeout, TimeUnit.SECONDS)) {
            log.info("Timed out waiting for replicas to be added");
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for replicas to be added");
        }
        log.debug("Waiting for {} leader replicas to recover", (Object)numLeaders);
        if (!replicasToRecover.await((long)timeout, TimeUnit.SECONDS)) {
            if (log.isInfoEnabled()) {
                log.info("Timed out waiting for {} leader replicas to recover", (Object)replicasToRecover.getCount());
            }
            anyOneFailed.set(true);
        } else {
            log.debug("Finished waiting for leader replicas to recover");
        }
        for (Map.Entry e : watchers.entrySet()) {
            zkStateReader.removeCollectionStateWatcher((String)e.getKey(), (CollectionStateWatcher)e.getValue());
        }
        if (anyOneFailed.get()) {
            log.info("Failed to create some replicas. Cleaning up all replicas on target node");
            SolrCloseableLatch cleanupLatch = new SolrCloseableLatch(createdReplicas.size(), this.ccc.getCloseableToLatchOn());
            for (ZkNodeProps createdReplica : createdReplicas) {
                NamedList deleteResult = new NamedList();
                try {
                    new DeleteReplicaCmd(this.ccc).deleteReplica(zkStateReader.getClusterState(), createdReplica.plus("parallel", (Object)"true"), (NamedList<Object>)deleteResult, () -> {
                        cleanupLatch.countDown();
                        if (deleteResult.get("failure") != null) {
                            NamedList namedList = results;
                            synchronized (namedList) {
                                results.add("failure", (Object)("Could not cleanup, because of : " + deleteResult.get("failure")));
                            }
                        }
                    });
                }
                catch (KeeperException e) {
                    cleanupLatch.countDown();
                    log.warn("Error deleting replica ", (Throwable)e);
                }
                catch (Exception e) {
                    log.warn("Error deleting replica ", (Throwable)e);
                    cleanupLatch.countDown();
                    throw e;
                }
            }
            cleanupLatch.await(5L, TimeUnit.MINUTES);
            return;
        }
        DeleteNodeCmd.cleanupReplicas(results, state, sourceReplicas, this.ccc, source, async);
        results.add("success", (Object)("REPLACENODE action completed successfully from  : " + source + " to : " + target));
    }

    static List<ZkNodeProps> getReplicasOfNode(String source, ClusterState state) {
        ArrayList<ZkNodeProps> sourceReplicas = new ArrayList<ZkNodeProps>();
        for (Map.Entry e : state.getCollectionsMap().entrySet()) {
            for (Slice slice : ((DocCollection)e.getValue()).getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!source.equals(replica.getNodeName())) continue;
                    ZkNodeProps props = new ZkNodeProps(new String[]{"collection", (String)e.getKey(), "shard", slice.getName(), "core", replica.getCoreName(), "replica", replica.getName(), "type", replica.getType().name(), "leader", String.valueOf(replica.equals((Object)slice.getLeader())), "node", source});
                    sourceReplicas.add(props);
                }
            }
        }
        return sourceReplicas;
    }
}

