/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.View;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.export.RegisteredReader;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.TemporalMetricStorage;
import io.opentelemetry.sdk.metrics.internal.view.AttributesProcessor;
import io.opentelemetry.sdk.metrics.internal.view.RegisteredView;
import io.opentelemetry.sdk.resources.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

final class AsynchronousMetricStorage<T, U extends ExemplarData>
implements MetricStorage {
    private static final Logger logger = Logger.getLogger(AsynchronousMetricStorage.class.getName());
    private final ThrottlingLogger throttlingLogger = new ThrottlingLogger(logger);
    private final RegisteredReader registeredReader;
    private final MetricDescriptor metricDescriptor;
    private final TemporalMetricStorage<T, U> metricStorage;
    private final Aggregator<T, U> aggregator;
    private final AttributesProcessor attributesProcessor;
    private Map<Attributes, T> accumulations = new HashMap<Attributes, T>();

    private AsynchronousMetricStorage(RegisteredReader registeredReader, MetricDescriptor metricDescriptor, Aggregator<T, U> aggregator, AttributesProcessor attributesProcessor) {
        this.registeredReader = registeredReader;
        this.metricDescriptor = metricDescriptor;
        AggregationTemporality aggregationTemporality = registeredReader.getReader().getAggregationTemporality(metricDescriptor.getSourceInstrument().getType());
        this.metricStorage = new TemporalMetricStorage<T, U>(aggregator, false, registeredReader, aggregationTemporality, metricDescriptor);
        this.aggregator = aggregator;
        this.attributesProcessor = attributesProcessor;
    }

    static <T, U extends ExemplarData> AsynchronousMetricStorage<T, U> create(RegisteredReader registeredReader, RegisteredView registeredView, InstrumentDescriptor instrumentDescriptor) {
        View view = registeredView.getView();
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, registeredView.getViewSourceInfo(), instrumentDescriptor);
        Aggregator aggregator = ((AggregatorFactory)((Object)view.getAggregation())).createAggregator(instrumentDescriptor, ExemplarFilter.neverSample());
        return new AsynchronousMetricStorage(registeredReader, metricDescriptor, aggregator, registeredView.getViewAttributesProcessor());
    }

    void recordLong(long value, Attributes attributes) {
        T accumulation = this.aggregator.accumulateLongMeasurement(value, attributes, Context.current());
        if (accumulation != null) {
            this.recordAccumulation(accumulation, attributes);
        }
    }

    void recordDouble(double value, Attributes attributes) {
        T accumulation = this.aggregator.accumulateDoubleMeasurement(value, attributes, Context.current());
        if (accumulation != null) {
            this.recordAccumulation(accumulation, attributes);
        }
    }

    private void recordAccumulation(T accumulation, Attributes attributes) {
        Attributes processedAttributes = this.attributesProcessor.process(attributes, Context.current());
        if (this.accumulations.size() >= 2000) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
            return;
        }
        if (this.accumulations.containsKey(attributes)) {
            this.throttlingLogger.log(Level.WARNING, "Instrument " + this.metricDescriptor.getSourceInstrument().getName() + " has recorded multiple values for the same attributes.");
            return;
        }
        this.accumulations.put(processedAttributes, accumulation);
    }

    @Override
    public MetricDescriptor getMetricDescriptor() {
        return this.metricDescriptor;
    }

    @Override
    public RegisteredReader getRegisteredReader() {
        return this.registeredReader;
    }

    @Override
    public MetricData collectAndReset(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, long startEpochNanos, long epochNanos) {
        Map<Attributes, T> currentAccumulations = this.accumulations;
        this.accumulations = new HashMap<Attributes, T>();
        return this.metricStorage.buildMetricFor(resource, instrumentationScopeInfo, currentAccumulations, startEpochNanos, epochNanos);
    }

    @Override
    public boolean isEmpty() {
        return this.aggregator == Aggregator.drop();
    }
}

