/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.linq4j.tree;

import java.lang.reflect.Type;
import java.util.Objects;
import org.apache.calcite.linq4j.tree.Evaluator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.ExpressionType;
import org.apache.calcite.linq4j.tree.ExpressionWriter;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.linq4j.tree.Shuttle;
import org.apache.calcite.linq4j.tree.Visitor;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BinaryExpression
extends Expression {
    public final Expression expression0;
    public final Expression expression1;
    private final @Nullable Primitive primitive;

    BinaryExpression(ExpressionType nodeType, Type type, Expression expression0, Expression expression1) {
        super(nodeType, type);
        assert (expression0 != null) : "expression0 should not be null";
        assert (expression1 != null) : "expression1 should not be null";
        this.expression0 = expression0;
        this.expression1 = expression1;
        this.primitive = Primitive.of(expression0.getType());
    }

    @Override
    public Expression accept(Shuttle visitor) {
        visitor = visitor.preVisit(this);
        Expression expression0 = this.expression0.accept(visitor);
        Expression expression1 = this.expression1.accept(visitor);
        return visitor.visit(this, expression0, expression1);
    }

    @Override
    public <R> R accept(Visitor<R> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        switch (this.nodeType) {
            case AndAlso: {
                return BinaryExpression.evaluateBoolean(evaluator, this.expression0) && BinaryExpression.evaluateBoolean(evaluator, this.expression1);
            }
            case Add: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) + BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) + BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) + BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return Float.valueOf(BinaryExpression.evaluateFloat(this.expression0, evaluator) + BinaryExpression.evaluateFloat(this.expression1, evaluator));
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) + BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) + BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Divide: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) / BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) / BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) / BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return Float.valueOf(BinaryExpression.evaluateFloat(this.expression0, evaluator) / BinaryExpression.evaluateFloat(this.expression1, evaluator));
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) / BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) / BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Equal: {
                return Objects.equals(this.expression0.evaluate(evaluator), this.expression1.evaluate(evaluator));
            }
            case GreaterThan: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) > BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) > BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) > BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return BinaryExpression.evaluateFloat(this.expression0, evaluator) > BinaryExpression.evaluateFloat(this.expression1, evaluator);
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) > BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) > BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case GreaterThanOrEqual: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) >= BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) >= BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) >= BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return BinaryExpression.evaluateFloat(this.expression0, evaluator) >= BinaryExpression.evaluateFloat(this.expression1, evaluator);
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) >= BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) >= BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThan: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) < BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) < BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) < BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return BinaryExpression.evaluateFloat(this.expression0, evaluator) < BinaryExpression.evaluateFloat(this.expression1, evaluator);
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) < BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) < BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case LessThanOrEqual: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) <= BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) <= BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) <= BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return BinaryExpression.evaluateFloat(this.expression0, evaluator) <= BinaryExpression.evaluateFloat(this.expression1, evaluator);
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) <= BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) <= BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case Multiply: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) * BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) * BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) * BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return Float.valueOf(BinaryExpression.evaluateFloat(this.expression0, evaluator) * BinaryExpression.evaluateFloat(this.expression1, evaluator));
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) * BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) * BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
            case NotEqual: {
                return !Objects.equals(this.expression0.evaluate(evaluator), this.expression1.evaluate(evaluator));
            }
            case OrElse: {
                return BinaryExpression.evaluateBoolean(evaluator, this.expression0) || BinaryExpression.evaluateBoolean(evaluator, this.expression1);
            }
            case Subtract: {
                if (this.primitive == null) {
                    throw this.cannotEvaluate();
                }
                switch (this.primitive) {
                    case INT: {
                        return BinaryExpression.evaluateInt(this.expression0, evaluator) - BinaryExpression.evaluateInt(this.expression1, evaluator);
                    }
                    case SHORT: {
                        return BinaryExpression.evaluateShort(this.expression0, evaluator) - BinaryExpression.evaluateShort(this.expression1, evaluator);
                    }
                    case BYTE: {
                        return BinaryExpression.evaluateByte(this.expression0, evaluator) - BinaryExpression.evaluateByte(this.expression1, evaluator);
                    }
                    case FLOAT: {
                        return Float.valueOf(BinaryExpression.evaluateFloat(this.expression0, evaluator) - BinaryExpression.evaluateFloat(this.expression1, evaluator));
                    }
                    case DOUBLE: {
                        return BinaryExpression.evaluateDouble(this.expression0, evaluator) - BinaryExpression.evaluateDouble(this.expression1, evaluator);
                    }
                    case LONG: {
                        return BinaryExpression.evaluateLong(this.expression0, evaluator) - BinaryExpression.evaluateLong(this.expression1, evaluator);
                    }
                }
                throw this.cannotEvaluate();
            }
        }
        throw this.cannotEvaluate();
    }

    @Override
    void accept(ExpressionWriter writer, int lprec, int rprec) {
        if (writer.requireParentheses(this, lprec, rprec)) {
            return;
        }
        this.expression0.accept(writer, lprec, this.nodeType.lprec);
        writer.append(this.nodeType.op);
        this.expression1.accept(writer, this.nodeType.rprec, rprec);
    }

    private RuntimeException cannotEvaluate() {
        return new RuntimeException("cannot evaluate " + this + ", nodeType=" + (Object)((Object)this.nodeType) + ", primitive=" + (Object)((Object)this.primitive));
    }

    private static boolean evaluateBoolean(Evaluator evaluator, Expression expression) {
        return (Boolean)Objects.requireNonNull(expression.evaluate(evaluator), () -> "boolean expected, got null while evaluating " + expression);
    }

    private static Number evaluateNumber(Expression expression, Evaluator evaluator) {
        return (Number)Objects.requireNonNull(expression.evaluate(evaluator), () -> "number expected, got null while evaluating " + expression);
    }

    private static int evaluateInt(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).intValue();
    }

    private static short evaluateShort(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).shortValue();
    }

    private static long evaluateLong(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).longValue();
    }

    private static byte evaluateByte(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).byteValue();
    }

    private static float evaluateFloat(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).floatValue();
    }

    private static double evaluateDouble(Expression expression, Evaluator evaluator) {
        return BinaryExpression.evaluateNumber(expression, evaluator).doubleValue();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryExpression that = (BinaryExpression)o;
        if (!this.expression0.equals(that.expression0)) {
            return false;
        }
        if (!this.expression1.equals(that.expression1)) {
            return false;
        }
        return this.primitive == that.primitive;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.type, this.expression0, this.expression1, this.primitive});
    }
}

