/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.opennlp;

import java.io.IOException;
import java.text.BreakIterator;
import opennlp.tools.util.Span;
import org.apache.lucene.analysis.opennlp.OpenNLPSentenceBreakIterator;
import org.apache.lucene.analysis.opennlp.tools.NLPSentenceDetectorOp;
import org.apache.lucene.analysis.opennlp.tools.NLPTokenizerOp;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.FlagsAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.SegmentingTokenizerBase;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IgnoreRandomChains;

@IgnoreRandomChains(reason="LUCENE-10352: add argument providers for this one")
public final class OpenNLPTokenizer
extends SegmentingTokenizerBase {
    public static int EOS_FLAG_BIT = 1;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final FlagsAttribute flagsAtt = (FlagsAttribute)this.addAttribute(FlagsAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private Span[] termSpans = null;
    private int termNum = 0;
    private int sentenceStart = 0;
    private NLPTokenizerOp tokenizerOp = null;

    public OpenNLPTokenizer(AttributeFactory factory, NLPSentenceDetectorOp sentenceOp, NLPTokenizerOp tokenizerOp) throws IOException {
        super(factory, (BreakIterator)new OpenNLPSentenceBreakIterator(sentenceOp));
        if (sentenceOp == null || tokenizerOp == null) {
            throw new IllegalArgumentException("OpenNLPTokenizer: both a Sentence Detector and a Tokenizer are required");
        }
        this.tokenizerOp = tokenizerOp;
    }

    public void close() throws IOException {
        super.close();
        this.termSpans = null;
        this.sentenceStart = 0;
        this.termNum = 0;
    }

    protected void setNextSentence(int sentenceStart, int sentenceEnd) {
        this.sentenceStart = sentenceStart;
        String sentenceText = new String(this.buffer, sentenceStart, sentenceEnd - sentenceStart);
        this.termSpans = this.tokenizerOp.getTerms(sentenceText);
        this.termNum = 0;
    }

    protected boolean incrementWord() {
        if (this.termSpans == null || this.termNum == this.termSpans.length) {
            return false;
        }
        this.clearAttributes();
        Span term = this.termSpans[this.termNum];
        this.termAtt.copyBuffer(this.buffer, this.sentenceStart + term.getStart(), term.length());
        this.offsetAtt.setOffset(this.correctOffset(this.offset + this.sentenceStart + term.getStart()), this.correctOffset(this.offset + this.sentenceStart + term.getEnd()));
        if (this.termNum == this.termSpans.length - 1) {
            this.flagsAtt.setFlags(this.flagsAtt.getFlags() | EOS_FLAG_BIT);
        }
        ++this.termNum;
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.termSpans = null;
        this.sentenceStart = 0;
        this.termNum = 0;
    }
}

