/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice.type;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Constructor;
import javax.inject.Provider;
import org.apache.ibatis.type.TypeException;
import org.apache.ibatis.type.TypeHandler;

public final class TypeHandlerProvider<TH extends TypeHandler<? extends T>, T>
implements Provider<TH> {
    private final TypeLiteral<TH> typeHandlerTypeLiteral;
    private final Class<T> handledType;
    @Inject
    private Injector injector;

    public TypeHandlerProvider(Class<TH> typeHandlerType, Class<T> handledType) {
        this.typeHandlerTypeLiteral = TypeLiteral.get(typeHandlerType);
        this.handledType = handledType;
    }

    public TypeHandlerProvider(TypeLiteral<TH> typeHandlerType, Class<T> handledType) {
        this.typeHandlerTypeLiteral = typeHandlerType;
        this.handledType = handledType;
    }

    TypeHandlerProvider(Injector injector, Class<TH> typeHandlerType, Class<T> handledType) {
        this(typeHandlerType, handledType);
        this.injector = injector;
    }

    TypeHandlerProvider(Injector injector, TypeLiteral<TH> typeHandlerType, Class<T> handledType) {
        this(typeHandlerType, handledType);
        this.injector = injector;
    }

    @Override
    public TH get() {
        TypeHandler instance = null;
        if (this.handledType != null) {
            try {
                Constructor<TH> c = this.typeHandlerTypeLiteral.getRawType().getConstructor(Class.class);
                instance = (TypeHandler)c.newInstance(this.handledType);
                this.injector.injectMembers(instance);
            }
            catch (NoSuchMethodException c) {
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + this.typeHandlerTypeLiteral.getType(), e);
            }
        }
        if (instance == null) {
            try {
                instance = (TypeHandler)this.typeHandlerTypeLiteral.getRawType().newInstance();
                this.injector.injectMembers(instance);
            }
            catch (Exception e) {
                throw new TypeException("Failed invoking constructor for handler " + this.typeHandlerTypeLiteral.getType(), e);
            }
        }
        return (TH)instance;
    }

    public int hashCode() {
        return Objects.hashCode(this.typeHandlerTypeLiteral, this.handledType);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        TypeHandlerProvider other = (TypeHandlerProvider)obj;
        return Objects.equal(this.typeHandlerTypeLiteral, other.typeHandlerTypeLiteral) && Objects.equal(this.handledType, other.handledType);
    }
}

