/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.user;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.auth.jdbc.user.RemoteAuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticatedUser;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;

public class ModeledAuthenticatedUser
extends RemoteAuthenticatedUser {
    private final ModeledUser user;
    private final AuthenticationProvider modelAuthenticationProvider;
    private final Set<String> preferredConnections = Collections.newSetFromMap(new ConcurrentHashMap());

    public ModeledAuthenticatedUser(AuthenticatedUser authenticatedUser, AuthenticationProvider modelAuthenticationProvider, ModeledUser user) {
        super(authenticatedUser.getAuthenticationProvider(), authenticatedUser.getCredentials(), authenticatedUser.getEffectiveUserGroups());
        this.modelAuthenticationProvider = modelAuthenticationProvider;
        this.user = user;
    }

    public ModeledAuthenticatedUser(AuthenticationProvider authenticationProvider, ModeledUser user, Credentials credentials) {
        super(authenticationProvider, credentials, user.getEffectiveUserGroups());
        this.modelAuthenticationProvider = authenticationProvider;
        this.user = user;
    }

    public ModeledUser getUser() {
        return this.user;
    }

    public AuthenticationProvider getModelAuthenticationProvider() {
        return this.modelAuthenticationProvider;
    }

    public boolean isPreferredConnection(String identifier) {
        return this.preferredConnections.contains(identifier);
    }

    public void preferConnection(String identifier) {
        this.preferredConnections.add(identifier);
    }

    public String getIdentifier() {
        return this.user.getIdentifier();
    }

    public void setIdentifier(String identifier) {
        this.user.setIdentifier(identifier);
    }

    @Override
    public Set<String> getEffectiveUserGroups() {
        return Sets.union(this.user.getEffectiveUserGroups(), super.getEffectiveUserGroups());
    }

    public boolean isPrivileged() throws GuacamoleException {
        return this.getUser().isPrivileged();
    }
}

