/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.permission.PermissionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.auth.jdbc.user.ModeledUser;
import org.apache.guacamole.net.auth.permission.ObjectPermission;
import org.apache.guacamole.net.auth.permission.ObjectPermissionSet;
import org.apache.guacamole.net.auth.permission.Permission;
import org.apache.guacamole.net.auth.permission.PermissionSet;

public abstract class AbstractPermissionService<PermissionSetType extends PermissionSet<PermissionType>, PermissionType extends Permission>
implements PermissionService<PermissionSetType, PermissionType> {
    protected ObjectPermissionSet getRelevantPermissionSet(ModeledUser user, ModeledPermissions<? extends EntityModel> targetEntity) throws GuacamoleException {
        if (targetEntity.isUser()) {
            return user.getUserPermissions();
        }
        if (targetEntity.isUserGroup()) {
            return user.getUserGroupPermissions();
        }
        throw new UnsupportedOperationException("Unexpected entity type.");
    }

    protected boolean canReadPermissions(ModeledAuthenticatedUser user, ModeledPermissions<? extends EntityModel> targetEntity) throws GuacamoleException {
        if (targetEntity.isUser(user.getUser().getIdentifier())) {
            return true;
        }
        if (user.isPrivileged()) {
            return true;
        }
        ObjectPermissionSet permissionSet = this.getRelevantPermissionSet(user.getUser(), targetEntity);
        return permissionSet.hasPermission(ObjectPermission.Type.READ, targetEntity.getIdentifier());
    }
}

