/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.guice;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.session.SqlSessionFactoryBuilder;
import org.apache.ibatis.type.TypeHandler;
import org.mybatis.guice.AbstractMyBatisModule;
import org.mybatis.guice.Preconditions;

public abstract class XMLMyBatisModule
extends AbstractMyBatisModule {
    private static final String DEFAULT_CONFIG_RESOURCE = "mybatis-config.xml";
    private static final String DEFAULT_ENVIRONMENT_ID = null;
    private String classPathResource = "mybatis-config.xml";
    private String environmentId = DEFAULT_ENVIRONMENT_ID;
    private Properties properties = new Properties();

    protected final void setClassPathResource(String classPathResource) {
        Preconditions.checkArgument(classPathResource != null, "Parameter 'classPathResource' must be not null");
        this.classPathResource = classPathResource;
    }

    protected final void setEnvironmentId(String environmentId) {
        this.environmentId = environmentId;
    }

    protected final void addProperties(Properties properties) {
        if (properties != null) {
            this.properties.putAll((Map<?, ?>)properties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final void internalConfigure() {
        this.initialize();
        Reader reader = null;
        try {
            reader = Resources.getResourceAsReader(this.getResourceClassLoader(), this.classPathResource);
            SqlSessionFactory sessionFactory = new SqlSessionFactoryBuilder().build(reader, this.environmentId, this.properties);
            this.bind(SqlSessionFactory.class).toInstance(sessionFactory);
            Configuration configuration = sessionFactory.getConfiguration();
            Collection<Class<?>> mapperClasses = configuration.getMapperRegistry().getMappers();
            for (Class<?> clazz : mapperClasses) {
                this.bindMapper(clazz);
            }
            Collection<TypeHandler<?>> allTypeHandlers = configuration.getTypeHandlerRegistry().getTypeHandlers();
            for (TypeHandler<?> typeHandler : allTypeHandlers) {
                this.requestInjection(typeHandler);
            }
            List<Interceptor> list = configuration.getInterceptors();
            for (Interceptor interceptor : list) {
                this.requestInjection(interceptor);
            }
            this.requestInjection(configuration.getObjectFactory());
            this.requestInjection(configuration.getObjectWrapperFactory());
        }
        catch (Exception e) {
            this.addError("Impossible to read classpath resource '%s', see nested exceptions: %s", this.classPathResource, e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

