/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.permission;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.EntityModel;
import org.apache.guacamole.auth.jdbc.base.ModeledPermissions;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.permission.ObjectPermissionService;
import org.apache.guacamole.auth.jdbc.user.ModeledAuthenticatedUser;
import org.apache.guacamole.net.auth.permission.ObjectPermission;

public abstract class ObjectPermissionSet
extends RestrictedObject
implements org.apache.guacamole.net.auth.permission.ObjectPermissionSet {
    private ModeledPermissions<? extends EntityModel> entity;
    private Set<String> effectiveGroups;

    public void init(ModeledAuthenticatedUser currentUser, ModeledPermissions<? extends EntityModel> entity, Set<String> effectiveGroups) {
        super.init(currentUser);
        this.entity = entity;
        this.effectiveGroups = effectiveGroups;
    }

    protected abstract ObjectPermissionService getObjectPermissionService();

    public Set<ObjectPermission> getPermissions() throws GuacamoleException {
        return this.getObjectPermissionService().retrievePermissions(this.getCurrentUser(), this.entity, this.effectiveGroups);
    }

    public boolean hasPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        return this.getObjectPermissionService().hasPermission(this.getCurrentUser(), this.entity, permission, identifier, this.effectiveGroups);
    }

    public void addPermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        this.addPermissions(Collections.singleton(new ObjectPermission(permission, identifier)));
    }

    public void removePermission(ObjectPermission.Type permission, String identifier) throws GuacamoleException {
        this.removePermissions(Collections.singleton(new ObjectPermission(permission, identifier)));
    }

    public Collection<String> getAccessibleObjects(Collection<ObjectPermission.Type> permissions, Collection<String> identifiers) throws GuacamoleException {
        return this.getObjectPermissionService().retrieveAccessibleIdentifiers(this.getCurrentUser(), this.entity, permissions, identifiers, this.effectiveGroups);
    }

    public void addPermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        this.getObjectPermissionService().createPermissions(this.getCurrentUser(), this.entity, permissions);
    }

    public void removePermissions(Set<ObjectPermission> permissions) throws GuacamoleException {
        this.getObjectPermissionService().deletePermissions(this.getCurrentUser(), this.entity, permissions);
    }
}

