/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.jdbc.connection;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.jdbc.base.RestrictedObject;
import org.apache.guacamole.auth.jdbc.connection.ConnectionService;
import org.apache.guacamole.auth.jdbc.connection.ModeledConnection;
import org.apache.guacamole.net.auth.Connection;
import org.apache.guacamole.net.auth.Directory;
import org.mybatis.guice.transactional.Transactional;

public class ConnectionDirectory
extends RestrictedObject
implements Directory<Connection> {
    @Inject
    private ConnectionService connectionService;

    public Connection get(String identifier) throws GuacamoleException {
        return (Connection)this.connectionService.retrieveObject(this.getCurrentUser(), identifier);
    }

    @Transactional
    public Collection<Connection> getAll(Collection<String> identifiers) throws GuacamoleException {
        Collection objects = this.connectionService.retrieveObjects(this.getCurrentUser(), identifiers);
        return Collections.unmodifiableCollection(objects);
    }

    @Transactional
    public Set<String> getIdentifiers() throws GuacamoleException {
        return this.connectionService.getIdentifiers(this.getCurrentUser());
    }

    @Transactional
    public void add(Connection object) throws GuacamoleException {
        this.connectionService.createObject(this.getCurrentUser(), object);
    }

    @Transactional
    public void update(Connection object) throws GuacamoleException {
        ModeledConnection connection = (ModeledConnection)object;
        this.connectionService.updateObject(this.getCurrentUser(), connection);
    }

    @Transactional
    public void remove(String identifier) throws GuacamoleException {
        this.connectionService.deleteObject(this.getCurrentUser(), identifier);
    }
}

