/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.queue;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.microsoft.azure.storage.core.EncryptionData;
import com.microsoft.azure.storage.core.JsonUtilities;
import com.microsoft.azure.storage.core.Utility;
import java.io.IOException;
import java.io.StringWriter;

class CloudQueueEncryptedMessage {
    private String encryptedMessageContents;
    private EncryptionData encryptionData;

    CloudQueueEncryptedMessage() {
    }

    public String getEncryptedMessageContents() {
        return this.encryptedMessageContents;
    }

    public EncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    public void setEncryptedMessageContents(String encryptedMessageContents) {
        this.encryptedMessageContents = encryptedMessageContents;
    }

    public void setEncryptionData(EncryptionData encryptionData) {
        this.encryptionData = encryptionData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialize() throws IOException {
        StringWriter strWriter = new StringWriter();
        try (JsonGenerator generator = Utility.getJsonGenerator(strWriter);){
            generator.writeStartObject();
            generator.writeStringField("EncryptedMessageContents", this.getEncryptedMessageContents());
            generator.writeObjectFieldStart("EncryptionData");
            this.getEncryptionData().serialize(generator);
            generator.writeEndObject();
            generator.writeEndObject();
        }
        return strWriter.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloudQueueEncryptedMessage deserialize(String inputMessage) throws JsonProcessingException, IOException {
        CloudQueueEncryptedMessage message = new CloudQueueEncryptedMessage();
        try (JsonParser parser = Utility.getJsonParser(inputMessage);){
            if (!parser.hasCurrentToken()) {
                parser.nextToken();
            }
            JsonUtilities.assertIsStartObjectJsonToken(parser);
            parser.nextToken();
            while (parser.getCurrentToken() != JsonToken.END_OBJECT) {
                String name = parser.getCurrentName();
                parser.nextToken();
                if (name.equals("EncryptedMessageContents")) {
                    message.setEncryptedMessageContents(parser.getValueAsString());
                } else if (name.equals("EncryptionData")) {
                    message.setEncryptionData(EncryptionData.deserialize(parser));
                }
                parser.nextToken();
            }
            JsonUtilities.assertIsEndObjectJsonToken(parser);
        }
        return message;
    }
}

