/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.Frame;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;

public class MethodBlockBody
extends ContextAwareBlockBody {
    private final CacheEntry entry;
    private final ArgumentDescriptor[] argsDesc;
    private final IRubyObject receiver;
    private final RubyModule originModule;
    private final String originName;
    private final String file;
    private final int line;

    public MethodBlockBody(StaticScope staticScope, Signature signature, CacheEntry entry, ArgumentDescriptor[] argsDesc, IRubyObject receiver2, RubyModule originModule, String originName, String file2, int line) {
        super(staticScope, signature);
        this.entry = entry;
        this.argsDesc = argsDesc;
        this.receiver = receiver2;
        this.originModule = originModule;
        this.originName = originName;
        this.file = file2;
        this.line = line;
    }

    public static Block createMethodBlock(MethodBlockBody body) {
        DynamicMethod method2 = body.entry.method;
        RubyModule module = method2.getImplementationClass();
        Frame frame = new Frame();
        frame.setKlazz(module);
        frame.setName(method2.getName());
        frame.setSelf(body.receiver);
        frame.setVisibility(method2.getVisibility());
        Binding binding2 = new Binding(frame, body.getStaticScope().getDummyScope(), method2.getName(), body.getFile(), body.getLine());
        return new Block(body, binding2);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2) {
        args2 = this.prepareArgumentsForCall(context, args2, block.type);
        return this.entry.method.call(context, this.receiver, this.entry.sourceModule, this.originName, args2);
    }

    @Override
    public IRubyObject call(ThreadContext context, Block block, IRubyObject[] args2, Block blockArg) {
        args2 = this.prepareArgumentsForCall(context, args2, block.type);
        return this.entry.method.call(context, this.receiver, this.entry.sourceModule, this.originName, args2, blockArg);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject value2) {
        IRubyObject[] realArgs = Helpers.restructureBlockArgs(context, value2, this.getSignature(), block.type, false);
        return this.entry.method.call(context, this.receiver, this.entry.sourceModule, this.originName, realArgs, Block.NULL_BLOCK);
    }

    @Override
    protected IRubyObject doYield(ThreadContext context, Block block, IRubyObject[] args2, IRubyObject self2) {
        return this.entry.method.call(context, this.receiver, this.entry.sourceModule, this.originName, args2, Block.NULL_BLOCK);
    }

    @Override
    public String getFile() {
        return this.file;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public ArgumentDescriptor[] getArgumentDescriptors() {
        return this.argsDesc;
    }
}

