/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.crypto;

import generic.jar.ResourceFile;
import ghidra.file.crypto.CryptoKeyFactory;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;

public final class CryptoKeyFileTemplateWriter {
    private String fileName;
    private PrintWriter writer;

    public CryptoKeyFileTemplateWriter(String fileName) {
        this.fileName = fileName;
    }

    public boolean exists() {
        ResourceFile xmlFile = new ResourceFile(CryptoKeyFactory.getCryptoDirectory(), this.fileName + ".xml");
        return xmlFile.exists();
    }

    public void open() throws IOException {
        File xmlFile = new ResourceFile(CryptoKeyFactory.getCryptoDirectory(), this.fileName + ".xml").getFile(false);
        this.writer = new PrintWriter(xmlFile);
        this.writer.println("<FIRMWARE NAME=\"" + this.fileName + "\">");
    }

    public void close() throws IOException {
        this.writer.println("</FIRMWARE>");
        this.writer.close();
    }

    public void write(String entryName) throws IOException {
        this.writer.println("    <FILE PATH=\"" + entryName + "\">");
        this.writer.println("        <KEY></KEY>");
        this.writer.println("        <IV></IV>");
        this.writer.println("    </FILE>");
    }
}

