/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.Stroke;
import java.util.Objects;

public class PaintableShape {
    protected Shape shape;
    protected Color color = new Color(255, 200, 0, 127);
    protected Stroke stroke;
    protected double tx;
    protected double ty;
    protected boolean shapeFinished = false;

    protected PaintableShape(double tx, double ty) {
        this.tx = tx;
        this.ty = ty;
    }

    public PaintableShape(Shape s) {
        this.shape = Objects.requireNonNull(s);
    }

    public PaintableShape(Shape s, Color c) {
        this.shape = Objects.requireNonNull(s);
        this.color = Objects.requireNonNull(c);
    }

    public PaintableShape(Shape s, Color c, Stroke stroke) {
        this.shape = Objects.requireNonNull(s);
        this.color = Objects.requireNonNull(c);
        this.stroke = Objects.requireNonNull(stroke);
    }

    public double getTx() {
        return this.tx;
    }

    public double getTy() {
        return this.ty;
    }

    public Shape getShape() {
        return this.shape;
    }

    public Color getColor() {
        return this.color;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void shapeFinished() {
        this.shapeFinished = true;
    }

    public boolean isShapeFinished() {
        return this.shapeFinished;
    }

    public void paint(Graphics2D g) {
        g.setColor(this.color);
        if (this.stroke != null) {
            g.setStroke(this.stroke);
        }
        g.fill(this.shape);
    }
}

