/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.viewer.event.mouse;

import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractGraphMousePlugin;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.GraphViewerUtils;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.event.mouse.VisualGraphMousePlugin;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Point2D;

public class VisualGraphTranslatingGraphMousePlugin<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphMousePlugin
implements MouseListener,
MouseMotionListener,
VisualGraphMousePlugin<V, E> {
    private boolean panning;
    private boolean isHandlingEvent;

    public VisualGraphTranslatingGraphMousePlugin() {
        this(16);
    }

    public VisualGraphTranslatingGraphMousePlugin(int modifiers) {
        super(modifiers);
        this.cursor = Cursor.getPredefinedCursor(13);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean accepted;
        GraphViewer viewer = this.getGraphViewer(e);
        boolean bl = accepted = this.checkModifiers(e) && this.isInDraggingArea(e);
        if (!accepted) {
            return;
        }
        this.down = e.getPoint();
        viewer.setCursor(this.cursor);
        this.isHandlingEvent = true;
        e.consume();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        boolean wasHandlingEvent = this.isHandlingEvent;
        this.isHandlingEvent = false;
        this.down = null;
        this.installCursor(Cursor.getPredefinedCursor(0), e);
        if (wasHandlingEvent && this.panning) {
            e.consume();
        }
        this.panning = false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        GraphViewer viewer = this.getGraphViewer(e);
        boolean accepted = this.checkModifiers(e);
        if (!accepted) {
            return;
        }
        if (!this.isHandlingEvent) {
            return;
        }
        this.panning = true;
        RenderContext context = viewer.getRenderContext();
        MultiLayerTransformer multiLayerTransformer = context.getMultiLayerTransformer();
        MutableTransformer layoutTransformer = multiLayerTransformer.getTransformer(Layer.LAYOUT);
        viewer.setCursor(this.cursor);
        Point2D downPoint = multiLayerTransformer.inverseTransform((Point2D)this.down);
        Point2D p = multiLayerTransformer.inverseTransform((Point2D)e.getPoint());
        float dx = (float)(p.getX() - downPoint.getX());
        float dy = (float)(p.getY() - downPoint.getY());
        layoutTransformer.translate((double)dx, (double)dy);
        this.down.x = e.getX();
        this.down.y = e.getY();
        e.consume();
        viewer.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isHandlingEvent) {
            return;
        }
        if (!this.isInDraggingArea(e)) {
            return;
        }
        if (!this.checkModifiersForCursor(e)) {
            return;
        }
        this.installCursor(this.cursor, e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.installCursor(Cursor.getPredefinedCursor(0), e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (!this.checkModifiersForCursor(e)) {
            return;
        }
        if (this.isHandlingEvent) {
            e.consume();
        }
        if (this.isInDraggingArea(e)) {
            this.installCursor(this.cursor, e);
            e.consume();
        }
    }

    private boolean checkModifiersForCursor(MouseEvent e) {
        return e.getModifiers() == 0;
    }

    private boolean isInDraggingArea(MouseEvent e) {
        Point p;
        GraphViewer viewer = this.getGraphViewer(e);
        if (GraphViewerUtils.getVertexFromPointInViewSpace(viewer, p = e.getPoint()) != null) {
            return false;
        }
        return GraphViewerUtils.getEdgeFromPointInViewSpace(viewer, p) == null;
    }

    private void installCursor(Cursor newCursor, MouseEvent e) {
        VisualizationViewer viewer = this.getViewer(e);
        viewer.setCursor(newCursor);
    }
}

