/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.hfsplus;

import java.io.PrintStream;
import org.catacombae.csjc.DynamicStruct;
import org.catacombae.csjc.StructElements;
import org.catacombae.csjc.structelements.Dictionary;
import org.catacombae.hfsexplorer.FastUnicodeCompare;
import org.catacombae.hfsexplorer.Util;
import org.catacombae.hfsexplorer.types.hfsplus.BTKey;
import org.catacombae.hfsexplorer.types.hfsplus.HFSCatalogNodeID;
import org.catacombae.hfsexplorer.types.hfsplus.HFSUniStr255;

public class HFSPlusCatalogKey
extends BTKey
implements DynamicStruct,
StructElements {
    private static final int MAX_STRUCTSIZE = 518;
    private final byte[] keyLength = new byte[2];
    private final HFSCatalogNodeID parentID;
    private final HFSUniStr255 nodeName;

    public HFSPlusCatalogKey(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.keyLength, 0, 2);
        this.parentID = new HFSCatalogNodeID(data, offset + 2);
        this.nodeName = new HFSUniStr255(data, offset + 6);
    }

    public HFSPlusCatalogKey(HFSCatalogNodeID parentID, HFSUniStr255 nodeName) {
        this.parentID = parentID;
        this.nodeName = nodeName;
        System.arraycopy(Util.toByteArrayBE((short)((short)(4 + nodeName.length()))), 0, this.keyLength, 0, 2);
    }

    public HFSPlusCatalogKey(int parentIDInt, String nodeNameString) {
        this.parentID = new HFSCatalogNodeID(parentIDInt);
        this.nodeName = new HFSUniStr255(nodeNameString);
        System.arraycopy(Util.toByteArrayBE((short)((short)(4 + this.nodeName.length()))), 0, this.keyLength, 0, 2);
    }

    public short getKeyLength() {
        return Util.readShortBE((byte[])this.keyLength);
    }

    public HFSCatalogNodeID getParentID() {
        return this.parentID;
    }

    public HFSUniStr255 getNodeName() {
        return this.nodeName;
    }

    public byte[] getBytes() {
        byte[] result = new byte[this.length()];
        System.arraycopy(this.keyLength, 0, result, 0, 2);
        System.arraycopy(Util.toByteArrayBE((int)this.parentID.toInt()), 0, result, 2, 4);
        System.arraycopy(this.nodeName.getBytes(), 0, result, 6, this.nodeName.length());
        return result;
    }

    public int compareTo(BTKey btk) {
        if (btk instanceof HFSPlusCatalogKey) {
            HFSPlusCatalogKey catKey = (HFSPlusCatalogKey)btk;
            if (Util.unsign((int)this.getParentID().toInt()) == Util.unsign((int)catKey.getParentID().toInt())) {
                return FastUnicodeCompare.compare(this.nodeName.getUnicode(), catKey.getNodeName().getUnicode());
            }
            if (Util.unsign((int)this.getParentID().toInt()) < Util.unsign((int)catKey.getParentID().toInt())) {
                return -1;
            }
            return 1;
        }
        return super.compareTo(btk);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " keyLength: " + Util.unsign((short)this.getKeyLength()));
        ps.println(prefix + " parentID: ");
        this.getParentID().print(ps, prefix + "  ");
        ps.println(prefix + " nodeName: ");
        this.getNodeName().print(ps, prefix + "  ");
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "HFSPlusCatalogKey:");
        this.printFields(ps, prefix);
    }

    public int length() {
        return this.occupiedSize();
    }

    public int occupiedSize() {
        return 2 + Util.unsign((short)this.getKeyLength());
    }

    public int maxSize() {
        return 518;
    }

    public Dictionary getStructElements() {
        StructElements.DictionaryBuilder db = new StructElements.DictionaryBuilder(HFSPlusCatalogKey.class.getSimpleName());
        db.addUIntBE("keyLength", this.keyLength);
        db.add("parentID", this.parentID.getStructElements());
        db.add("nodeName", this.nodeName.getStructElements());
        return db.getResult();
    }
}

