/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler;

import ghidra.GhidraOptions;
import ghidra.app.decompiler.DecompInterface;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.DecompilerLanguage;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.awt.Color;
import java.awt.Font;

public class DecompileOptions {
    private static final String PREDICATE_OPTIONSTRING = "Analysis.Simplify predication";
    private static final String PREDICATE_OPTIONDESCRIPTION = "If set, multiple conditionally executed instructions depending on one predicate will be combined into a single if/else statement";
    private static final boolean PREDICATE_OPTIONDEFAULT = true;
    private boolean predicate = true;
    private static final String READONLY_OPTIONSTRING = "Analysis.Respect readonly flags";
    private static final String READONLY_OPTIONDESCRIPTION = "If set, this option causes the decompiler to treat any values in memory marked read-only as constant values.";
    private static final boolean READONLY_OPTIONDEFAULT = true;
    private boolean readOnly = true;
    private static final String ELIMINATE_UNREACHABLE_OPTIONSTRING = "Analysis.Eliminate unreachable code";
    private static final String ELIMINATE_UNREACHABLE_OPTIONDESCRIPTION = "If set, branches and code that can never be executed are eliminated as dead code";
    private static final boolean ELIMINATE_UNREACHABLE_OPTIONDEFAULT = true;
    private boolean eliminateUnreachable = true;
    private static final String SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING = "Analysis.Simplify extended integer operations";
    private static final String SIMPLIFY_DOUBLEPRECISION_OPTIONDESCRIPTION = "If set, integer operations which are split into high and low pieces are collapsed into a single logical operation";
    private static final boolean SIMPLIFY_DOUBLEPRECISION_OPTIONDEFAULT = true;
    private boolean simplifyDoublePrecision = true;
    private static final String IGNOREUNIMPL_OPTIONSTRING = "Analysis.Ignore unimplemented instructions";
    private static final String IGNOREUNIMPL_OPTIONDESCRIPTION = "If set, instructions which do not have a p-code translation implemented are treated as if they do nothing (like a NOP)";
    private static final boolean IGNOREUNIMPL_OPTIONDEFAULT = false;
    private boolean ignoreunimpl = false;
    private static final String INFERCONSTPTR_OPTIONSTRING = "Analysis.Infer constant pointers";
    private static final String INFERCONSTPTR_OPTIONDESCRIPTION = "If set, constants which are not being explicitly used as pointers, but which can be interpreted as a legitimate address, will still be treated as having a pointer datatype";
    private static final boolean INFERCONSTPTR_OPTIONDEFAULT = true;
    private boolean inferconstptr = true;
    private static final String NULLTOKEN_OPTIONSTRING = "Display.Print 'NULL' for null pointers";
    private static final String NULLTOKEN_OPTIONDESCRIPTION = "If set, any zero valued pointer (null pointer) will be printed using the token 'NULL'. Otherwise, a cast of the number '0' is printed.";
    private static final boolean NULLTOKEN_OPTIONDEFAULT = false;
    private boolean nullToken = false;
    private static final String INPLACEOP_OPTIONSTRING = "Analysis.Use inplace assignment operators";
    private static final String INPLACEOP_OPTIONDESCRIPTION = "If set the inplace assignment operators will be used for appropriate expressions. '+='   '*='   '&='   '<<=' etc.";
    private static final boolean INPLACEOP_OPTIONDEFAULT = false;
    private boolean inplaceTokens = false;
    private static final String CONVENTION_OPTIONSTRING = "Display.Print calling convention name";
    private static final String CONVENTION_OPTIONDESCRIPTION = "If set, the names of callling conventions (which differ from the default) will be printed as part of the function prototype.";
    private static final boolean CONVENTION_OPTIONDEFAULT = true;
    private boolean conventionPrint = true;
    private static final String NOCAST_OPTIONSTRING = "Display.Disable printing of type casts";
    private static final String NOCAST_OPTIONDESCRIPTION = "If set, any C style type cast recovered by the decompiler will not be displayed. The resulting C syntax may not parse correctly.";
    private static final boolean NOCAST_OPTIONDEFAULT = false;
    private boolean noCastPrint = false;
    private static final String MAXWIDTH_OPTIONSTRING = "Display.Maximum characters in a code line";
    private static final String MAXWIDTH_OPTIONDESCRIPTION = "Maximum number of characters allowed per line before before line breaks are forced.";
    private static final int MAXWIDTH_OPTIONDEFAULT = 100;
    private int maxwidth = 100;
    private static final String INDENTWIDTH_OPTIONSTRING = "Display.Number of characters per indent level";
    private static final String INDENTWIDTH_OPTIONDESCRIPTION = "Number of characters indented for each level of control-flow or scope nesting";
    private static final int INDENTWIDTH_OPTIONDEFAULT = 2;
    private int indentwidth = 2;
    private static final String COMMENTINDENT_OPTIONSTRING = "Display.Comment line indent level";
    private static final String COMMENTINDENT_OPTIONDESCRIPTION = "Number of characters each line of comments is indented";
    private static final int COMMENTINDENT_OPTIONDEFAULT = 20;
    private int commentindent = 20;
    private static final String COMMENTSTYLE_OPTIONSTRING = "Display.Comment style";
    private static final String COMMENTSTYLE_OPTIONDESCRIPTION = "Choice between either the C style comments /* */ or C++ style // ";
    public static final int SUGGESTED_DECOMPILE_TIMEOUT_SECS = 30;
    public static final int SUGGESTED_MAX_PAYLOAD_BYTES = 50;
    private static final CommentStyleEnum COMMENTSTYLE_OPTIONDEFAULT = CommentStyleEnum.CStyle;
    private CommentStyleEnum commentStyle;
    private static final String COMMENTPRE_OPTIONSTRING = "Display.Display PRE comments";
    private static final String COMMENTPRE_OPTIONDESCRIPTION = "If set, disassembly pre-instruction (PRE) comments are displayed in the decompiler C output";
    private static final boolean COMMENTPRE_OPTIONDEFAULT = true;
    private boolean commentPREInclude = true;
    private static final String COMMENTPLATE_OPTIONSTRING = "Display.Display PLATE comments";
    private static final String COMMENTPLATE_OPTIONDESCRIPTION = "If set, disassembly plate comments are displayed in the decompiler C output";
    private static final boolean COMMENTPLATE_OPTIONDEFAULT = false;
    private boolean commentPLATEInclude = false;
    private static final String COMMENTPOST_OPTIONSTRING = "Display.Display POST comments";
    private static final String COMMENTPOST_OPTIONDESCRIPTION = "If set, disassembly post-instruction (POST) comments are displayed in the decompiler C output";
    private static final boolean COMMENTPOST_OPTIONDEFAULT = false;
    private boolean commentPOSTInclude = false;
    private static final String COMMENTEOL_OPTIONSTRING = "Display.Display EOL comments";
    private static final String COMMENTEOL_OPTIONDESCRIPTION = "If set, disassembly end-of-line (EOL) comments are displayed in the decompiler C output";
    private static final boolean COMMENTEOL_OPTIONDEFAULT = false;
    private boolean commentEOLInclude = false;
    private static final String COMMENTWARN_OPTIONSTRING = "Display.Display Warning comments";
    private static final String COMMENTWARN_OPTIONDESCRIPTION = "If set, warnings generated by the decompiler embedded in the displayed code as comments";
    private static final boolean COMMENTWARN_OPTIONDEFAULT = true;
    private boolean commentWARNInclude = true;
    private static final String COMMENTHEAD_OPTIONSTRING = "Display.Display Header comment";
    private static final String COMMENTHEAD_OPTIONDESCRIPTION = "If set, the entry point plate comment is displayed as a function header comment.";
    private static final boolean COMMENTHEAD_OPTIONDEFAULT = true;
    private boolean commentHeadInclude = true;
    private static final String INTEGERFORMAT_OPTIONSTRING = "Display.Integer format";
    private static final String INTEGERFORMAT_OPTIONDESCRIPTION = "Choose how to display integers: as hexadecimal, decimal, or best fit";
    private static final IntegerFormatEnum INTEGERFORMAT_OPTIONDEFAULT = IntegerFormatEnum.BestFit;
    private IntegerFormatEnum integerFormat;
    private static final Color HIGHLIGHT_MIDDLE_MOUSE_DEF = new Color(255, 255, 0, 128);
    private Color middleMouseHighlightColor;
    private int middleMouseHighlightButton = 2;
    private static final String HIGHLIGHT_CURRENT_VARIABLE_MSG = "Display.Color for Current Variable Highlight";
    private static final Color HIGHLIGHT_CURRENT_VARIABLE_DEF = new Color(255, 255, 0, 128);
    private Color currentVariableHighlightColor;
    private static final String HIGHLIGHT_KEYWORD_MSG = "Display.Color for Keywords";
    private static final Color HIGHLIGHT_KEYWORD_DEF = Color.decode("0x0001E6");
    private Color keywordColor;
    private static final String HIGHLIGHT_FUNCTION_MSG = "Display.Color for Function names";
    private static final Color HIGHLIGHT_FUNCTION_DEF = Color.decode("0x0000FF");
    private Color functionColor;
    private static final String HIGHLIGHT_COMMENT_MSG = "Display.Color for Comments";
    private static final Color HIGHLIGHT_COMMENT_DEF = Color.decode("0x9600FF");
    private Color commentColor;
    private static final String HIGHLIGHT_VARIABLE_MSG = "Display.Color for Variables";
    private static final Color HIGHLIGHT_VARIABLE_DEF = Color.decode("0x999900");
    private Color variableColor;
    private static final String HIGHLIGHT_CONST_MSG = "Display.Color for Constants";
    private static final Color HIGHLIGHT_CONST_DEF = Color.decode("0x008E00");
    private Color constantColor;
    private static final String HIGHLIGHT_TYPE_MSG = "Display.Color for Types";
    private static final Color HIGHLIGHT_TYPE_DEF = Color.decode("0x0033CC");
    private Color typeColor;
    private static final String HIGHLIGHT_PARAMETER_MSG = "Display.Color for Parameters";
    private static final Color HIGHLIGHT_PARAMETER_DEF = Color.decode("0x9B009B");
    private Color parameterColor;
    private static final String HIGHLIGHT_GLOBAL_MSG = "Display.Color for Globals";
    private static final Color HIGHLIGHT_GLOBAL_DEF = Color.decode("0x009999");
    private Color globalColor;
    private static final String HIGHLIGHT_DEFAULT_MSG = "Display.Color Default";
    private static final Color HIGHLIGHT_DEFAULT_DEF = Color.BLACK;
    private Color defaultColor;
    private static final String CODE_VIEWER_BACKGROUND_COLOR_MSG = "Display.Background Color";
    private static final Color CODE_VIEWER_BACKGROUND_COLOR = Color.WHITE;
    private Color codeViewerBackgroundColor;
    private static final String SEARCH_HIGHLIGHT_MSG = "Display.Color for Highlighting Find Matches";
    private static final Color SEARCH_HIGHLIGHT_DEF = new Color(100, 100, 255);
    private Color defaultSearchHighlightColor = SEARCH_HIGHLIGHT_DEF;
    static final String FONT_MSG = "Display.Font";
    static final Font DEFAULT_FONT = new Font("Monospaced", 0, 12);
    private Font defaultFont;
    private static final String CACHED_RESULTS_SIZE_MSG = "Cache Size (Functions)";
    private static final int SUGGESTED_CACHED_RESULTS_SIZE = 10;
    private static final String CACHE_RESULTS_DESCRIPTION = "Number of Decompiled Functions to Cache in the Decompile Window";
    private static final String LINE_NUMBER_MSG = "Display.Display Line Numbers";
    private static final String NAMESPACE_MSG = "Display.Display Namespaces";
    private static final String DECOMPILE_TIMEOUT = "Decompiler Timeout (seconds)";
    private static final String PAYLOAD_LIMIT = "Decompiler Max-Payload (MBytes)";
    private static final Boolean LINE_NUMBER_DEF = Boolean.TRUE;
    private static final Boolean NAMESPACES_DEF = Boolean.FALSE;
    private boolean displayLineNumbers;
    private boolean displayNamespaces;
    private int decompileTimeoutSeconds = 30;
    private int payloadLimitMBytes = 50;
    private int cachedResultsSize = 10;
    private DecompilerLanguage displayLanguage;
    private String protoEvalModel = "default";

    public DecompileOptions() {
        this.commentStyle = COMMENTSTYLE_OPTIONDEFAULT;
        this.integerFormat = INTEGERFORMAT_OPTIONDEFAULT;
        this.keywordColor = HIGHLIGHT_KEYWORD_DEF;
        this.functionColor = HIGHLIGHT_FUNCTION_DEF;
        this.commentColor = HIGHLIGHT_COMMENT_DEF;
        this.variableColor = HIGHLIGHT_VARIABLE_DEF;
        this.constantColor = HIGHLIGHT_CONST_DEF;
        this.typeColor = HIGHLIGHT_TYPE_DEF;
        this.parameterColor = HIGHLIGHT_PARAMETER_DEF;
        this.globalColor = HIGHLIGHT_GLOBAL_DEF;
        this.defaultColor = HIGHLIGHT_DEFAULT_DEF;
        this.codeViewerBackgroundColor = CODE_VIEWER_BACKGROUND_COLOR;
        this.defaultFont = DEFAULT_FONT;
        this.displayLineNumbers = LINE_NUMBER_DEF;
        this.displayNamespaces = NAMESPACES_DEF;
        this.displayLanguage = BasicCompilerSpec.DECOMPILER_OUTPUT_DEF;
    }

    public void grabFromToolAndProgram(Plugin ownerPlugin, ToolOptions opt, Program program) {
        this.grabFromProgram(program);
        if (!opt.isRegistered(PREDICATE_OPTIONSTRING)) {
            return;
        }
        this.predicate = opt.getBoolean(PREDICATE_OPTIONSTRING, true);
        this.readOnly = opt.getBoolean(READONLY_OPTIONSTRING, true);
        this.eliminateUnreachable = opt.getBoolean(ELIMINATE_UNREACHABLE_OPTIONSTRING, true);
        this.simplifyDoublePrecision = opt.getBoolean(SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING, true);
        this.ignoreunimpl = opt.getBoolean(IGNOREUNIMPL_OPTIONSTRING, false);
        this.inferconstptr = opt.getBoolean(INFERCONSTPTR_OPTIONSTRING, true);
        this.nullToken = opt.getBoolean(NULLTOKEN_OPTIONSTRING, false);
        this.inplaceTokens = opt.getBoolean(INPLACEOP_OPTIONSTRING, false);
        this.conventionPrint = opt.getBoolean(CONVENTION_OPTIONSTRING, true);
        this.noCastPrint = opt.getBoolean(NOCAST_OPTIONSTRING, false);
        this.maxwidth = opt.getInt(MAXWIDTH_OPTIONSTRING, 100);
        this.indentwidth = opt.getInt(INDENTWIDTH_OPTIONSTRING, 2);
        this.commentindent = opt.getInt(COMMENTINDENT_OPTIONSTRING, 20);
        this.commentStyle = (CommentStyleEnum)opt.getEnum(COMMENTSTYLE_OPTIONSTRING, (Enum)COMMENTSTYLE_OPTIONDEFAULT);
        this.commentEOLInclude = opt.getBoolean(COMMENTEOL_OPTIONSTRING, false);
        this.commentPREInclude = opt.getBoolean(COMMENTPRE_OPTIONSTRING, true);
        this.commentPOSTInclude = opt.getBoolean(COMMENTPOST_OPTIONSTRING, false);
        this.commentPLATEInclude = opt.getBoolean(COMMENTPLATE_OPTIONSTRING, false);
        this.commentWARNInclude = opt.getBoolean(COMMENTWARN_OPTIONSTRING, true);
        this.commentHeadInclude = opt.getBoolean(COMMENTHEAD_OPTIONSTRING, true);
        this.integerFormat = (IntegerFormatEnum)opt.getEnum(INTEGERFORMAT_OPTIONSTRING, (Enum)INTEGERFORMAT_OPTIONDEFAULT);
        this.keywordColor = opt.getColor(HIGHLIGHT_KEYWORD_MSG, HIGHLIGHT_KEYWORD_DEF);
        this.typeColor = opt.getColor(HIGHLIGHT_TYPE_MSG, HIGHLIGHT_TYPE_DEF);
        this.functionColor = opt.getColor(HIGHLIGHT_FUNCTION_MSG, HIGHLIGHT_FUNCTION_DEF);
        this.commentColor = opt.getColor(HIGHLIGHT_COMMENT_MSG, HIGHLIGHT_COMMENT_DEF);
        this.variableColor = opt.getColor(HIGHLIGHT_VARIABLE_MSG, HIGHLIGHT_VARIABLE_DEF);
        this.constantColor = opt.getColor(HIGHLIGHT_CONST_MSG, HIGHLIGHT_CONST_DEF);
        this.parameterColor = opt.getColor(HIGHLIGHT_PARAMETER_MSG, HIGHLIGHT_PARAMETER_DEF);
        this.globalColor = opt.getColor(HIGHLIGHT_GLOBAL_MSG, HIGHLIGHT_GLOBAL_DEF);
        this.defaultColor = opt.getColor(HIGHLIGHT_DEFAULT_MSG, HIGHLIGHT_DEFAULT_DEF);
        this.codeViewerBackgroundColor = opt.getColor(CODE_VIEWER_BACKGROUND_COLOR_MSG, CODE_VIEWER_BACKGROUND_COLOR);
        this.currentVariableHighlightColor = opt.getColor(HIGHLIGHT_CURRENT_VARIABLE_MSG, HIGHLIGHT_CURRENT_VARIABLE_DEF);
        this.defaultFont = opt.getFont(FONT_MSG, DEFAULT_FONT);
        this.defaultFont = SystemUtilities.adjustForFontSizeOverride((Font)this.defaultFont);
        this.defaultSearchHighlightColor = opt.getColor(SEARCH_HIGHLIGHT_MSG, SEARCH_HIGHLIGHT_DEF);
        this.displayLineNumbers = opt.getBoolean(LINE_NUMBER_MSG, LINE_NUMBER_DEF.booleanValue());
        this.displayNamespaces = opt.getBoolean(NAMESPACE_MSG, NAMESPACES_DEF.booleanValue());
        this.decompileTimeoutSeconds = opt.getInt(DECOMPILE_TIMEOUT, 30);
        this.payloadLimitMBytes = opt.getInt(PAYLOAD_LIMIT, 50);
        this.cachedResultsSize = opt.getInt(CACHED_RESULTS_SIZE_MSG, 10);
        this.grabFromToolOptions(ownerPlugin);
    }

    private void grabFromToolOptions(Plugin ownerPlugin) {
        if (ownerPlugin == null) {
            return;
        }
        PluginTool tool = ownerPlugin.getTool();
        ToolOptions toolOptions = tool.getOptions("Listing Fields");
        this.middleMouseHighlightColor = toolOptions.getColor("Cursor Text Highlight.Highlight Color", HIGHLIGHT_MIDDLE_MOUSE_DEF);
        GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES mouseEvent = (GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES)toolOptions.getEnum("Cursor Text Highlight.Mouse Button To Activate", (Enum)GhidraOptions.CURSOR_MOUSE_BUTTON_NAMES.MIDDLE);
        this.middleMouseHighlightButton = mouseEvent.getMouseEventID();
    }

    public void grabFromProgram(Program program) {
        String modelname;
        this.displayLanguage = BasicCompilerSpec.DECOMPILER_OUTPUT_DEF;
        this.protoEvalModel = "default";
        if (program == null) {
            return;
        }
        CompilerSpec cspec = program.getCompilerSpec();
        PrototypeModel model = (PrototypeModel)cspec.getPrototypeEvaluationModel(program);
        if (model != null && (modelname = model.getName()) != null) {
            this.protoEvalModel = modelname;
        }
        this.displayLanguage = cspec.getDecompilerOutputLanguage(program);
    }

    public String getProtoEvalModel() {
        return this.protoEvalModel;
    }

    public void setProtoEvalModel(String protoEvalModel) {
        this.protoEvalModel = protoEvalModel;
    }

    public void registerOptions(Plugin ownerPlugin, ToolOptions opt, Program program, HelpLocation help) {
        opt.registerOption(PREDICATE_OPTIONSTRING, (Object)true, help, PREDICATE_OPTIONDESCRIPTION);
        opt.registerOption(READONLY_OPTIONSTRING, (Object)true, help, READONLY_OPTIONDESCRIPTION);
        opt.registerOption(ELIMINATE_UNREACHABLE_OPTIONSTRING, (Object)true, help, ELIMINATE_UNREACHABLE_OPTIONDESCRIPTION);
        opt.registerOption(SIMPLIFY_DOUBLEPRECISION_OPTIONSTRING, (Object)true, help, SIMPLIFY_DOUBLEPRECISION_OPTIONDESCRIPTION);
        opt.registerOption(IGNOREUNIMPL_OPTIONSTRING, (Object)false, help, IGNOREUNIMPL_OPTIONDESCRIPTION);
        opt.registerOption(INFERCONSTPTR_OPTIONSTRING, (Object)true, help, INFERCONSTPTR_OPTIONDESCRIPTION);
        opt.registerOption(NULLTOKEN_OPTIONSTRING, (Object)false, help, NULLTOKEN_OPTIONDESCRIPTION);
        opt.registerOption(INPLACEOP_OPTIONSTRING, (Object)false, help, INPLACEOP_OPTIONDESCRIPTION);
        opt.registerOption(CONVENTION_OPTIONSTRING, (Object)true, help, CONVENTION_OPTIONDESCRIPTION);
        opt.registerOption(NOCAST_OPTIONSTRING, (Object)false, help, NOCAST_OPTIONDESCRIPTION);
        opt.registerOption(MAXWIDTH_OPTIONSTRING, (Object)100, help, MAXWIDTH_OPTIONDESCRIPTION);
        opt.registerOption(INDENTWIDTH_OPTIONSTRING, (Object)2, help, INDENTWIDTH_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTINDENT_OPTIONSTRING, (Object)20, help, COMMENTINDENT_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTSTYLE_OPTIONSTRING, (Object)COMMENTSTYLE_OPTIONDEFAULT, help, COMMENTSTYLE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTEOL_OPTIONSTRING, (Object)false, help, COMMENTEOL_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPRE_OPTIONSTRING, (Object)true, help, COMMENTPRE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPOST_OPTIONSTRING, (Object)false, help, COMMENTPOST_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTPLATE_OPTIONSTRING, (Object)false, help, COMMENTPLATE_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTWARN_OPTIONSTRING, (Object)true, help, COMMENTWARN_OPTIONDESCRIPTION);
        opt.registerOption(COMMENTHEAD_OPTIONSTRING, (Object)true, help, COMMENTHEAD_OPTIONDESCRIPTION);
        opt.registerOption(INTEGERFORMAT_OPTIONSTRING, (Object)INTEGERFORMAT_OPTIONDEFAULT, help, INTEGERFORMAT_OPTIONDESCRIPTION);
        opt.registerOption(HIGHLIGHT_KEYWORD_MSG, (Object)HIGHLIGHT_KEYWORD_DEF, help, "Color used for highlighting keywords.");
        opt.registerOption(HIGHLIGHT_TYPE_MSG, (Object)HIGHLIGHT_TYPE_DEF, help, "Color used for highlighting types.");
        opt.registerOption(HIGHLIGHT_FUNCTION_MSG, (Object)HIGHLIGHT_FUNCTION_DEF, help, "Color used for highlighting function names.");
        opt.registerOption(HIGHLIGHT_COMMENT_MSG, (Object)HIGHLIGHT_COMMENT_DEF, help, "Color used for highlighting comments.");
        opt.registerOption(HIGHLIGHT_VARIABLE_MSG, (Object)HIGHLIGHT_VARIABLE_DEF, help, "Color used for highlighting variables.");
        opt.registerOption(HIGHLIGHT_CONST_MSG, (Object)HIGHLIGHT_CONST_DEF, help, "Color used for highlighting constants.");
        opt.registerOption(HIGHLIGHT_PARAMETER_MSG, (Object)HIGHLIGHT_PARAMETER_DEF, help, "Color used for highlighting parameters.");
        opt.registerOption(HIGHLIGHT_GLOBAL_MSG, (Object)HIGHLIGHT_GLOBAL_DEF, help, "Color used for highlighting global variables.");
        opt.registerOption(HIGHLIGHT_DEFAULT_MSG, (Object)HIGHLIGHT_DEFAULT_DEF, help, "The color used when a specific color is not specified.");
        opt.registerOption(CODE_VIEWER_BACKGROUND_COLOR_MSG, (Object)CODE_VIEWER_BACKGROUND_COLOR, help, "The background color of the decompiler window.");
        opt.registerOption(FONT_MSG, (Object)DEFAULT_FONT, help, "The font used to render text in the decompiler.");
        opt.registerOption(SEARCH_HIGHLIGHT_MSG, (Object)SEARCH_HIGHLIGHT_DEF, help, "The color used to highlight matches using the Find Dialog.");
        opt.registerOption(LINE_NUMBER_MSG, (Object)LINE_NUMBER_DEF, help, "Toggle for displaying line numbers in the decompiler.");
        opt.registerOption(NAMESPACE_MSG, (Object)NAMESPACES_DEF, help, "Toggle for dislaying namespaces for functions.");
        opt.registerOption(DECOMPILE_TIMEOUT, (Object)30, help, "The number of seconds to allow the decompiler to run before terminating the decompiler.\nCurrently this does not affect the UI, which will run indefinitely. This setting currently only affects background analysis that uses the decompiler.");
        opt.registerOption(PAYLOAD_LIMIT, (Object)50, help, "The maximum size of the decompiler result payload in MBYtes (Suggested value: 50).");
        opt.registerOption(HIGHLIGHT_CURRENT_VARIABLE_MSG, (Object)HIGHLIGHT_CURRENT_VARIABLE_DEF, help, "Current variable highlight");
        opt.registerOption(CACHED_RESULTS_SIZE_MSG, (Object)10, help, CACHE_RESULTS_DESCRIPTION);
        this.grabFromToolAndProgram(ownerPlugin, opt, program);
    }

    private static void appendOption(StringBuffer buf, String name, String p1, String p2, String p3) {
        buf.append(" <");
        buf.append(name);
        buf.append('>');
        if (p2.length() == 0 && p3.length() == 0) {
            buf.append(p1);
        } else {
            buf.append('\n');
            buf.append("  <param1>");
            buf.append(p1);
            buf.append("</param1>\n");
            buf.append("  <param2>");
            buf.append(p2);
            buf.append("</param2>\n");
            if (p3.length() != 0) {
                buf.append("  <param3>");
                buf.append(p3);
                buf.append("</param3>\n");
            }
        }
        buf.append("</");
        buf.append(name);
        buf.append(">\n");
    }

    public String getXML(DecompInterface iface) {
        StringBuffer buf = new StringBuffer();
        buf.append("<optionslist>\n");
        DecompileOptions.appendOption(buf, "currentaction", "conditionalexe", this.predicate ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "readonly", this.readOnly ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "currentaction", iface.getSimplificationStyle(), "unreachable", this.eliminateUnreachable ? "on" : "off");
        DecompileOptions.appendOption(buf, "currentaction", iface.getSimplificationStyle(), "doubleprecis", this.simplifyDoublePrecision ? "on" : "off");
        DecompileOptions.appendOption(buf, "ignoreunimplemented", this.ignoreunimpl ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "inferconstptr", this.inferconstptr ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "nullprinting", this.nullToken ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "inplaceops", this.inplaceTokens ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "conventionprinting", this.conventionPrint ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "nocastprinting", this.noCastPrint ? "on" : "off", "", "");
        DecompileOptions.appendOption(buf, "maxlinewidth", Integer.toString(this.maxwidth), "", "");
        DecompileOptions.appendOption(buf, "indentincrement", Integer.toString(this.indentwidth), "", "");
        DecompileOptions.appendOption(buf, "commentindent", Integer.toString(this.commentindent), "", "");
        String curstyle = CommentStyleEnum.CPPStyle.equals((Object)this.commentStyle) ? "cplusplus" : "c";
        DecompileOptions.appendOption(buf, "commentstyle", curstyle, "", "");
        DecompileOptions.appendOption(buf, "commentinstruction", "header", this.commentPLATEInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentinstruction", "user2", this.commentPREInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentinstruction", "user1", this.commentEOLInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentinstruction", "user3", this.commentPOSTInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentinstruction", "warning", this.commentWARNInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentheader", "header", this.commentHeadInclude ? "on" : "off", "");
        DecompileOptions.appendOption(buf, "commentheader", "warningheader", this.commentWARNInclude ? "on" : "off", "");
        String curformat = "best";
        if (IntegerFormatEnum.Hexadecimal.equals((Object)this.integerFormat)) {
            curformat = "hex";
        } else if (IntegerFormatEnum.Decimal.equals((Object)this.integerFormat)) {
            curformat = "dec";
        }
        DecompileOptions.appendOption(buf, "integerformat", curformat, "", "");
        DecompileOptions.appendOption(buf, "setlanguage", this.displayLanguage.toString(), "", "");
        DecompileOptions.appendOption(buf, "protoeval", this.protoEvalModel, "", "");
        buf.append("</optionslist>\n");
        return buf.toString();
    }

    public int getMaxWidth() {
        return this.maxwidth;
    }

    public Color getKeywordColor() {
        return this.keywordColor;
    }

    public Color getTypeColor() {
        return this.typeColor;
    }

    public Color getFunctionColor() {
        return this.functionColor;
    }

    public Color getCommentColor() {
        return this.commentColor;
    }

    public Color getConstantColor() {
        return this.constantColor;
    }

    public Color getVariableColor() {
        return this.variableColor;
    }

    public Color getParameterColor() {
        return this.parameterColor;
    }

    public Color getGlobalColor() {
        return this.globalColor;
    }

    public Color getDefaultColor() {
        return this.defaultColor;
    }

    public Color getCodeViewerBackgroundColor() {
        return this.codeViewerBackgroundColor;
    }

    public Color getCurrentVariableHighlightColor() {
        return this.currentVariableHighlightColor;
    }

    public Color getMiddleMouseHighlightColor() {
        return this.middleMouseHighlightColor;
    }

    public Color getSearchHighlightColor() {
        return this.defaultSearchHighlightColor;
    }

    public int getMiddleMouseHighlightButton() {
        return this.middleMouseHighlightButton;
    }

    public boolean isPRECommentIncluded() {
        return this.commentPREInclude;
    }

    public void setPRECommentIncluded(boolean commentPREInclude) {
        this.commentPREInclude = commentPREInclude;
    }

    public boolean isPLATECommentIncluded() {
        return this.commentPLATEInclude;
    }

    public void setPLATECommentIncluded(boolean commentPLATEInclude) {
        this.commentPLATEInclude = commentPLATEInclude;
    }

    public boolean isPOSTCommentIncluded() {
        return this.commentPOSTInclude;
    }

    public void setPOSTCommentIncluded(boolean commentPOSTInclude) {
        this.commentPOSTInclude = commentPOSTInclude;
    }

    public boolean isEOLCommentIncluded() {
        return this.commentEOLInclude;
    }

    public void setEOLCommentIncluded(boolean commentEOLInclude) {
        this.commentEOLInclude = commentEOLInclude;
    }

    public boolean isWARNCommentIncluded() {
        return this.commentWARNInclude;
    }

    public void setWARNCommentIncluded(boolean commentWARNInclude) {
        this.commentWARNInclude = commentWARNInclude;
    }

    public boolean isHeadCommentIncluded() {
        return this.commentHeadInclude;
    }

    public void setHeadCommentIncluded(boolean commentHeadInclude) {
        this.commentHeadInclude = commentHeadInclude;
    }

    public boolean isEliminateUnreachable() {
        return this.eliminateUnreachable;
    }

    public void setEliminateUnreachable(boolean eliminateUnreachable) {
        this.eliminateUnreachable = eliminateUnreachable;
    }

    public boolean isSimplifyDoublePrecision() {
        return this.simplifyDoublePrecision;
    }

    public void setSimplifyDoublePrecision(boolean simplifyDoublePrecision) {
        this.simplifyDoublePrecision = simplifyDoublePrecision;
    }

    public boolean isDisplayLineNumbers() {
        return this.displayLineNumbers;
    }

    public boolean isDisplayNamespaces() {
        return this.displayNamespaces;
    }

    public DecompilerLanguage getDisplayLanguage() {
        return this.displayLanguage;
    }

    public boolean isConventionPrint() {
        return this.conventionPrint;
    }

    public void setConventionPrint(boolean conventionPrint) {
        this.conventionPrint = conventionPrint;
    }

    public boolean isNoCastPrint() {
        return this.noCastPrint;
    }

    public void setNoCastPrint(boolean noCastPrint) {
        this.noCastPrint = noCastPrint;
    }

    public void setDisplayLanguage(DecompilerLanguage val) {
        this.displayLanguage = val;
    }

    public Font getDefaultFont() {
        return this.defaultFont;
    }

    public int getDefaultTimeout() {
        return this.decompileTimeoutSeconds;
    }

    public void setDefaultTimeout(int timeout) {
        this.decompileTimeoutSeconds = timeout;
    }

    public int getMaxPayloadMBytes() {
        return this.payloadLimitMBytes;
    }

    public void setMaxPayloadMBytes(int mbytes) {
        this.payloadLimitMBytes = mbytes;
    }

    public CommentStyleEnum getCommentStyle() {
        return this.commentStyle;
    }

    public void setCommentStyle(CommentStyleEnum commentStyle) {
        this.commentStyle = commentStyle;
    }

    public int getCacheSize() {
        return this.cachedResultsSize;
    }

    public static enum IntegerFormatEnum {
        Hexadecimal("Force Hexadecimal"),
        Decimal("Force Decimal"),
        BestFit("Best Fit");

        private String label;

        private IntegerFormatEnum(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum CommentStyleEnum {
        CStyle("/* C-style comments */"),
        CPPStyle("// C++-style comments");

        private String label;

        private CommentStyleEnum(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

