/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.table.field;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitFormat;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.exception.AssertException;
import java.util.ArrayList;
import java.util.List;

public class CodeUnitTableCellData
implements Comparable<CodeUnitTableCellData> {
    private final int MAX_LINE_LENGTH = 500;
    private Program program;
    private Address address;
    private CodeUnitFormat formatter;
    private int codeUnitOffset;
    private int codeUnitCount;
    private String displayString;
    private String htmlDisplayString;
    private boolean isOffcut;

    public CodeUnitTableCellData(ProgramLocation location, CodeUnitFormat codeUnitFormat, int codeUnitOffset, int codeUnitCount) {
        if (location == null) {
            throw new AssertException("ProgramLocation cannot be null");
        }
        this.program = location.getProgram();
        if (codeUnitFormat == null) {
            throw new AssertException("CodeUnitFormat cannot be null");
        }
        this.formatter = codeUnitFormat;
        this.codeUnitOffset = codeUnitOffset;
        this.codeUnitCount = codeUnitCount;
        this.address = location.getByteAddress();
    }

    public String toString() {
        return this.getDisplayString();
    }

    @Override
    public int compareTo(CodeUnitTableCellData data) {
        return this.getDisplayString().compareTo(data.getDisplayString());
    }

    public String getDisplayString() {
        if (this.displayString != null) {
            return this.displayString;
        }
        this.displayString = this.createDisplayString(false);
        return this.displayString;
    }

    public String getHTMLDisplayString() {
        if (this.htmlDisplayString == null) {
            this.htmlDisplayString = "<html><pre>" + this.createDisplayString(true) + "</pre></html>";
        }
        return this.htmlDisplayString;
    }

    public List<String> getDisplayStrings() {
        return this.getDisplayLines(false);
    }

    public boolean isOffcut() {
        return this.isOffcut;
    }

    private String getDataPath(Data data) {
        String path = data.getComponentPathName();
        int dotIndex = path.indexOf(".");
        if (dotIndex != -1) {
            path = path.substring(dotIndex + 1);
        }
        Data parent = data.getParent();
        DataType parentType = parent.getDataType();
        String separator = ".";
        if (parentType instanceof Array) {
            separator = "";
        }
        return " (" + parentType.getName() + separator + path + ")";
    }

    private CodeUnit getCodeUnitContaining(Address addr) {
        Listing listing = this.program.getListing();
        CodeUnit cu = listing.getCodeUnitAt(addr);
        if (cu == null && (cu = listing.getCodeUnitContaining(addr)) instanceof Data) {
            Data data = (Data)cu;
            return data.getPrimitiveAt((int)addr.subtract(data.getMinAddress()));
        }
        return cu;
    }

    private CodeUnit getCodeUnitBefore(CodeUnit cu) {
        if (cu != null) {
            try {
                return this.getCodeUnitContaining(cu.getMinAddress().subtractNoWrap(1L));
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return null;
    }

    private CodeUnit getCodeUnitAfter(CodeUnit cu) {
        if (cu != null) {
            try {
                return this.getCodeUnitContaining(cu.getMaxAddress().addNoWrap(1L));
            }
            catch (AddressOverflowException addressOverflowException) {
                // empty catch block
            }
        }
        return null;
    }

    private String createDisplayString(boolean htmlFriendly) {
        List<String> lines = this.getDisplayLines(htmlFriendly);
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < lines.size(); ++i) {
            String string = lines.get(i);
            buffy.append(string);
            if (i >= lines.size() - 1) continue;
            buffy.append("\n");
        }
        return buffy.toString();
    }

    private List<String> getDisplayLines(boolean htmlFriendly) {
        CodeUnit containingCodeUnit;
        ArrayList<String> lines = new ArrayList<String>();
        if (this.address.isExternalAddress()) {
            return lines;
        }
        int codeUnitStart = this.codeUnitOffset;
        int codeUnitEnd = codeUnitStart + this.codeUnitCount - 1;
        CodeUnit codeUnit = containingCodeUnit = this.getCodeUnitContaining(this.address);
        int codeUnitIndex = 0;
        int count = 0;
        if (codeUnitStart <= 0 && codeUnitEnd >= 0) {
            lines.add(this.createDisplayString(codeUnit, this.formatter, htmlFriendly));
            ++count;
        }
        while (count < this.codeUnitCount) {
            if (codeUnitIndex <= 0) {
                if (codeUnitIndex <= codeUnitStart) {
                    codeUnit = containingCodeUnit;
                    codeUnitIndex = 0;
                } else {
                    codeUnit = this.getCodeUnitBefore(codeUnit);
                    --codeUnitIndex;
                }
            }
            if (codeUnitIndex >= 0) {
                codeUnit = this.getCodeUnitAfter(codeUnit);
                ++codeUnitIndex;
            }
            if (codeUnitIndex < codeUnitStart || codeUnitIndex > codeUnitEnd) continue;
            String display = this.createDisplayString(codeUnit, this.formatter, htmlFriendly);
            if (codeUnitIndex < 0) {
                lines.add(0, display);
            } else {
                lines.add(display);
            }
            ++count;
        }
        return lines;
    }

    private String createDisplayString(CodeUnit cu, CodeUnitFormat cuFormat, boolean htmlFriendly) {
        String representation = null;
        if (cu != null) {
            representation = this.createCodeUnitRepresentation(cu, cuFormat);
        }
        if (representation == null || representation.length() == 0) {
            representation = "??";
        }
        if (htmlFriendly) {
            if (representation.length() > 500) {
                representation = representation.substring(0, 500);
            }
            representation = HTMLUtilities.friendlyEncodeHTML((String)representation);
        }
        return representation;
    }

    private String createCodeUnitRepresentation(CodeUnit cu, CodeUnitFormat cuFormat) {
        String path;
        if (!(cu instanceof Data)) {
            return cuFormat.getRepresentationString(cu);
        }
        Data data = (Data)cu;
        Object representation = cuFormat.getRepresentationString((CodeUnit)data);
        if (data.getParent() != null && !(path = this.getDataPath(data)).equals(representation)) {
            representation = (String)representation + path;
        }
        return representation;
    }
}

