/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.xml.DisplaySettingsHandler;
import ghidra.app.util.xml.DtParser;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.EnumDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.IntegerDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.PascalString255DataType;
import ghidra.program.model.data.PascalStringDataType;
import ghidra.program.model.data.PascalUnicodeDataType;
import ghidra.program.model.data.StringDataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TerminatedStringDataType;
import ghidra.program.model.data.TerminatedUnicodeDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.UnicodeDataType;
import ghidra.program.model.data.Union;
import ghidra.program.model.data.UnionDataType;
import ghidra.program.model.data.UnsignedInteger3DataType;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.TaskMonitorAdapter;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlTreeNode;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.xml.sax.SAXParseException;

public class DataTypesXmlMgr {
    private static final int DEFAULT_SIZE = 1;
    private static HashMap<String, DataType> foreignTypedefs = new HashMap();
    private DataTypeManager dataManager;
    private DtParser dtParser;
    private MessageLog log;
    private int defaultEnumSize = IntegerDataType.dataType.getLength();

    public DataTypesXmlMgr(DataTypeManager dataManager, MessageLog log) {
        this.dataManager = dataManager;
        this.log = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(XmlPullParser parser, TaskMonitor monitor) throws SAXParseException, CancelledException {
        ArrayList<XmlTreeNode> todo = new ArrayList<XmlTreeNode>();
        XmlElement element = parser.next();
        BuiltInDataTypeManager builtInMgr = BuiltInDataTypeManager.getDataTypeManager();
        try {
            boolean processed;
            this.dtParser = new DtParser(this.dataManager);
            while (true) {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                element = parser.peek();
                if (element.isEnd() && element.getName().equals("DATATYPES")) break;
                XmlTreeNode root = new XmlTreeNode(parser);
                if (this.process(root, true)) continue;
                todo.add(root);
            }
            parser.next();
            do {
                if (monitor.isCancelled()) {
                    throw new CancelledException();
                }
                processed = false;
                Iterator it = todo.iterator();
                while (it.hasNext()) {
                    XmlTreeNode node = (XmlTreeNode)it.next();
                    if (!this.process(node, false)) continue;
                    it.remove();
                    processed = true;
                }
            } while (processed);
        }
        finally {
            builtInMgr.close();
            this.dtParser = null;
        }
        Iterator it = todo.iterator();
        while (it.hasNext()) {
            if (monitor.isCancelled()) {
                throw new CancelledException();
            }
            this.logError((XmlTreeNode)it.next());
        }
    }

    private void logError(XmlTreeNode node) {
        XmlElement element = node.getStartElement();
        String tagName = element.getName();
        String name = element.getAttribute("NAME");
        if (name == null) {
            name = "";
        }
        this.logError(node, tagName + ": " + name);
    }

    private void logError(XmlTreeNode node, String parentName) {
        XmlElement element = node.getStartElement();
        String dataTypeName = element.getAttribute("DATATYPE");
        if (dataTypeName == null) {
            dataTypeName = element.getAttribute("DATATYPE_NAME");
        }
        this.log.appendMsg(element.getLineNumber(), "Couldn't create DataType: " + dataTypeName + " in " + parentName);
        Iterator it = node.getChildren();
        while (it.hasNext()) {
            this.logError((XmlTreeNode)it.next(), parentName);
        }
    }

    private boolean process(XmlTreeNode root, boolean firstPass) {
        XmlElement element = root.getStartElement();
        String name = element.getName();
        try {
            if (name.equals("STRUCTURE")) {
                return this.processStructure(root, firstPass);
            }
            if (name.equals("UNION")) {
                return this.processUnion(root, firstPass);
            }
            if (name.equals("FUNCTION_DEF")) {
                return this.processFunctionDef(root, firstPass);
            }
            if (name.equals("ENUM")) {
                return this.processEnum(root);
            }
            if (name.equals("TYPE_DEF")) {
                return this.processTypeDef(root, firstPass);
            }
            this.log.appendMsg("Unrecognized datatype tag: " + name);
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
        }
        return true;
    }

    private boolean processFunctionDef(XmlTreeNode root, boolean firstPass) {
        XmlTreeNode node;
        boolean processedAll = true;
        XmlElement element = root.getStartElement();
        String name = element.getAttribute("NAME");
        CategoryPath path = this.getCategoryPath(element);
        FunctionDefinitionDataType fd = null;
        if (firstPass) {
            fd = new FunctionDefinitionDataType(path, name);
            if (!name.equals((fd = (FunctionDefinition)this.dataManager.addDataType((DataType)fd, null)).getName())) {
                element.setAttribute("NAME", fd.getName());
            }
        } else {
            fd = (FunctionDefinition)this.dataManager.getDataType(path, name);
        }
        if ((node = root.getChild("RETURN_TYPE")) != null) {
            DataType returnType = this.findDataType(node.getStartElement());
            if (returnType != null) {
                fd.setReturnType(returnType);
                root.deleteChildNode(node);
            } else {
                processedAll = false;
            }
        }
        Iterator it = root.getChildren("PARAMETER");
        while (it.hasNext()) {
            node = (XmlTreeNode)it.next();
            String comment = this.getRegularComment(node);
            element = node.getStartElement();
            DataType dt = this.findDataType(element);
            if (dt != null) {
                int ordinal = XmlUtilities.parseInt((String)element.getAttribute("ORDINAL"));
                name = element.getAttribute("NAME");
                int size = dt.getLength();
                if (size == 0) {
                    return false;
                }
                if (size < 0) {
                    size = element.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)element.getAttribute("SIZE")) : 4;
                }
                fd.replaceArgument(ordinal, name, dt, comment, SourceType.USER_DEFINED);
                it.remove();
                continue;
            }
            processedAll = false;
        }
        return processedAll;
    }

    private boolean processEnum(XmlTreeNode root) {
        XmlElement element = root.getStartElement();
        String name = element.getAttribute("NAME");
        String comment = this.getRegularComment(root);
        CategoryPath cp = this.getCategoryPath(element);
        int size = XmlUtilities.parseInt((String)element.getAttribute("SIZE"), (int)this.defaultEnumSize);
        EnumDataType enuum = new EnumDataType(cp, name, size);
        Iterator it = root.getChildren("ENUM_ENTRY");
        while (it.hasNext()) {
            XmlTreeNode node = (XmlTreeNode)it.next();
            XmlElement childElement = node.getStartElement();
            String entryName = childElement.getAttribute("NAME");
            long entryValue = XmlUtilities.parseLong((String)childElement.getAttribute("VALUE"));
            enuum.add(entryName, entryValue);
        }
        enuum.setDescription(comment);
        this.dataManager.addDataType((DataType)enuum, null);
        return true;
    }

    private boolean processTypeDef(XmlTreeNode root, boolean firstPass) {
        int size;
        XmlElement element = root.getStartElement();
        String name = element.getAttribute("NAME");
        CategoryPath cp = this.getCategoryPath(element);
        DataType dt = this.findDataType(element);
        if (dt == null) {
            return false;
        }
        int dtSize = dt.getLength();
        int n = size = element.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)element.getAttribute("SIZE")) : -1;
        if (size != -1 && size != dtSize) {
            this.log.appendMsg("SIZE=" + element.getAttribute("SIZE") + " specified on type-def " + name + " does not agree with length of datatype " + dt.getDisplayName() + " (" + dtSize + ")");
        }
        TypedefDataType td = new TypedefDataType(cp, name, dt);
        try {
            td.setCategoryPath(cp);
        }
        catch (DuplicateNameException duplicateNameException) {
            // empty catch block
        }
        this.dataManager.addDataType((DataType)td, null);
        return true;
    }

    private boolean processStructure(XmlTreeNode root, boolean firstPass) {
        XmlElement element = root.getStartElement();
        String name = element.getAttribute("NAME");
        CategoryPath path = this.getCategoryPath(element);
        Structure struct = null;
        boolean isVariableLength = false;
        if (element.hasAttribute("VARIABLE_LENGTH")) {
            isVariableLength = XmlUtilities.parseBoolean((String)element.getAttribute("VARIABLE_LENGTH"));
        }
        if (firstPass) {
            int size = 1;
            if (element.hasAttribute("SIZE")) {
                size = XmlUtilities.parseInt((String)element.getAttribute("SIZE"));
            }
            String comment = this.getRegularComment(root);
            struct = new StructureDataType(path, name, size);
            if (comment != null) {
                struct.setDescription(comment);
            }
            if (!(struct = (Structure)this.dataManager.addDataType((DataType)struct, null)).getName().equals(name)) {
                element.setAttribute("NAME", struct.getName());
            }
        } else {
            struct = (Structure)this.dataManager.getDataType(path, name);
        }
        return this.processStructMembers(root, struct, firstPass, isVariableLength);
    }

    private boolean processUnion(XmlTreeNode root, boolean firstPass) {
        XmlElement element = root.getStartElement();
        String name = element.getAttribute("NAME");
        CategoryPath path = this.getCategoryPath(element);
        Union union = null;
        if (firstPass) {
            String comment = this.getRegularComment(root);
            union = new UnionDataType(path, name);
            if (comment != null) {
                union.setDescription(comment);
            }
            if (!(union = (Union)this.dataManager.addDataType((DataType)union, null)).getName().equals(name)) {
                element.setAttribute("NAME", union.getName());
            }
        } else {
            union = (Union)this.dataManager.getDataType(path, name);
        }
        return this.processUnionMembers(root, union, firstPass);
    }

    private String getRegularComment(XmlTreeNode root) {
        XmlTreeNode node = root.getChild("REGULAR_CMT");
        if (node != null) {
            return node.getEndElement().getText();
        }
        return null;
    }

    private boolean processStructMembers(XmlTreeNode root, Structure struct, boolean firstPass, boolean isVariableLength) {
        boolean processedAll = true;
        Iterator iter = root.getChildren("MEMBER");
        while (iter.hasNext()) {
            XmlTreeNode child = (XmlTreeNode)iter.next();
            XmlElement childElem = child.getStartElement();
            int offset = XmlUtilities.parseInt((String)childElem.getAttribute("OFFSET"));
            DataType memberDT = this.findDataType(childElem);
            if (memberDT != null) {
                int size;
                if (memberDT instanceof TerminatedStringDataType) {
                    memberDT = new StringDataType();
                } else if (memberDT instanceof TerminatedUnicodeDataType) {
                    memberDT = new UnicodeDataType();
                }
                if (memberDT.getLength() == 0) {
                    return false;
                }
                String memberName = childElem.getAttribute("NAME");
                String memberComment = this.getRegularComment(child);
                int dtSize = memberDT.getLength();
                int n = size = childElem.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)childElem.getAttribute("SIZE")) : -1;
                if (dtSize <= 0 && (dtSize = size) < 0) {
                    this.log.appendMsg("No SIZE specified for member at offset " + offset + " of structure " + struct.getDisplayName());
                    dtSize = 1;
                }
                DataTypeComponent member = null;
                member = isVariableLength && offset >= struct.getLength() ? struct.add(memberDT, dtSize, memberName, memberComment) : struct.replaceAtOffset(offset, memberDT, dtSize, memberName, memberComment);
                this.processSettings(child, member.getDefaultSettings());
                iter.remove();
                continue;
            }
            processedAll = false;
        }
        return processedAll;
    }

    private void processSettings(XmlTreeNode parent, Settings settings) {
        XmlTreeNode node = parent.getChild("DISPLAY_SETTINGS");
        if (node != null) {
            DisplaySettingsHandler.readSettings(node.getStartElement(), settings);
        }
    }

    private boolean processUnionMembers(XmlTreeNode root, Union union, boolean firstPass) {
        boolean processedAll = true;
        Iterator iter = root.getChildren("MEMBER");
        while (iter.hasNext()) {
            XmlTreeNode child = (XmlTreeNode)iter.next();
            XmlElement childElem = child.getStartElement();
            DataType memberDT = this.findDataType(childElem);
            if (memberDT != null) {
                int size;
                String memberName = childElem.getAttribute("NAME");
                String memberComment = this.getRegularComment(child);
                int dtSize = memberDT.getLength();
                int n = size = childElem.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)childElem.getAttribute("SIZE")) : -1;
                if (dtSize <= 0) {
                    dtSize = size;
                    if (dtSize < 0) {
                        this.log.appendMsg("No SIZE specified for member datatype " + memberDT.getDisplayName() + " of union " + union.getDisplayName());
                        dtSize = 1;
                    }
                } else if (size != -1 && size != dtSize) {
                    this.log.appendMsg("SIZE=" + childElem.getAttribute("SIZE") + " specified for member datatype " + memberDT.getDisplayName() + " of union " + union.getDisplayName() + " does not agree with length of datatype (" + dtSize + ")");
                }
                union.add(memberDT, dtSize, memberName, memberComment);
                iter.remove();
                continue;
            }
            processedAll = false;
        }
        return processedAll;
    }

    private CategoryPath getCategoryPath(XmlElement element) {
        String nameSpace = element.getAttribute("NAMESPACE");
        CategoryPath cp = nameSpace == null ? CategoryPath.ROOT : new CategoryPath(nameSpace);
        return cp;
    }

    private DataType findDataType(XmlElement element) {
        int size;
        CategoryPath cp;
        DataType dt;
        String dtName = element.getAttribute("DATATYPE");
        if (dtName == null) {
            dtName = element.getAttribute("DATATYPE_NAME");
        }
        if ((dt = this.dtParser.parseDataType(dtName, cp = new CategoryPath(element.getAttribute("DATATYPE_NAMESPACE")), size = element.hasAttribute("SIZE") ? XmlUtilities.parseInt((String)element.getAttribute("SIZE")) : -1)) == null && this.addForeignTypedefIfNeeded(dtName)) {
            dt = this.dtParser.parseDataType(dtName, cp, size);
        }
        return dt;
    }

    private boolean addForeignTypedefIfNeeded(String dtName) {
        DataType ourType;
        int ptrIndex = dtName.indexOf(42);
        int index = dtName.indexOf(91);
        String baseName = dtName.trim();
        if (index < 0 || index > ptrIndex) {
            index = ptrIndex;
        }
        if (index > 0) {
            baseName = dtName.substring(0, index).trim();
        }
        if ((ourType = foreignTypedefs.get(baseName)) != null && this.dataManager.getDataType("/" + baseName) == null) {
            TypedefDataType newTypedef = new TypedefDataType(baseName, ourType);
            this.dataManager.resolve((DataType)newTypedef, null);
            return true;
        }
        return false;
    }

    public void write(XmlWriter writer, TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Writing DATA TYPES ...");
        writer.startElement("DATATYPES");
        Iterator it = this.dataManager.getAllDataTypes();
        while (it.hasNext()) {
            this.writeDataType(writer, (DataType)it.next());
            if (!monitor.isCancelled()) continue;
            throw new CancelledException();
        }
        writer.endElement("DATATYPES");
    }

    private void writeDataType(XmlWriter writer, DataType dt) {
        if (dt instanceof Structure) {
            this.writeStructure(writer, (Structure)dt);
        } else if (dt instanceof Union) {
            this.writeUnion(writer, (Union)dt);
        } else if (dt instanceof TypeDef) {
            this.writeTypeDef(writer, (TypeDef)dt);
        } else if (dt instanceof FunctionDefinition) {
            this.writeFunctionDefinition(writer, (FunctionDefinition)dt);
        } else if (dt instanceof Enum) {
            this.writeEnum(writer, (Enum)dt);
        }
    }

    private void writeEnum(XmlWriter writer, Enum enuum) {
        String[] names;
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", enuum.getDisplayName());
        attrs.addAttribute("NAMESPACE", enuum.getCategoryPath().getPath());
        attrs.addAttribute("SIZE", enuum.getLength(), true);
        writer.startElement("ENUM", attrs);
        this.writeRegularComment(writer, enuum.getDescription());
        for (String name : names = enuum.getNames()) {
            attrs = new XmlAttributes();
            attrs.addAttribute("NAME", name);
            attrs.addAttribute("VALUE", enuum.getValue(name), true);
            writer.startElement("ENUM_ENTRY", attrs);
            writer.endElement("ENUM_ENTRY");
        }
        writer.endElement("ENUM");
    }

    private void writeFunctionDefinition(XmlWriter writer, FunctionDefinition func) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", func.getName());
        attrs.addAttribute("NAMESPACE", func.getCategoryPath().getPath());
        writer.startElement("FUNCTION_DEF", attrs);
        this.writeRegularComment(writer, func.getDescription());
        DataType rt = func.getReturnType();
        if (rt != null && rt != DataType.DEFAULT) {
            attrs = new XmlAttributes();
            attrs.addAttribute("DATATYPE", rt.getDisplayName());
            attrs.addAttribute("DATATYPE_NAMESPACE", rt.getCategoryPath().getPath());
            attrs.addAttribute("SIZE", rt.getLength(), true);
            writer.startElement("RETURN_TYPE", attrs);
            writer.endElement("RETURN_TYPE");
        }
        ParameterDefinition[] vars = func.getArguments();
        for (int i = 0; i < vars.length; ++i) {
            this.writerParameter(writer, vars[i], i);
        }
        writer.endElement("FUNCTION_DEF");
    }

    private void writerParameter(XmlWriter writer, ParameterDefinition var, int ordinal) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("ORDINAL", ordinal, true);
        DataType dt = var.getDataType();
        if (dt != null) {
            attrs.addAttribute("DATATYPE", dt.getDisplayName());
            attrs.addAttribute("DATATYPE_NAMESPACE", dt.getCategoryPath().getPath());
            attrs.addAttribute("NAME", var.getName());
            attrs.addAttribute("SIZE", var.getLength(), true);
            writer.startElement("PARAMETER", attrs);
            this.writeRegularComment(writer, var.getComment());
            writer.endElement("PARAMETER");
        } else {
            Msg.error((Object)this, (Object)("Parameter data type not found " + var));
        }
    }

    private void writeRegularComment(XmlWriter writer, String comment) {
        if (comment != null && comment.length() > 0) {
            writer.writeElement("REGULAR_CMT", null, comment);
        }
    }

    private void writeTypeDef(XmlWriter writer, TypeDef def) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", def.getName());
        attrs.addAttribute("NAMESPACE", def.getCategoryPath().getPath());
        DataType dt = def.getDataType();
        attrs.addAttribute("DATATYPE", dt.getDisplayName());
        attrs.addAttribute("DATATYPE_NAMESPACE", dt.getCategoryPath().getPath());
        writer.startElement("TYPE_DEF", attrs);
        writer.endElement("TYPE_DEF");
    }

    private void writeStructure(XmlWriter writer, Structure struct) {
        DataTypeComponent[] members;
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", struct.getDisplayName());
        attrs.addAttribute("NAMESPACE", struct.getCategoryPath().getPath());
        attrs.addAttribute("SIZE", struct.isNotYetDefined() ? 0 : struct.getLength(), true);
        writer.startElement("STRUCTURE", attrs);
        this.writeRegularComment(writer, struct.getDescription());
        for (DataTypeComponent member : members = struct.getComponents()) {
            this.writerMember(writer, member);
        }
        writer.endElement("STRUCTURE");
    }

    private void writeUnion(XmlWriter writer, Union union) {
        DataTypeComponent[] members;
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("NAME", union.getDisplayName());
        attrs.addAttribute("NAMESPACE", union.getCategoryPath().getPath());
        attrs.addAttribute("SIZE", union.isNotYetDefined() ? 0 : union.getLength(), true);
        writer.startElement("UNION", attrs);
        this.writeRegularComment(writer, union.getDescription());
        for (DataTypeComponent member : members = union.getComponents()) {
            this.writerMember(writer, member);
        }
        writer.endElement("UNION");
    }

    private void writerMember(XmlWriter writer, DataTypeComponent member) {
        XmlAttributes attrs = new XmlAttributes();
        attrs.addAttribute("OFFSET", member.getOffset(), true);
        attrs.addAttribute("DATATYPE", member.getDataType().getDisplayName());
        attrs.addAttribute("DATATYPE_NAMESPACE", member.getDataType().getCategoryPath().getPath());
        if (member.getFieldName() != null) {
            attrs.addAttribute("NAME", member.getFieldName());
        }
        attrs.addAttribute("SIZE", member.getLength(), true);
        writer.startElement("MEMBER", attrs);
        this.writeRegularComment(writer, member.getComment());
        DisplaySettingsHandler.writeSettings(writer, member.getDefaultSettings());
        writer.endElement("MEMBER");
    }

    public static void writeAsXMLForDebug(DataTypeManager dataManager, String outputFilename) throws IOException {
        if (!((String)outputFilename).endsWith(".xml")) {
            outputFilename = (String)outputFilename + ".xml";
        }
        File file = new File((String)outputFilename);
        XmlWriter writer = new XmlWriter(file, "PROGRAM.DTD");
        MessageLog log = new MessageLog();
        DataTypesXmlMgr mgr = new DataTypesXmlMgr(dataManager, log);
        try {
            mgr.write(writer, TaskMonitorAdapter.DUMMY_MONITOR);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        writer.close();
    }

    static {
        foreignTypedefs.put("ascii", (DataType)CharDataType.dataType);
        foreignTypedefs.put("string1", (DataType)PascalString255DataType.dataType);
        foreignTypedefs.put("string2", (DataType)PascalStringDataType.dataType);
        foreignTypedefs.put("unicode2", (DataType)PascalUnicodeDataType.dataType);
        foreignTypedefs.put("tbyte", (DataType)LongDoubleDataType.dataType);
        foreignTypedefs.put("3byte", (DataType)UnsignedInteger3DataType.dataType);
    }
}

