/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.methods;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class CliMethodDef
implements StructConverter {
    public static final String PATH = "/PE/CLI/Methods/MethodDefs";
    private Address addr;
    private boolean isFatHeader;
    private boolean hasMoreSections;
    private boolean initLocals;
    private int maxStack;
    private int methodSize;
    private int localVarSigTok;
    private static final byte CorILMethod_TinyFormat = 2;
    private static final byte CorILMethod_FatFormat = 3;
    private static final byte CorILMethod_MoreSects = 8;
    private static final byte CorILMethod_InitLocals = 16;

    public CliMethodDef(Address addr, BinaryReader reader) throws IOException {
        this.addr = addr;
        byte one = reader.readNextByte();
        if ((one & 3) == 3) {
            this.isFatHeader = true;
            if ((one & 8) == 8) {
                this.hasMoreSections = true;
            }
            if ((one & 0x10) == 16) {
                this.initLocals = true;
            }
            byte two = reader.readNextByte();
            this.maxStack = reader.readNextShort();
            this.methodSize = reader.readNextInt();
            this.localVarSigTok = reader.readNextInt();
        } else if ((one & 2) == 2) {
            this.isFatHeader = false;
            this.hasMoreSections = false;
            this.initLocals = false;
            this.maxStack = 8;
            this.methodSize = (one & 0xFFFFFFFC & 0xFF) >> 2;
        }
    }

    private void fillTinyHeaderType(Structure struct) {
        struct.add(BYTE, "Size+Flags", "L.S. Bits 0:1 Flags, Bits 2:7 Size of method in Bytes");
    }

    private void fillFatHeaderType(Structure struct) {
        struct.add(WORD, "Size+Flags", "L.S. Bits 0:3 Size of hdr in B, Bits 4:15 Flags");
        struct.add(WORD, "MaxStack", "Maximum number of items on the operand stack");
        struct.add(DWORD, "CodeSize", "Size of actual method body in B");
        struct.add(DWORD, "LocalVarSigTok", "Signature for the local variables of the method. 0 means no locals. References standalone signature in Metadata tables, which references #Blob heap.");
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath(PATH), "MethodDefHdr_" + this.addr, 0);
        if (this.isFatHeader) {
            this.fillFatHeaderType((Structure)struct);
        } else {
            this.fillTinyHeaderType((Structure)struct);
        }
        return struct;
    }

    public int getMethodSize() {
        return this.methodSize;
    }

    public boolean hasMoreSections() {
        return this.hasMoreSections;
    }
}

