/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.combobox.GComboBox;
import docking.widgets.label.GDLabel;
import generic.util.WindowUtilities;
import ghidra.framework.preferences.Preferences;
import ghidra.util.NumericUtilities;
import ghidra.util.SystemUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class AskDialog<T>
extends DialogComponentProvider {
    public static final int STRING = 0;
    public static final int INT = 1;
    public static final int LONG = 2;
    public static final int DOUBLE = 3;
    public static final int BYTES = 4;
    private int type;
    private boolean isCanceled;
    private JLabel label;
    private JTextField textField;
    private JComboBox<?> comboField;
    private KeyListener keyListener;

    protected AskDialog(String dialogTitle, String message, int type) {
        this(null, dialogTitle, message, type, null, null);
    }

    public AskDialog(String dialogTitle, String message, int type, Object defaultValue) {
        this(null, dialogTitle, message, type, null, defaultValue);
    }

    public AskDialog(Component parent, String title, String message, int type) {
        this(parent, title, message, type, null, null);
    }

    public AskDialog(Component parent, String title, String message, int type, List<T> choices, Object defaultValue) {
        super(title, true, true, true, false);
        this.type = type;
        this.keyListener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 10) {
                    AskDialog.this.okCallback();
                }
            }
        };
        JPanel panel = new JPanel(new BorderLayout(10, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.label = new GDLabel(message);
        panel.add((Component)this.label, "West");
        if (choices == null) {
            this.textField = new JTextField(20);
            this.textField.setName("JTextField");
            this.textField.addKeyListener(this.keyListener);
            this.textField.setText(defaultValue == null ? "" : defaultValue.toString());
            this.textField.selectAll();
            panel.add((Component)this.textField, "Center");
        } else {
            this.comboField = new GComboBox(choices.toArray(new Object[choices.size()]));
            this.comboField.setEditable(false);
            this.comboField.setName("JComboBox");
            if (defaultValue != null) {
                this.comboField.setSelectedItem(defaultValue);
            }
            panel.add(this.comboField, "Center");
        }
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
        this.setDefaultButton(this.okButton);
        this.setRememberSize(false);
        SystemUtilities.runSwingNow(() -> DockingWindowManager.showDialog((Component)parent, (DialogComponentProvider)this));
    }

    private void saveCurrentDimensions() {
        Rectangle bounds = this.getBounds();
        Window window = WindowUtilities.windowForComponent((Component)this.getComponent());
        if (window != null) {
            Point location = window.getLocation();
            bounds.x = location.x;
            bounds.y = location.y;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(bounds.x).append(":");
        buffer.append(bounds.y).append(":");
        buffer.append(bounds.width).append(":");
        buffer.append(bounds.height).append(":");
        Preferences.setProperty((String)"Ask Dialog Bounds", (String)buffer.toString());
    }

    public T getChoiceValue() {
        if (this.comboField == null) {
            throw new IllegalStateException("Cannot call getChoiceValue() when using a dialog without choices");
        }
        return (T)this.comboField.getSelectedItem();
    }

    public String getTextFieldValue() {
        if (this.textField == null) {
            throw new IllegalStateException("Cannot call getTextFieldValue() when using a dialog with multiple choices");
        }
        return this.textField.getText();
    }

    protected void okCallback() {
        this.isCanceled = false;
        if (this.comboField != null) {
            if (this.comboField.getSelectedIndex() < 0) {
                this.setStatusText("Please make a selection from the pulldown choices.");
                return;
            }
        } else {
            switch (this.type) {
                case 0: {
                    if (this.textField.getText().length() != 0) break;
                    this.setStatusText("Please enter a valid STRING.");
                    return;
                }
                case 1: {
                    try {
                        this.getValueAsInt();
                        break;
                    }
                    catch (Exception e) {
                        this.setStatusText("Please enter a valid INTEGER.");
                        return;
                    }
                }
                case 2: {
                    try {
                        this.getValueAsLong();
                        break;
                    }
                    catch (Exception e) {
                        this.setStatusText("Please enter a valid LONG.");
                        return;
                    }
                }
                case 3: {
                    try {
                        this.getValueAsDouble();
                        break;
                    }
                    catch (Exception e) {
                        this.setStatusText("Please enter a valid DOUBLE.");
                        return;
                    }
                }
                case 4: {
                    if (this.isValidBytePattern()) break;
                    this.setStatusText("Please enter a valid BYTE PATTERN separated by spaces.");
                    return;
                }
            }
        }
        this.saveCurrentDimensions();
        this.close();
    }

    private boolean isValidBytePattern() {
        String text = this.getValueAsString();
        if (text == null) {
            return false;
        }
        try {
            NumericUtilities.convertStringToBytes((String)text);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected void cancelCallback() {
        this.isCanceled = true;
        this.saveCurrentDimensions();
        this.close();
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private Object getValue() {
        if (this.comboField != null) {
            return this.comboField.getSelectedItem();
        }
        return this.textField.getText();
    }

    public String getValueAsString() {
        Object val = this.getValue();
        if ("".equals(val)) {
            return null;
        }
        return val != null ? val.toString() : null;
    }

    protected Integer getValueAsInt() {
        String text = this.getValueAsString();
        if (text == null) {
            return null;
        }
        if (text.startsWith("0x")) {
            return (int)NumericUtilities.parseHexLong((String)text);
        }
        return (int)NumericUtilities.parseLong((String)text);
    }

    protected Long getValueAsLong() {
        String text = this.getValueAsString();
        if (text == null) {
            return null;
        }
        return NumericUtilities.parseLong((String)text);
    }

    protected Double getValueAsDouble() {
        String text = this.getValueAsString();
        if (text == null) {
            return null;
        }
        if (text.equalsIgnoreCase("pi")) {
            return Math.PI;
        }
        if (text.equalsIgnoreCase("e")) {
            return Math.E;
        }
        return new Double(text);
    }
}

