/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.searchmem.mask;

import ghidra.app.plugin.core.searchmem.mask.MaskValue;
import ghidra.app.plugin.core.searchmem.mask.SLMaskControl;
import ghidra.app.plugin.processors.sleigh.SleighDebugLogger;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.InstructionIterator;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class MaskGenerator {
    private List<MaskValue> mnemonics = new ArrayList<MaskValue>();
    private List<LinkedHashMap<MaskValue, OperandMaskValue>> ops = new ArrayList<LinkedHashMap<MaskValue, OperandMaskValue>>();
    private SLMaskControl maskControl;

    public MaskGenerator(SLMaskControl maskControl) {
        this.maskControl = maskControl;
    }

    public MaskValue getMask(Program program, ProgramSelection selection) {
        this.loadSelectedInstructions(program, selection);
        return this.getFinalMaskAndValue();
    }

    private void loadSelectedInstructions(Program program, ProgramSelection selection) {
        Instruction instr;
        Address addr;
        SleighDebugLogger logger;
        Listing listing = program.getListing();
        if (selection.getNumAddressRanges() > 1) {
            Msg.showWarn((Object)this, null, (String)"Multiple Regions Selected", (Object)"Selected instructions must be contiguous");
        }
        AddressRange addrRange = selection.getFirstRange();
        AddressSet addrSet = new AddressSet(addrRange);
        InstructionIterator iter = listing.getInstructions((AddressSetView)addrSet, true);
        while (iter.hasNext() && !(logger = new SleighDebugLogger(program, addr = (instr = iter.next()).getAddress(), SleighDebugLogger.SleighDebugMode.VERBOSE)).parseFailed()) {
            byte[] mask = logger.getInstructionMask();
            byte[] value = logger.getMaskedBytes(mask);
            MnemonicMaskValue mnemonicMask = new MnemonicMaskValue(mask, value, instr.getMnemonicString());
            this.mnemonics.add(mnemonicMask);
            CodeUnit cu = listing.getCodeUnitAt(addr);
            this.storeOperands(instr, logger, mnemonicMask, cu);
        }
    }

    private void storeOperands(Instruction instruction, SleighDebugLogger logger, MaskValue maskValue, CodeUnit cu) {
        for (int i = 1; i <= logger.getNumOperands(); ++i) {
            byte[] mask = logger.getOperandValueMask(i - 1);
            byte[] value = logger.getMaskedBytes(mask);
            if (mask == null || value == null) {
                return;
            }
            OperandMaskValue opMaskValue = new OperandMaskValue(mask, value, instruction.getDefaultOperandRepresentation(i - 1));
            if (cu.getScalar(i - 1) != null || cu.getAddress(i - 1) != null) {
                opMaskValue.setConstant(true);
            }
            LinkedHashMap<Object, Object> mnemonicToOpMap = null;
            if (this.ops.size() < i) {
                mnemonicToOpMap = new LinkedHashMap();
                this.ops.add(mnemonicToOpMap);
            } else {
                mnemonicToOpMap = this.ops.get(i - 1);
            }
            mnemonicToOpMap.put(maskValue, opMaskValue);
        }
    }

    private MaskValue buildSingleInstructionMask(MaskValue mnemonic) {
        byte[] mnemonicMask = mnemonic.getMask();
        byte[] mnemonicValue = mnemonic.getValue();
        MaskValue result = new MaskValue(new byte[mnemonicMask.length], new byte[mnemonicValue.length]);
        result.orMask(mnemonicMask);
        result.orValue(mnemonicValue);
        if (!this.maskControl.useOperands()) {
            return result;
        }
        for (int i = 0; i < this.ops.size(); ++i) {
            Map opMap = this.ops.get(i);
            if (opMap == null) continue;
            OperandMaskValue op = (OperandMaskValue)opMap.get(mnemonic);
            this.addToMask(op, result);
        }
        return result;
    }

    private void addToMask(OperandMaskValue op, MaskValue result) {
        if (op == null) {
            return;
        }
        if (op.isConstant() && !this.maskControl.useConst()) {
            return;
        }
        byte[] op1Mask = op.getMask();
        byte[] op1Value = op.getValue();
        if (op1Value != null && op1Mask != null) {
            result.orMask(op1Mask);
            result.orValue(op1Value);
        }
    }

    private MaskValue combineInstructionMasks(List<byte[]> masks, List<byte[]> values, int length) {
        if (masks.size() != values.size()) {
            throw new IllegalArgumentException();
        }
        byte[] finalValueArray = new byte[length];
        byte[] finalMaskArray = new byte[length];
        int index = 0;
        for (int x = 0; x < values.size(); ++x) {
            for (int i = 0; i < values.get(x).length && index < length; ++index, ++i) {
                finalValueArray[index] = values.get(x)[i];
                finalMaskArray[index] = masks.get(x)[i];
            }
        }
        return new MaskValue(finalMaskArray, finalValueArray);
    }

    private MaskValue getFinalMaskAndValue() {
        ArrayList<byte[]> masks = new ArrayList<byte[]>();
        ArrayList<byte[]> values = new ArrayList<byte[]>();
        int totalLength = 0;
        for (int i = 0; i < this.mnemonics.size(); ++i) {
            MaskValue result = this.buildSingleInstructionMask(this.mnemonics.get(i));
            byte[] mask = result.getMask();
            byte[] value = result.getValue();
            if (value.length != mask.length) continue;
            masks.add(mask);
            values.add(value);
            totalLength += value.length;
        }
        return this.combineInstructionMasks(masks, values, totalLength);
    }

    private class OperandMaskValue
    extends MaskValue {
        private boolean constant;

        OperandMaskValue(byte[] mask, byte[] value, String textRep) {
            super(mask, value, textRep);
            this.constant = false;
        }

        void setConstant(boolean constant) {
            this.constant = constant;
        }

        boolean isConstant() {
            return this.constant;
        }
    }

    private class MnemonicMaskValue
    extends MaskValue {
        public MnemonicMaskValue(byte[] mask, byte[] value, String textRep) {
            super(mask, value, textRep);
        }
    }
}

