/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.equate;

import ghidra.app.cmd.equate.SetEquateCmd;
import ghidra.app.context.ListingActionContext;
import ghidra.app.plugin.core.equate.RenameEquateCmd;
import ghidra.framework.cmd.BackgroundCommand;
import ghidra.framework.model.DomainObject;
import ghidra.program.database.symbol.EquateManager;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.scalar.Scalar;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.util.OperandFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.UniversalID;
import ghidra.util.task.TaskMonitor;

public class CreateEquateCmd
extends BackgroundCommand {
    private CodeUnitIterator iterator;
    private String equateName;
    private boolean overwriteExisting;
    private long targetScalarValue;
    private ListingActionContext context;
    private Enum enoom;

    public CreateEquateCmd(Scalar scalar, CodeUnitIterator iter, String equateName, boolean overwriteExisting, ListingActionContext context) {
        super("Create New Equate", false, true, false);
        this.targetScalarValue = scalar.getValue();
        this.iterator = iter;
        this.equateName = equateName;
        this.overwriteExisting = overwriteExisting;
        this.context = context;
    }

    public CreateEquateCmd(Scalar scalar, CodeUnitIterator iter, Enum enoom, boolean overwriteExisting, ListingActionContext context) {
        super("Create New Equate", false, true, false);
        this.targetScalarValue = scalar.getValue();
        this.iterator = iter;
        this.overwriteExisting = overwriteExisting;
        this.context = context;
        this.enoom = enoom;
    }

    public boolean applyTo(DomainObject domain, TaskMonitor monitor) {
        while (this.iterator.hasNext() && !monitor.isCancelled()) {
            CodeUnit cu = this.iterator.next();
            if (cu instanceof Instruction) {
                this.maybeCreateEquate(domain, (Instruction)cu);
                continue;
            }
            if (!(cu instanceof Data)) continue;
            this.maybeCreateEquate(domain, (Data)cu);
        }
        return true;
    }

    private void maybeCreateEquate(DomainObject domain, Data data) {
        if (!data.isDefined()) {
            return;
        }
        Object val = data.getValue();
        if (!(val instanceof Scalar)) {
            return;
        }
        Scalar scalar = (Scalar)val;
        if (scalar.getValue() != this.targetScalarValue) {
            return;
        }
        int opIndex = this.getOperandIndex();
        this.createEquate(domain, (CodeUnit)data, opIndex, scalar);
    }

    private void maybeCreateEquate(DomainObject domain, Instruction instruction) {
        for (int opIndex = 0; opIndex < instruction.getNumOperands(); ++opIndex) {
            Object[] opObjects;
            for (Object opObject : opObjects = instruction.getOpObjects(opIndex)) {
                Scalar scalar;
                if (!(opObject instanceof Scalar) || (scalar = (Scalar)opObject).getValue() != this.targetScalarValue) continue;
                this.createEquate(domain, (CodeUnit)instruction, opIndex, scalar);
            }
        }
    }

    private void createEquate(DomainObject domain, CodeUnit codeUnit, int opIndex, Scalar scalar) {
        EquateTable equateTable = codeUnit.getProgram().getEquateTable();
        Address address = codeUnit.getAddress();
        Equate curEquate = equateTable.getEquate(address, opIndex, this.targetScalarValue);
        if (this.equateName == null && this.enoom != null) {
            this.equateName = this.generateFormattedEquateName();
        }
        if (curEquate == null) {
            SetEquateCmd cmd = new SetEquateCmd(this.equateName, address, opIndex, this.targetScalarValue);
            cmd.applyTo(domain);
        } else if (this.overwriteExisting) {
            RenameEquateCmd cmd = new RenameEquateCmd(curEquate.getName(), this.equateName, address, opIndex);
            cmd.applyTo(domain);
        }
    }

    private String generateFormattedEquateName() {
        Program program = this.context.getProgram();
        Enum enumWithId = (Enum)program.getDataTypeManager().addDataType((DataType)this.enoom, null);
        String formattedName = EquateManager.formatNameForEquate((UniversalID)enumWithId.getUniversalID(), (long)this.targetScalarValue);
        return formattedName;
    }

    private int getOperandIndex() {
        ProgramLocation location = this.context.getLocation();
        if (location instanceof OperandFieldLocation) {
            return ((OperandFieldLocation)location).getOperandIndex();
        }
        return -1;
    }
}

