/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.comments;

import ghidra.app.util.CodeUnitInfo;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableFilter;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.util.ArrayList;
import java.util.List;

public class CodeUnitInfoPasteCmd
implements Command {
    private List<CodeUnitInfo> infoList;
    private Address startAddr;
    private StringBuilder messages = new StringBuilder();
    private boolean pasteLabels;
    private boolean pasteComments;

    public CodeUnitInfoPasteCmd(Address startAddr, List<CodeUnitInfo> infoList, boolean pasteLabels, boolean pasteComments) {
        this.startAddr = startAddr;
        this.infoList = infoList;
        this.pasteLabels = pasteLabels;
        this.pasteComments = pasteComments;
    }

    public String getName() {
        return "Paste Labels/Comments";
    }

    public boolean applyTo(DomainObject obj) {
        Program program = (Program)obj;
        SymbolTable symTable = program.getSymbolTable();
        Listing listing = program.getListing();
        boolean offCutExists = false;
        for (int i = 0; i < this.infoList.size(); ++i) {
            CodeUnitInfo info = this.infoList.get(i);
            Address a = this.startAddr.add((long)info.getIndex());
            CodeUnit cu = listing.getCodeUnitAt(a);
            if (cu == null) {
                offCutExists = true;
                continue;
            }
            if (this.pasteLabels) {
                this.setFunction(listing, a, info);
                this.setLabel(listing, symTable, a, info);
            }
            if (!this.pasteComments) continue;
            this.setComments(cu, a, info);
        }
        if (offCutExists) {
            this.messages.append("Could not paste some comments/labels - address not start of code unit");
            return false;
        }
        return this.messages.length() == 0;
    }

    public String getStatusMsg() {
        return this.messages.toString();
    }

    private void setFunction(Listing listing, Address addr, CodeUnitInfo info) {
        String[] varNames;
        String[] stackVarNames;
        Function function = listing.getFunctionAt(addr);
        if (function == null) {
            return;
        }
        String fnName = info.getFunctionName();
        if (fnName != null) {
            try {
                function.setName(fnName, info.getPrimarySymbolSource());
            }
            catch (DuplicateNameException e) {
                this.messages.append("Could not set function name--duplicate name: " + fnName).append('\n');
            }
            catch (InvalidInputException e) {
                // empty catch block
            }
        }
        if ((stackVarNames = info.getStackVariableNames()).length != 0) {
            String[] stackVarComments = info.getStackVariableComments();
            SourceType[] stackVarSources = info.getStackVariableSources();
            int[] stackOffsets = info.getStackOffsets();
            int[] stackVarFirstUseOffsets = info.getStackVarFirstUseOffsets();
            Variable[] stackVars = function.getVariables(VariableFilter.STACK_VARIABLE_FILTER);
            for (int i = 0; i < stackOffsets.length; ++i) {
                Variable var = this.findStackVar(stackVars, stackOffsets[i], stackVarFirstUseOffsets[i]);
                if (var == null) continue;
                try {
                    var.setName(stackVarNames[i], stackVarSources[i]);
                }
                catch (DuplicateNameException e) {
                    this.messages.append("Could not set stack variable name--duplicate name: " + fnName).append('\n');
                }
                catch (InvalidInputException e) {
                    // empty catch block
                }
                if (stackVarComments[i] == null) continue;
                var.setComment(stackVarComments[i]);
            }
        }
        if ((varNames = info.getVariableNames()).length != 0) {
            String[] varComments = info.getVariableComments();
            SourceType[] varSources = info.getVariableSources();
            Address[] varAddrs = info.getVarAddresses();
            int[] regVarFirstUseOffsets = info.getVarFirstUseOffsets();
            Variable[] vars = function.getAllVariables();
            for (int i = 0; i < varAddrs.length; ++i) {
                Variable var = this.findVar(vars, varAddrs[i], regVarFirstUseOffsets[i]);
                if (var == null) continue;
                try {
                    var.setName(varNames[i], varSources[i]);
                }
                catch (DuplicateNameException e) {
                    this.messages.append("Could not set variable name--duplicate name: " + fnName).append('\n');
                }
                catch (InvalidInputException invalidInputException) {
                    // empty catch block
                }
                if (varComments[i] == null) continue;
                var.setComment(varComments[i]);
            }
        }
    }

    private Variable findStackVar(Variable[] stackVars, int stackOffset, int firstUseOffset) {
        for (int k = 0; k < stackVars.length; ++k) {
            Variable var = stackVars[k];
            if (stackOffset != var.getStackOffset() || firstUseOffset != var.getFirstUseOffset()) continue;
            return var;
        }
        return null;
    }

    private Variable findVar(Variable[] vars, Address storageAddr, int firstUseOffset) {
        for (int k = 0; k < vars.length; ++k) {
            Variable var = vars[k];
            Varnode varnode = var.getVariableStorage().getFirstVarnode();
            if (varnode == null || firstUseOffset != var.getFirstUseOffset() || !storageAddr.equals((Object)varnode.getAddress())) continue;
            return var;
        }
        return null;
    }

    private void setLabel(Listing listing, SymbolTable symTable, Address addr, CodeUnitInfo info) {
        if (!info.hasSymbols()) {
            return;
        }
        Function function = listing.getFunctionContaining(addr);
        Namespace scope = null;
        if (function != null) {
            scope = symTable.getNamespace(addr);
        }
        boolean functionExists = function != null;
        String primaryName = info.getPrimarySymbolName();
        if (primaryName != null) {
            Symbol s = symTable.getPrimarySymbol(addr);
            try {
                SourceType newSource = info.getPrimarySymbolSource();
                if (newSource != SourceType.DEFAULT) {
                    if (s == null || s.isDynamic() || s.getSource() != SourceType.DEFAULT && !s.getName().equals(primaryName)) {
                        s = symTable.createLabel(addr, primaryName, scope, newSource);
                    } else {
                        s.setName(primaryName, newSource);
                    }
                }
            }
            catch (DuplicateNameException e) {
                this.messages.append("Could not set label name--duplicate name: " + primaryName).append('\n');
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("CodeUnitInfoEdit: Bad symbol name: '" + primaryName + "'"), (Throwable)e);
                return;
            }
        }
        if (functionExists) {
            this.createSymbols(symTable, addr, info.getFunctionScopeSymbolNames(), scope, info.getFunctionScopeSymbolSources());
        }
        this.createSymbols(symTable, addr, info.getOtherSymbolNames(), null, info.getOtherSymbolSources());
    }

    private void createSymbols(SymbolTable symTable, Address addr, String[] symbolNames, Namespace scope, SourceType[] symbolSources) {
        for (int i = 0; i < symbolNames.length; ++i) {
            try {
                symTable.createLabel(addr, symbolNames[i], scope, symbolSources[i]);
                continue;
            }
            catch (InvalidInputException e) {
                Msg.error((Object)this, (Object)("CodeUnitInfoEdit: Bad symbol name: '" + symbolNames[i] + "'"), (Throwable)e);
            }
        }
    }

    private void setComments(CodeUnit cu, Address addr, CodeUnitInfo info) {
        String[] oldComment;
        String[] plateComment = info.getPlateComment();
        String[] preComment = info.getPreComment();
        String[] postComment = info.getPostComment();
        String[] eolComment = info.getEOLComment();
        String[] repeatableComment = info.getRepeatableComment();
        if (plateComment != null) {
            oldComment = cu.getCommentAsArray(3);
            cu.setCommentAsArray(3, this.appendComment(oldComment, plateComment));
        }
        if (preComment != null) {
            oldComment = cu.getCommentAsArray(1);
            cu.setCommentAsArray(1, this.appendComment(oldComment, preComment));
        }
        if (postComment != null) {
            oldComment = cu.getCommentAsArray(2);
            cu.setCommentAsArray(2, this.appendComment(oldComment, postComment));
        }
        if (eolComment != null) {
            oldComment = cu.getCommentAsArray(0);
            cu.setCommentAsArray(0, this.appendComment(oldComment, eolComment));
        }
        if (repeatableComment != null) {
            oldComment = cu.getCommentAsArray(4);
            cu.setCommentAsArray(4, this.appendComment(oldComment, repeatableComment));
        }
    }

    private String[] appendComment(String[] comment1, String[] comment2) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        for (i = 0; i < comment2.length; ++i) {
            list.add(comment2[i]);
        }
        for (i = 0; i < comment1.length; ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (!comment1[i].equals(list.get(j))) continue;
                list.remove(j);
                --j;
            }
        }
        comment2 = new String[list.size()];
        comment2 = list.toArray(comment2);
        String[] comment = new String[comment1.length + comment2.length];
        System.arraycopy(comment1, 0, comment, 0, comment1.length);
        System.arraycopy(comment2, 0, comment, comment1.length, comment2.length);
        return comment;
    }
}

