/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.yajsw.controller.jvm;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import java.net.InetAddress;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.rzo.yajsw.controller.AbstractController;
import org.rzo.yajsw.controller.Message;
import org.rzo.yajsw.controller.jvm.ControllerPipelineFactory;
import org.rzo.yajsw.os.Process;
import org.rzo.yajsw.util.Cycler;
import org.rzo.yajsw.util.DaemonThreadFactory;
import org.rzo.yajsw.util.Utils;
import org.rzo.yajsw.wrapper.WrappedJavaProcess;
import org.rzo.yajsw.wrapper.WrappedProcess;

public class JVMController
extends AbstractController {
    static final int STATE_UNKNOWN = 0;
    static final int STATE_WAITING = 1;
    static final int STATE_ESTABLISHED = 2;
    static final int STATE_LOGGED_ON = 3;
    public static final int STATE_STARTUP_TIMEOUT = 4;
    public static final int STATE_WAITING_CLOSED = 5;
    public static final int STATE_USER_STOP = 6;
    public static final int STATE_PING_TIMEOUT = 7;
    public static final int STATE_PROCESS_KILLED = 8;
    public static final int STATE_THRESHOLD = 9;
    int _port = 15003;
    int _minPort = 15003;
    int _maxPort = 65535;
    int _startupTimeout = 30000;
    String _key;
    int _pingTimeout = 10;
    volatile boolean _pingOK = false;
    static Executor _pingExecutor = Executors.newCachedThreadPool(new DaemonThreadFactory("pinger"));
    final AtomicReference<Channel> _channel = new AtomicReference();
    ServerBootstrap _acceptor = null;
    volatile Channel _parentChannel;
    boolean _init = false;
    static final Set _usedPorts = Collections.synchronizedSet(new TreeSet());
    private static final ScheduledThreadPoolExecutor _scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, new DaemonThreadFactory("controller.scheduler"));
    volatile ScheduledFuture<?> _timeoutHandle;
    Cycler _pingCheck;
    Runnable _serviceStartupListener;
    float _heap = -1.0f;
    long _minGC = -1L;
    long _fullGC = -1L;
    long _heapInBytes = -1L;
    EventLoopGroup _bossGroup = new OioEventLoopGroup();
    EventLoopGroup _workerGroup = new OioEventLoopGroup();
    volatile boolean _bound = false;
    private volatile boolean _waitingForProcessTermination = false;
    private float _maxHeapRestart = -1.0f;
    private long _maxFullGCTimeRestart = -1L;

    public JVMController(WrappedProcess wrappedJavaProcess) {
        super(wrappedJavaProcess);
        ControllerPipelineFactory pipelineFactory = new ControllerPipelineFactory(this);
        this.setDebug(((WrappedJavaProcess)wrappedJavaProcess).getDebug());
        pipelineFactory.setDebug(this._debug > 2);
        this._acceptor = ((ServerBootstrap)new ServerBootstrap().group(this._bossGroup, this._workerGroup).channel(OioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childHandler((ChannelHandler)pipelineFactory);
    }

    public void init() {
        if (this._pingCheck == null) {
            this._pingCheck = new Cycler(this._pingTimeout, this._pingTimeout, _pingExecutor, new Runnable(){
                int r = 2;

                @Override
                public void run() {
                    if (!JVMController.this._pingOK) {
                        JVMController.this.getLog().info("Missing wrapper ping within timeout of " + JVMController.this._pingTimeout);
                        executor.execute(new Runnable(){

                            @Override
                            public void run() {
                                JVMController.this.stop(7, "PING_TIMEOUT");
                            }
                        });
                    } else {
                        JVMController.this._pingOK = false;
                    }
                }
            });
        }
    }

    private void initInternal() {
        this._init = true;
    }

    @Override
    public boolean start() {
        if (this._bound) {
            this.setState(1);
            return true;
        }
        int myPort = -1;
        InetAddress address = null;
        try {
            address = Utils.getLoopbackAddress();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            myPort = Integer.parseInt((String)System.getProperties().get("wrapper.port"));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (myPort != -1) {
            _usedPorts.add(myPort);
        }
        try {
            this.initInternal();
            this.setState(0);
            if (this._parentChannel != null && this._parentChannel.isActive()) {
                this.setState(1);
                if (this.getDebug() > 2) {
                    this.getLog().info("binding successfull");
                }
                return true;
            }
            this._port = this._minPort;
            while (this.getState() < 1 && this._port <= this._maxPort) {
                if (_usedPorts.contains(this._port)) {
                    ++this._port;
                    continue;
                }
                try {
                    ChannelFuture f;
                    _usedPorts.add(this._port);
                    if (this.getDebug() > 2) {
                        this.getLog().info("binding to port " + this._port);
                    }
                    if (!(f = this._acceptor.bind(address, this._port).sync()).isSuccess()) continue;
                    this._parentChannel = f.channel();
                    this.setState(1);
                    this._bound = true;
                    if (this.getDebug() > 2) {
                        this.getLog().info("binding successfull");
                    }
                    return true;
                }
                catch (Exception ex) {
                    if (this._debug > 2) {
                        this.getLog().info("binding error: " + ex.getMessage() + " -> retry with another port");
                    }
                    _usedPorts.remove(this._port);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        this.getLog().info("sleep interrupted in JVMcontroller start");
                        Thread.currentThread().interrupt();
                        return false;
                    }
                    ++this._port;
                }
            }
            this.getLog().severe("could not find a free port in the range " + this._minPort + "..." + this._maxPort);
            return false;
        }
        catch (Exception ex) {
            this.getLog().severe("JVMController start " + ex);
            return false;
        }
    }

    @Override
    public void beginWaitForStartup() {
        if (this._startupTimeout <= 0) {
            return;
        }
        Runnable timeOutAction = new Runnable(){
            int r = 1;

            @Override
            public void run() {
                if (JVMController.this.getDebug() > 1) {
                    JVMController.this.getLog().severe("WrapperManger did not log on within timeout of " + JVMController.this._startupTimeout);
                }
                JVMController.this.stop(4, "STARTUP_TIMEOUT");
            }
        };
        this._timeoutHandle = _scheduler.schedule(timeOutAction, (long)this._startupTimeout, TimeUnit.MILLISECONDS);
    }

    void schedulePingCheck() {
        this._pingOK = false;
        this._pingCheck.start();
    }

    void stopPingCheck() {
        if (this._pingCheck != null) {
            this._pingCheck.stop();
        }
    }

    void pingReceived() {
        this._pingOK = true;
        if (this._channel.get() != null) {
            this._channel.get().writeAndFlush((Object)new Message(103, null));
        }
    }

    void serviceStartup() {
        this._wrappedProcess.setAppReportedReady(true);
        if (this._serviceStartupListener != null) {
            this._serviceStartupListener.run();
        } else {
            this.getLog().info("cannot report service startup: listener is null");
        }
    }

    @Override
    public void stop(int state, String reason) {
        this.stopPingCheck();
        if (this._timeoutHandle != null) {
            this._timeoutHandle.cancel(true);
        }
        _scheduler.purge();
        this.setState(state);
        if (this._parentChannel != null) {
            int i = 0;
            while (this._channel.get() != null && this._channel.get().isActive() && i < 3) {
                ++i;
                if (this._debug > 1) {
                    this.getLog().info("controller sending a stop command");
                }
                if (this._channel.get() != null) {
                    String txt = null;
                    if (reason != null && reason.length() > 0) {
                        txt = ":" + reason;
                    }
                    this._channel.get().writeAndFlush((Object)new Message(101, txt));
                }
                try {
                    Thread.sleep(200L);
                }
                catch (Exception ex) {}
            }
            this.closeChannel();
        }
    }

    void startupOK() {
        if (this._timeoutHandle == null) {
            return;
        }
        this._timeoutHandle.cancel(false);
        this.schedulePingCheck();
        this._timeoutHandle = null;
    }

    public static void main(String[] args) {
        JVMController c = new JVMController(null);
        c.setDebug(3);
        c.setKey("123");
        c.setMinPort(15003);
        c.start();
        c.stop(0, null);
        JVMController c1 = new JVMController(null);
        c1.setDebug(3);
        c1.setKey("123");
        c1.start();
    }

    public int getPort() {
        return this._port;
    }

    public void setMinPort(int port) {
        if (port > 0 && port < 65536) {
            this._minPort = port;
        } else {
            this.getLog().info("port out of range " + port);
        }
    }

    public void setMaxPort(int port) {
        if (port > 0 && port < 65536 && port >= this._minPort) {
            this._maxPort = port;
        } else {
            this.getLog().info("port out of range " + port);
        }
    }

    public void setPort(int port) {
        this._port = port;
    }

    int getDebug() {
        return this._debug;
    }

    @Override
    public void setDebugComm(boolean debug) {
        this._debugComm = debug;
    }

    public String getKey() {
        return this._key;
    }

    public void setKey(String key) {
        this._key = key;
    }

    int getStartupTimeout() {
        return this._startupTimeout;
    }

    public void setStartupTimeout(int startupTimeout) {
        this._startupTimeout = startupTimeout;
    }

    int getPingTimeout() {
        return this._pingTimeout;
    }

    public void setPingTimeout(int pingTimeout) {
        this._pingTimeout = pingTimeout;
    }

    public boolean waitFor(long timeout) {
        long end = System.currentTimeMillis() + timeout;
        while (this._state != 3) {
            if (this._state == 4) {
                return false;
            }
            if (System.currentTimeMillis() > end) {
                return false;
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.getLog().info("sleep interrupted in JVMController.waitfor");
                return false;
            }
        }
        return true;
    }

    public void requestThreadDump() {
        if (this._channel.get() != null) {
            this._channel.get().writeAndFlush((Object)new Message(118, null));
        }
    }

    public void requestGc() {
        if (this._channel.get() != null) {
            this._channel.get().writeAndFlush((Object)new Message(120, null));
        }
    }

    public void requestDumpHeap(String fileName) {
        if (this._channel.get() != null) {
            this._channel.get().writeAndFlush((Object)new Message(121, fileName));
        }
    }

    @Override
    public void reset() {
        this.stop(0, "RESTART");
        this._heap = -1.0f;
        this._minGC = -1L;
        this._fullGC = -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() throws Throwable {
        try {
            this.reset();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void processStarted() {
        int waitCounter = 0;
        while (this._waitingForProcessTermination) {
            try {
                this.getLog().info("should not happen: waiting for termination thread");
                if (waitCounter < 100) {
                    this.getLog().info("should not happen: waiting for termination thread");
                }
                Thread.sleep(200L);
                if (++waitCounter == 1000) {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            JVMController.this._wrappedProcess.restart();
                        }
                    });
                }
                return;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this._waitingForProcessTermination = true;
        executor.execute(new Runnable(){
            int r = 3;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Process osProcess;
                try {
                    osProcess = ((WrappedJavaProcess)JVMController.this._wrappedProcess)._osProcess;
                    if (JVMController.this._debug > 2) {
                        JVMController.this.getLog().info("waiting for termination of process");
                    }
                    if (osProcess != null) {
                        osProcess.waitFor();
                    }
                    if (JVMController.this._debug > 1) {
                        JVMController.this.getLog().info("process terminated");
                    }
                }
                finally {
                    JVMController.this._waitingForProcessTermination = false;
                }
                JVMController.this._wrappedProcess.osProcessTerminated();
                if (JVMController.this._state == 3 || JVMController.this._state == 5 || osProcess == null || osProcess.isTerminated()) {
                    JVMController.this.stopPingCheck();
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            JVMController.this.setState(8);
                        }
                    });
                }
            }
        });
    }

    @Override
    public String stateAsStr(int state) {
        switch (state) {
            case 0: {
                return "UNKNOWN";
            }
            case 1: {
                return "WAITING";
            }
            case 2: {
                return "ESTABLISHED";
            }
            case 3: {
                return "LOGGED_ON";
            }
            case 4: {
                return "STARTUP_TIMEOUT";
            }
            case 5: {
                return "WAITING_CLOSED";
            }
            case 6: {
                return "USER_STOP";
            }
            case 7: {
                return "PING_TIMEOUT";
            }
            case 8: {
                return "PROCESS_KILLED";
            }
            case 9: {
                return "THRESHOLD";
            }
        }
        return "?";
    }

    @Override
    public void logStateChange(int state) {
        if (state == 4) {
            this.getLog().warning("startup of java application timed out. if this is due to server overload consider increasing wrapper.startup.timeout");
        } else if (state == 7) {
            this.getLog().warning("ping between java application and wrapper timed out. if this this is due to server overload consider increasing wrapper.ping.timeout");
        }
    }

    @Override
    public void processFailed() {
        this.stop(8, null);
    }

    public void setServiceStartupListener(Runnable serviceStartupListener) {
        this._serviceStartupListener = serviceStartupListener;
    }

    private void restartProcess() {
        executor.execute(new Runnable(){
            int r = 4;

            @Override
            public void run() {
                JVMController.this.stop(9, "THRESHOLD");
            }
        });
    }

    public void setHeap(float heap, long minGC, long fullGC, long heapInBytes) {
        this._heap = heap;
        this._minGC = minGC;
        this._fullGC = fullGC;
        this._heapInBytes = heapInBytes;
        if (this._heap > -1.0f && this._heap > this._maxHeapRestart && this._maxHeapRestart > 0.0f) {
            this.getLog().warning("restarting due to heap threshold : " + this._heap + " > " + this._maxHeapRestart);
            this.restartProcess();
        } else if (this._fullGC > -1L && this._fullGC > this._maxFullGCTimeRestart && this._maxFullGCTimeRestart > 0L) {
            this.getLog().warning("restarting due to gc duration threshold : " + this._fullGC + " > " + this._maxFullGCTimeRestart);
            this.restartProcess();
        }
    }

    public float getHeap() {
        return this._heap;
    }

    public long getMinGC() {
        return this._minGC;
    }

    public long getFullGC() {
        return this._fullGC;
    }

    public long getHeapInBytes() {
        return this._heapInBytes;
    }

    public void setMaxHeapRestart(float maxHeapRestart) {
        this._maxHeapRestart = maxHeapRestart;
    }

    public void setMaxFullGCTimeRestart(long maxFullGCTimeRestart) {
        this._maxFullGCTimeRestart = maxFullGCTimeRestart;
    }

    public synchronized void closeChannel() {
        if (this._channel.get() != null && this._channel.get().isOpen()) {
            try {
                ChannelFuture cf = this._channel.get().close();
                Thread.yield();
                if (this.getDebug() > 1) {
                    this.getLog().info("controller close session");
                }
                cf.await(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.getLog().info("session close wait interrupted in JVMController");
            }
        }
        this._channel.set(null);
        this.setState(5);
        if (this.getDebug() > 2) {
            this.getLog().info("session closed -> waiting");
        }
    }
}

