/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.res.ChunkUtil;
import android.content.res.IntReader;
import java.io.IOException;

public class StringBlock {
    private int[] m_stringOffsets;
    private int[] m_strings;
    private int[] m_styleOffsets;
    private int[] m_styles;
    private static final int CHUNK_TYPE = 0x1C0001;

    public static StringBlock read(IntReader reader) throws IOException {
        int size;
        ChunkUtil.readCheckType(reader, 0x1C0001);
        int chunkSize = reader.readInt();
        int stringCount = reader.readInt();
        int styleOffsetCount = reader.readInt();
        reader.readInt();
        int stringsOffset = reader.readInt();
        int stylesOffset = reader.readInt();
        StringBlock block = new StringBlock();
        block.m_stringOffsets = reader.readIntArray(stringCount);
        if (styleOffsetCount != 0) {
            block.m_styleOffsets = reader.readIntArray(styleOffsetCount);
        }
        if ((size = (stylesOffset == 0 ? chunkSize : stylesOffset) - stringsOffset) % 4 != 0) {
            throw new IOException("String data size is not multiple of 4 (" + size + ").");
        }
        block.m_strings = reader.readIntArray(size / 4);
        if (stylesOffset != 0) {
            size = chunkSize - stylesOffset;
            if (size % 4 != 0) {
                throw new IOException("Style data size is not multiple of 4 (" + size + ").");
            }
            block.m_styles = reader.readIntArray(size / 4);
        }
        return block;
    }

    public int getCount() {
        return this.m_stringOffsets != null ? this.m_stringOffsets.length : 0;
    }

    public String getString(int index) {
        if (index < 0 || this.m_stringOffsets == null || index >= this.m_stringOffsets.length) {
            return null;
        }
        int offset = this.m_stringOffsets[index];
        int length = StringBlock.getShort(this.m_strings, offset);
        StringBuilder result = new StringBuilder(length);
        while (length != 0) {
            result.append((char)StringBlock.getShort(this.m_strings, offset += 2));
            --length;
        }
        return result.toString();
    }

    public CharSequence get(int index) {
        return this.getString(index);
    }

    public String getHTML(int index) {
        String raw = this.getString(index);
        if (raw == null) {
            return raw;
        }
        int[] style = this.getStyle(index);
        if (style == null) {
            return raw;
        }
        StringBuilder html = new StringBuilder(raw.length() + 32);
        int offset = 0;
        while (true) {
            int i = -1;
            int j = 0;
            while (j != style.length) {
                if (style[j + 1] != -1 && (i == -1 || style[i + 1] > style[j + 1])) {
                    i = j;
                }
                j += 3;
            }
            int start = i != -1 ? style[i + 1] : raw.length();
            int j2 = 0;
            while (j2 != style.length) {
                int end = style[j2 + 2];
                if (end != -1 && end < start) {
                    if (offset <= end) {
                        html.append(raw, offset, end + 1);
                        offset = end + 1;
                    }
                    style[j2 + 2] = -1;
                    html.append('<');
                    html.append('/');
                    html.append(this.getString(style[j2]));
                    html.append('>');
                }
                j2 += 3;
            }
            if (offset < start) {
                html.append(raw, offset, start);
                offset = start;
            }
            if (i == -1) break;
            html.append('<');
            html.append(this.getString(style[i]));
            html.append('>');
            style[i + 1] = -1;
        }
        return html.toString();
    }

    public int find(String string) {
        if (string == null) {
            return -1;
        }
        int i = 0;
        while (i != this.m_stringOffsets.length) {
            int offset = this.m_stringOffsets[i];
            int length = StringBlock.getShort(this.m_strings, offset);
            if (length == string.length()) {
                int j = 0;
                while (j != length) {
                    if (string.charAt(j) != StringBlock.getShort(this.m_strings, offset += 2)) break;
                    ++j;
                }
                if (j == length) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    private StringBlock() {
    }

    private int[] getStyle(int index) {
        if (this.m_styleOffsets == null || this.m_styles == null || index >= this.m_styleOffsets.length) {
            return null;
        }
        int offset = this.m_styleOffsets[index] / 4;
        int count = 0;
        int i = offset;
        while (i < this.m_styles.length) {
            if (this.m_styles[i] == -1) break;
            ++count;
            ++i;
        }
        if (count == 0 || count % 3 != 0) {
            return null;
        }
        int[] style = new int[count];
        int i2 = offset;
        int j = 0;
        while (i2 < this.m_styles.length) {
            if (this.m_styles[i2] == -1) break;
            style[j++] = this.m_styles[i2++];
        }
        return style;
    }

    private static final int getShort(int[] array, int offset) {
        int value = array[offset / 4];
        if (offset % 4 / 2 == 0) {
            return value & 0xFFFF;
        }
        return value >>> 16;
    }
}

