/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.plugintool.dialog.ExtensionDetails;
import ghidra.framework.plugintool.dialog.ExtensionTablePanel;
import java.awt.Color;
import java.awt.Point;
import javax.swing.text.SimpleAttributeSet;

class ExtensionDetailsPanel
extends AbstractDetailsPanel {
    private static SimpleAttributeSet nameAttrSet;
    private static SimpleAttributeSet descrAttrSet;
    private static SimpleAttributeSet authorAttrSet;
    private static SimpleAttributeSet createdOnAttrSet;
    private static SimpleAttributeSet versionAttrSet;
    private static SimpleAttributeSet pathAttrSet;

    ExtensionDetailsPanel(final ExtensionTablePanel tablePanel) {
        this.createFieldAttributes();
        this.createMainPanel();
        tablePanel.getTableModel().addThreadedTableModelListener(new ThreadedTableModelListener(){

            public void loadPending() {
            }

            public void loadingStarted() {
            }

            public void loadingFinished(boolean wasCancelled) {
                ExtensionDetailsPanel.this.setDescription(tablePanel.getSelectedItem());
            }
        });
        tablePanel.getTable().getSelectionModel().addListSelectionListener(e -> this.setDescription(tablePanel.getSelectedItem()));
    }

    public void setDescription(ExtensionDetails details) {
        this.clear();
        if (details == null) {
            return;
        }
        StringBuilder buffer = new StringBuilder("<HTML>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, details.getName(), nameAttrSet);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, this.formatDescription(details.getDescription()), descrAttrSet);
        this.insertRowTitle(buffer, "Author");
        this.insertRowValue(buffer, details.getAuthor(), authorAttrSet);
        this.insertRowTitle(buffer, "Created-on");
        String date = details.getCreatedOn();
        this.insertRowValue(buffer, date, createdOnAttrSet);
        this.insertRowTitle(buffer, "Version");
        String version = details.getVersion();
        if (version.equals("@extversion@")) {
            this.insertRowValue(buffer, "", versionAttrSet);
        } else {
            this.insertRowValue(buffer, version, versionAttrSet);
        }
        String installPath = details.getInstallPath();
        if (installPath != null) {
            this.insertRowTitle(buffer, "Install Path");
            this.insertRowValue(buffer, installPath, pathAttrSet);
        }
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    @Override
    protected void createFieldAttributes() {
        titleAttrSet = this.createAttributeSet(new Color(140, 0, 0));
        nameAttrSet = this.createAttributeSet(new Color(0, 204, 51));
        descrAttrSet = this.createAttributeSet(Color.BLUE);
        authorAttrSet = this.createAttributeSet(Color.BLUE);
        createdOnAttrSet = this.createAttributeSet(Color.BLUE);
        versionAttrSet = this.createAttributeSet(Color.BLUE);
        pathAttrSet = this.createAttributeSet(Color.BLUE);
    }
}

